## Accompanying materials to the Online Appendix to
## "Private returns to R\&D in the presence of spillovers, revisited"
## Forthcoming, Journal of Applied Econometrics
## Giovanni Millo, September 14th 2018

partest <- function(x, l=3, hypothesis.matrix=diag(1,l), rhs=NULL,
                    ...) {
    dname <- paste(deparse(substitute(x)))

    res <- resid(x)
    #res <- pres(x) # just in case a model be not resid()-compliant
    ## make data.frame
    res <- data.frame(ind=attr(res, "index")[1],
                      tind=attr(res, "index")[2],
                      res=as.vector(res))
    ## (should make choice of panel estimator flexible)
    resARmod <- plm(res ~ lag(res,1:l)-1, data=res,
                    model="pooling")
    ## joint test: every lag is zero (notice use of lag(., 1:l) here:
    ## lag.pseries() is vectorized!)

    partest <- lht(resARmod, hypothesis.matrix=diag(1,l) , rhs=NULL,
                   ...)

    ## 'lht' form
    ## return(partest)

    ## htest form
    stat <- partest[2, 3]
    pval <- partest[2, 4]
    df <- partest[2, 2]
    names(stat) <- dimnames(partest)[[2]][3]
    RVAL <- list(statistic = stat, df = df,
                 method =
                 paste("Panel test for serial correlation of order up to",
                       l),
                 data.name=dname, p.value = pval)
    class(RVAL) <- "htest"
    return(RVAL)
}
