## Accompanying materials to the Online Appendix to
## "Private returns to R\&D in the presence of spillovers, revisited"
## Forthcoming, Journal of Applied Econometrics
## Giovanni Millo, September 14th 2018

lrvcov <- function(x, vcov.=vcov, k=length(coef(x))) {

    ## Version for extracting coef and vcov for further processing

    ## Function for long-run unrestricted estimates:
    ## assumes coeff ordered as per comfactest.R
    ## y = Ly + x1 + Lx1 + x2 + Lx2 + ... + xK + LxK + <optional>
    require(msm)

    ## extract coefs and vcov from model object
    ## (k limits the coefs for pmg models, or if including dummies etc.)
    b <- coef(x)[1:k]
    vb <- vcov.(x)[1:k, 1:k]

    ## ToDo: k now considers the intercept, hence e.g. for pmgs one must
    ## allow for k= 2x the X, plus y, plus 1

    ## eliminate intercept if any
    if(names(b)[1] == "(Intercept)") {
        b <- b[-1]
        vb <- vb[-1,-1]
    }

    kk <- length(b)
    k <- (kk-1)/2
    lrcoefs <- vector("numeric", length=k)
    lrse <- vector("numeric", length=k)
    for(i in 1:k) {
        lrcoefs[i] <- (b[2*i]+b[2*i+1])/(1-b[1])
        }
     lrvcov <- deltamethod(list(~(x2+x3)/(1-x1), ~(x4+x5)/(1-x1),
                               ~(x6+x7)/(1-x1)),
                          b, vb, ses=FALSE)
    names(lrcoefs) <- names(b)[1:k*2]
    dimnames(lrvcov) <- list(names(lrcoefs), names(lrcoefs))

    res <- list(coef=lrcoefs, vcov=lrvcov)
    return(res)
}
