## Accompanying materials to the Online Appendix to
## "Private returns to R\&D in the presence of spillovers, revisited"
## Forthcoming, Journal of Applied Econometrics
## Giovanni Millo, September 14th 2018

## def. Fisher test function for any residual test
fishertest <- function(x, test, ...) {
    ## general wrapper for (time-series-wise) pooled diagnostic testing
    ## on panel models (any model supporting a resid() method)
    ## This version: accept a pseries (of residuals) directly, so if
    ## a model does not support resid() one can use 'pres(mod)'
    ##
    ## Usage:
    ## R> fishertest(resid(mymod),
    ## R>            test=function(x) Box.test(x, type="Ljung-Box"))
    res <- x
    ipvals <- unlist(lapply(tapply(res, attr(res, "index")[1], FUN=test),
                            '[[', 'p.value'))
    stat <- -2*sum(log(ipvals))
    pval <- pchisq(stat, df=2*length(ipvals), lower.tail=FALSE)
    ## put general htest features here
    return(list(statistic=stat, p.value=pval))
}
