clear all
set more off
cd "C:\Users\03638881\Dropbox\spacing\mc\JAE Revision 2"

qui {

**Set N, reps**
glo nobs 500
glo reps 500

**Append all results
use mcResults_2033, clear
append using mcResults_2036
append using mcResults_2045
append using mcResults_2048
save mcResults_all, replace
loc cc "2033 2036 2045 2048"

**Obtain metrics**
**Make results easy to export to Excel**
use mcResults_all, clear
tempname Formatted_Output_X 
postfile `Formatted_Output_X' Case Gamma Beta LRcoef RHOxlx RHOxa str25 Estimator PARM BIAS SD MSE CR PN ID using Formatted_Output, replace

#delimit ;
loc est "ah ab bb qdgmm qdgmmL qdgmmA qdgmmC ecre ecreL ecreA ecreC";  
#delimit cr

*gamma*
loc id = 1
loc p = 1
foreach var of loc est {
	foreach c in `cc' {
		loc k = `c'
		su gamma if case==`c'
		loc g = r(mean)
		su beta if case==`c'
		loc b = r(mean)
		su lrcoef if case==`c'
		loc lrcoef = r(mean)
		su x_lx_rho if case==`c'
		loc rx = r(mean)
		su x_a_rho if case==`c'
		loc ra = r(mean)
	
		**MEDIAN BIAS**
		gen `var'_bias = `var'_g-gamma if case==`c'
		qui su `var'_bias if case==`c', d
		loc mbias = r(p50)
		**SD**
		qui su `var'_g if case==`c'
		loc sd = r(sd)
		**MEAN SE**
		qui su `var'_g_se if case==`c'
		loc mse = r(mean)
		**COVERAGE RATE**
		qui su `var'_g_cover if case==`c'
		loc cr = r(mean)
	
		loc pn = .
	
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("`var'") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop `var'_bias 
	}
	loc id = `id'+1
}
loc mbias = .
loc sd = .
loc mse = .
loc cr = .
foreach c in `cc' {
		loc k = `c'
		su gamma if case==`c'
		loc g = r(mean)
		su beta if case==`c'
		loc b = r(mean)
		su lrcoef if case==`c'
		loc lrcoef = r(mean)
		su x_lx_rho if case==`c'
		loc rx = r(mean)
		su x_a_rho if case==`c'
		loc ra = r(mean)
		g t1=abs(qdgmm_g-gamma) if case==`c'
		g t2=abs(qdgmmA_g-gamma) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("QDGMMvQDGMMA") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(qdgmm_g-gamma) if case==`c'
		g t2=abs(qdgmmC_g-gamma) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("QDGMMvQDGMMC") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(qdgmmA_g-gamma) if case==`c'
		g t2=abs(qdgmmC_g-gamma) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("QDGMMAvQDGMMC") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(ecre_g-gamma) if case==`c'
		g t2=abs(ecreA_g-gamma) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("ECREvECREA") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(ecre_g-gamma) if case==`c'
		g t2=abs(ecreC_g-gamma) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("ECREvECREC") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(ecreA_g-gamma) if case==`c'
		g t2=abs(ecreC_g-gamma) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("ECREAvECREC") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(qdgmm_g-gamma) if case==`c'
		g t2=abs(ecre_g-gamma) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("QDGMMvECRE") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(qdgmmA_g-gamma) if case==`c'
		g t2=abs(ecreA_g-gamma) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("QDGMMAvECREA") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(qdgmmC_g-gamma) if case==`c'
		g t2=abs(ecreC_g-gamma) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("QDGMMCvECREC") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
}  

*beta*
loc id = 1
loc p = 2
foreach var of loc est {
	foreach c in `cc' {
		loc k = `c'
		su gamma if case==`c'
		loc g = r(mean)
		su beta if case==`c'
		loc b = r(mean)
		su lrcoef if case==`c'
		loc lrcoef = r(mean)
		su x_lx_rho if case==`c'
		loc rx = r(mean)
		su x_a_rho if case==`c'
		loc ra = r(mean)
	
		**MEDIAN BIAS**
		gen `var'_bias = `var'_b-beta if case==`c'
		qui su `var'_bias if case==`c', d
		loc mbias = r(p50)
		**SD**
		qui su `var'_b if case==`c'
		loc sd = r(sd)
		**MEAN SE**
		qui su `var'_b_se if case==`c'
		loc mse = r(mean)
		**COVERAGE RATE**
		qui su `var'_b_cover if case==`c'
		loc cr = r(mean)
	
		loc pn = .
	
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("`var'") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop `var'_bias 
	}	
	loc id = `id'+1
}
loc mbias = .
loc sd = .
loc mse = .
loc cr = .
foreach c in `cc' {
		loc k = `c'
		su gamma if case==`c'
		loc g = r(mean)
		su beta if case==`c'
		loc b = r(mean)
		su lrcoef if case==`c'
		loc lrcoef = r(mean)
		su x_lx_rho if case==`c'
		loc rx = r(mean)
		su x_a_rho if case==`c'
		loc ra = r(mean)
		g t1=abs(qdgmm_b-beta) if case==`c'
		g t2=abs(qdgmmA_b-beta) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("QDGMMvQDGMMA") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(qdgmm_b-beta) if case==`c'
		g t2=abs(qdgmmC_b-beta) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("QDGMMvQDGMMC") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(qdgmmA_b-beta) if case==`c'
		g t2=abs(qdgmmC_b-beta) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("QDGMMAvQDGMMC") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(ecre_b-beta) if case==`c'
		g t2=abs(ecreA_b-beta) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("ECREvECREA") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(ecre_b-beta) if case==`c'
		g t2=abs(ecreC_b-beta) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("ECREvECREC") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(ecreA_b-beta) if case==`c'
		g t2=abs(ecreC_b-beta) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("ECREAvECREC") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(qdgmm_b-beta) if case==`c'
		g t2=abs(ecre_b-beta) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("QDGMMvECRE") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(qdgmmA_b-beta) if case==`c'
		g t2=abs(ecreA_b-beta) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("QDGMMAvECREA") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(qdgmmC_b-beta) if case==`c'
		g t2=abs(ecreC_b-beta) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("QDGMMCvECREC") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
} 

*long-run coeff*
loc id = 1
loc p = 3
foreach var of loc est {
	foreach c in `cc' {
		loc k = `c'
		su gamma if case==`c'
		loc g = r(mean)
		su beta if case==`c'
		loc b = r(mean)
		su lrcoef if case==`c'
		loc lrcoef = r(mean)
		su x_lx_rho if case==`c'
		loc rx = r(mean)
		su x_a_rho if case==`c'
		loc ra = r(mean)
	
		**MEDIAN BIAS**
		gen `var'_bias = `var'_lr-lrcoef if case==`c'
		qui su `var'_bias if case==`c', d
		loc mbias = r(p50)
		**SD**
		qui su `var'_lr if case==`c'
		loc sd = r(sd)
		**MEAN SE**
		qui su `var'_lr_se if case==`c'
		loc mse = r(mean)
		**COVERAGE RATE**
		qui su `var'_lr_cover if case==`c'
		loc cr = r(mean)
	
		loc pn = .
	
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("`var'") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop `var'_bias 
	}	
	loc id = `id'+1
}
loc mbias = .
loc sd = .
loc mse = .
loc cr = .
foreach c in `cc' {
		loc k = `c'
		su gamma if case==`c'
		loc g = r(mean)
		su beta if case==`c'
		loc b = r(mean)
		su lrcoef if case==`c'
		loc lrcoef = r(mean)
		su x_lx_rho if case==`c'
		loc rx = r(mean)
		su x_a_rho if case==`c'
		loc ra = r(mean)
		g t1=abs(qdgmm_lr-lrcoef) if case==`c'
		g t2=abs(qdgmmA_lr-lrcoef) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("QDGMMvQDGMMA") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(qdgmm_lr-lrcoef) if case==`c'
		g t2=abs(qdgmmC_lr-lrcoef) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("QDGMMvQDGMMC") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(qdgmmA_lr-lrcoef) if case==`c'
		g t2=abs(qdgmmC_lr-lrcoef) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("QDGMMAvQDGMMC") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(ecre_lr-lrcoef) if case==`c'
		g t2=abs(ecreA_lr-lrcoef) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("ECREvECREA") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(ecre_lr-lrcoef) if case==`c'
		g t2=abs(ecreC_lr-lrcoef) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("ECREvECREC") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(ecreA_lr-lrcoef) if case==`c'
		g t2=abs(ecreC_lr-lrcoef) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("ECREAvECREC") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(qdgmm_lr-lrcoef) if case==`c'
		g t2=abs(ecre_lr-lrcoef) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("QDGMMvECRE") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(qdgmmA_lr-lrcoef) if case==`c'
		g t2=abs(ecreA_lr-lrcoef) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("QDGMMAvECREA") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
		g t1=abs(qdgmmC_lr-lrcoef) if case==`c'
		g t2=abs(ecreC_lr-lrcoef) if case==`c'
		count if t1<t2 & case==`c'
		loc pn = r(N)/$reps
		post `Formatted_Output_X' (`k') (`g') (`b') (`lrcoef') (`rx') (`ra') ("QDGMMCvECREC") (`p') (`mbias') (`sd') (`mse') (`cr') (`pn') (`id')
		drop t1 t2
} 
   

save mcResults_all_all, replace

postclose `Formatted_Output_X'
use Formatted_Output, clear
reshape wide BIAS SD MSE CR PN, i(Case ID Gamma Beta LRcoef RHOxlx RHOxa Estimator) j(PARM)
drop if Gamma==.
rensfix 1 g
rensfix 2 b
rensfix 3 lr
gsort +Case +ID -Estimator
save Formatted_Output, replace
use Formatted_Output, clear
drop RHO* Beta Gamma LRcoef
reshape wide BIASg BIASb BIASlr SDg SDb SDlr MSEg MSEb MSElr CRg CRb CRlr PNg PNb PNlr, i(Estimator ID) j(Case)
loc E "ID Est "
foreach i in `cc' {
	#delimit ;
	loc E "`E' 
			BIASg`i' BIASb`i' BIASlr`i' 
			SDg`i' SDb`i' SDlr`i'
			MSEg`i' MSEb`i' MSElr`i' 
			CRg`i' CRb`i' CRlr`i' " ;
	#delimit cr		
}
order `E'	
sort ID
preserve
drop if ID>11
drop PN*
save Formatted_Output_Final_T99_discX, replace
restore
#delimit ;
keep if Estimator=="QDGMMvQDGMMC" | Estimator=="ECREvECREC" |
	Estimator=="QDGMMvQDGMMA" | Estimator=="ECREvECREA" | 
	Estimator=="QDGMMAvQDGMMC" | Estimator=="ECREAvECREC" | 
	Estimator=="QDGMMvECRE" | Estimator=="QDGMMCvECREC" |
	Estimator=="QDGMMAvECREA" ;
#delimit cr
keep Est PN*
reshape long PNg PNb PNlr, i(Est) j(Case)
g n=.
replace n=1 if Estimator=="QDGMMvQDGMMA"
replace n=4 if Estimator=="QDGMMvQDGMMC" 
replace n=7 if Estimator=="QDGMMAvQDGMMC"  
replace n=2 if Estimator=="ECREvECREA" 
replace n=5 if Estimator=="ECREvECREC"  
replace n=8 if Estimator=="ECREAvECREC"
replace n=3 if Estimator=="QDGMMvECRE" 
replace n=6 if Estimator=="QDGMMAvECREA"
replace n=9 if Estimator=="QDGMMCvECREC" 
sort n Case
save Formatted_Output_Final_PN_T99_discX, replace

}
