function A = vec2symmat(V)
% Converts vector "V" to an N-by-N matrix "A"
n = length(V);
N = (-1 + sqrt(1 + 8*n))/2;
A = zeros(N);
I = [0 cumsum(1:N)];
for m = 1:N
A(1:m, m) = V(I(m)+1:I(m + 1));
end
% Insert symmetric part
for m = 1:N-1
A(m+1:N, m) = A(m, m+1:N).';
end