function V = symmat2vec(A)
% Converts a symmetric matrix "A" to a vector "V" of its significant part
N = size(A, 1);
V = zeros(N/2*(N + 1), 1);
I = [0 cumsum(1:N)];
for m = 1:N
V(I(m)+1:I(m + 1)) = A(1:m, m);
end

