function f=ma_coeffs(H,F,ss_kalman,appropj,mycols);
% The function retrieces the moving average coefficients using
% the steady state Kalman gain matrix, see section 13.5 in Hamilton(1994)
% Time Series Anlysis

H2(:,1)=ones(size(H,1),1);

for i=1:size(H2,1)
    H2(i,2)=H(i,:)*ss_kalman(i,:)';
end

for i=1:size(H2,1)
    j=2; l=3;
    while l<=appropj(i)
        jj=1;
        prem=eye(mycols);
        while jj <=j-1
            prem=prem*F;
            jj=jj+1;
        end;
        H2(i,l)=H(i,:)*prem*ss_kalman(i,:)';
        j=j+1; l=l+1;
    end
end
f=H2;

