function f=bj_serrs(ma,ss_yvar,appropj,hours,non_miss_hour);
%The function will return standard errors for the moving average 
% parameters, see section 6.3 in Lutkepohl 1993, Introduction to Mutliple
% Time Series Analysis and section 4.3.1. in Reinsel 1993, Elements of
% multivariate time series analysis

i=1;
serrs_ma=zeros(size(ma,1),size(ma,2)-1);
for i=1:size(ma,1)
    tmp=zeros(appropj(i)-1,1);
    tmp(1)=i-1;
    if tmp(1)==0 
        tmp(1)=hours; 
    end
    j=2;
    while j<=size(tmp,1)
          tmp(j)=tmp(j-1)-1;
          if tmp(j)<=0
             tmp(j)=tmp(j)+hours;
         end
         j=j+1;
     end
     tmp2=ss_yvar;
     tmpQ=ss_yvar;
     tmp2=tmp2(tmp,:);
     b=ma(i,2:appropj(i))';
     b=(b.*sqrt(tmp2))./(sqrt(tmpQ(i)));
     tmp=[b'; [eye(size(b,1)-1) zeros(size(b,1)-1,1)] ];
     mycov=tmpQ(i)*inv(eye(size(tmp,1)^2)-kron(tmp,tmp));
     mycov=reshape(mycov(:,1),size(tmp,1),size(tmp,1));
     mycov=(1/non_miss_hour(i))*tmpQ(i).*inv(mycov);
     mycov=sqrt(diag(mycov));
     if i<=23 serrs_ma(i,:)=[mycov;zeros(size(ma,2)-1-size(mycov,1),1)]'; end
     if i==23 serrs_ma(i,:)=[mycov;0]'; end
     if i==24 serrs_ma(i,:)=(mycov)'; end
end
serrs_ma=[zeros(size(serrs_ma,1),1) serrs_ma];     
f=serrs_ma;

