
# load in data
mydata<- read.table(file="c:/Interaction-data.txt", header=TRUE);

# y is dependent variable; x is regressor matrix 
y<- mydata[,1];
x<- cbind(mydata[,2:50])
 
# data check 
fix(x)
fix(y)

# run bicreg.composite 

library(BMA);

bicreg.composite <- function (x, y, wt = rep(1, length(y)), strict = FALSE, OR = 1000000, 
    maxCol = 50, drop.factor.levels = TRUE, nbest = 10) 
{
	############################################################################ 
	# PURPOSE: This function is a modified version of "bicreg" from R. It 
	# allows the user to specify a vector of dummy variables.
	# remove(objects())
	############################################################################
	# MODIFIED BY:
	# Drew D. Creal
	# 3/25/06
	# Department of Economics
	# University of Washington
	############################################################################
	# wt: vector of weights for weighted least squares
	# OR: Occam's Razor
	############################################################################
	
	dropcols <- function(x, y, wt, maxCols = 50) 
	{
        x1.ldf <- data.frame(x, y = y)
        temp.wt <- wt
        lm.out <- lm(y ~ ., data = x1.ldf, weights = temp.wt)
        form.vars <- all.vars(formula(lm.out))[-1]
        any.dropped <- FALSE
        dropped.which <- NULL
        while (length(lm.out$coefficients) > maxCol) 
			{
            any.dropped <- TRUE
            droplm <- drop1(lm.out, test = "none")
            dropped <- row.names(droplm)[which.min(droplm$RSS[-1]) + 
                1]
            dropped.index <- match(dropped, form.vars)
            form.vars <- form.vars[-dropped.index]
            formla <- formula(paste("y", "~", paste(form.vars, 
                collapse = " + "), sep = " "))
            lm.out <- lm(formla, data = x1.ldf, weights = temp.wt)
            dropped.which <- c(dropped.which, dropped)
        	}
        new.var.names <- names(lm.out$coefficients)
        return(list(mm = model.matrix(lm.out)[, -1, drop = FALSE], 
            any.dropped = any.dropped, dropped = dropped.which, 
            var.names = new.var.names))
    	}

	###################################################################################
	# This section gets rid of NAs in the data
	################################################################################### 
    	cl <- match.call()
    	x <- data.frame(x)
    	if (is.null(dimnames(x)))
	{ 
        dimnames(x) <- list(NULL, paste("X", 1:ncol(x), sep = ""))
	}
    	y <- as.numeric(y)
    	options(contrasts = c("contr.treatment", "contr.treatment"))
    	xnames <- dimnames(x)[[2]]
    	x2 <- na.omit(data.frame(x))
    	used <- match(row.names(data.frame(x)), row.names(x2))
    	omitted <- seq(nrow(x))[is.na(used)]
    	if (length(omitted) > 0) 
	{
        wt <- wt[-omitted]
        x <- x2
        y <- y[-omitted]
        warning(paste("There were ", length(omitted), "records deleted due to NA's"))
    	}

	###################################################################################
	# This section reduces the number of columns in "x" to 30 
	################################################################################### 
    	if (drop.factor.levels) 
	{
        	cdf <- cbind.data.frame(y = y, x)
        	mm <- model.matrix(formula(cdf), data = cdf)[, -1, drop = FALSE]
        	x <- mm
    	}
    	xx <- dropcols(x, y, wt, maxCol)
    	xnames <- xx$var.names[-1]
    	x <- xx$mm
    	reduced <- xx$any.dropped
    	dropped <- NULL
    	if (reduced)
	{ 
        dropped <- xx$dropped
	}
    	nvar <- length(x[1, ])

	#####################################################################################
	# This section runs the leaps algorithm that computes a set of best models from all 
	# possible sets of models.
	#####################################################################################
    	if (nvar > 2) 
	{
		# Notice that the leaps algorithm in R does not include a "keep" input as in S-Plus
        	a <- leaps(x, y, wt = wt, method = "r2", names = dimnames(x)[[2]], 
            strictly.compatible = FALSE, nbest = nbest)
		# This is a set of R_squares for the best models
        	a$r2 <- pmin(pmax(0, a$r2), 0.999)

		# Collect the data for the reference model
        	x.lm <- cbind.data.frame(y = y, as.data.frame(x[, a$which[2, 
            , drop = FALSE]]), w = wt)
		# Compute R_squared for the reference model 
        	lm.fix <- lm(y ~ . - w, weights = w, data = x.lm)
        	r2.fix <- summary(lm.fix)$r.sq

        	N <- ncol(x)
		# Compute the difference in the BIC's for the reference model.
		# This is equation (25) in Raftery and it approximates twice the
		# logarithm of the Bayes Factor.
        	magic <- N * log(1 - a$r2[2]) - N * log(1 - r2.fix)

		# These two steps readjust the R.squared for each of the models. 
        	a$r2 <- 1 - (1 - a$r2) * exp(-magic/N)
        	r2 <- round(c(0, a$r2) * 100, 3)

		# size is the number of independent variables in each of the models
		# This line adds the intercept
		size <- c(1, a$size)
		# This line adds the model with only an intercept
       	which <- rbind(rep(FALSE, ncol(x)), a$which)
       	templabs <- t(matrix(rep(colnames(which), times = nrow(which)), 
            ncol = nrow(which)))
       	templabs[!which] <- ""
       	label <- apply(templabs, 1, paste, collapse = "")
       	label[1] <- "NULL"    
	}
   	else 
	{
        	r2 <- bic <- NULL
        	nmod <- switch(ncol(x), 2, 4)
        	bic <- label <- rep(0, nmod)
        	model.fits <- as.list(rep(0, nmod))
        	which <- matrix(c(FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, 
            	TRUE, TRUE), nmod, nmod/2)
        	size <- c(1, 2, 2, 3)[1:nmod]
        	sep <- if (all(nchar(dimnames(x)[[2]]) == 1)) 
            ""
        	else ","
        	for (k in 1:nmod) 
		{
            	if (k == 1) 
			{
                		label[k] <- "NULL"
                		lm1 <- lm(y ~ 1, w = wt)
            	}
            	else 
			{
                		label[k] <- paste(dimnames(x)[[2]][which[k, ]], 
                  		collapse = sep)
                		x.lm <- cbind.data.frame(y = y, x = x[, which[k, 
                  		, drop = FALSE]], wt = wt)
                		lm1 <- lm(y ~ . - wt, data = x.lm, w = wt)
            	}
        	r2[k] <- summary(lm1)$r.sq * 100
        	}
    	}

	##################################################################################
	# Calculate the BIC for each of the models using the approximation to the
	# normal distribution. 
	##################################################################################
    	n <- length(y)
	# Note that this is equation (26) in Raftery (1995)
    	bic <- n * log(1 - r2/100) + (size - 1) * log(n)
	
	##################################################################################
	# This section calculates and applies Occam's Window 	
	##################################################################################
    	occam <- bic - min(bic) < 2 * log(OR)
	# This applies Occam's Window which eliminates many models from the overall set.
    	r2 <- r2[occam]
    	size <- size[occam]
    	label <- label[occam]
    	which <- which[occam, , drop = FALSE]
    	bic <- bic[occam]
	
	###################################################################################
	# This section calculates the posterior probability using the BIC
	###################################################################################
	# Compute the posterior model probabilities. 
	# This is equation (34) in Raftery (1995), which normalizes the probabilities
    	postprob <- exp(-0.5 * bic)/sum(exp(-0.5 * bic))
	# Replace NAs with true
    	postprob[is.na(postprob)] <- 1

	# Reorder the models from most likely to least likely using the BIC
    	order.bic <- order(bic, size, label)
    	r2 <- r2[order.bic]
    	size <- size[order.bic]
    	label <- label[order.bic]
    	which <- which[order.bic, , drop = FALSE]
    	bic <- bic[order.bic]
    	postprob <- postprob[order.bic]
	
	###################################################################################
	# If "strict=TRUE," the algorithm reduces the set of models even further by 
	# excluding those models that have better models nested within them.
	###################################################################################
    	if (strict) 
	{
        nmod <- length(bic)
        if (nmod > 1) 
		 {
            occam <- rep(TRUE, nmod)
			# Loop through each of the models
            for (k in (2:nmod)) 
			  {
                for (j in (1:(k - 1))) 
                {
                  which.diff <- which[k, ] - which[j, ]
                  if (all(which.diff >= 0))
					 { 
                    occam[k] <- FALSE
 					 }
                }
            }
            r2 <- r2[occam]
            size <- size[occam]
            label <- label[occam]
            nmod <- sum(occam)
            which <- which[occam, , drop = FALSE]
            bic <- bic[occam]
            postprob <- postprob[occam]
            postprob <- postprob/sum(postprob)
         }
    	}
	
	###############################################################################
	# This step computes the probability that the regression coefficient is not
	# equal to zero.
	###############################################################################
    	probne0 <- round(100 * t(which) %*% as.matrix(postprob),1)

	###############################################################################
	# This section calculates the expected value of each regressor for each model
	# as well as the standard deviation.
	###############################################################################	
    	nmod <- length(bic)
    	model.fits <- as.list(rep(0, nmod))
	# Loop through each of the models and calculate the OLS estimates, the standard
	# errors, the t-values, and the p-values
    	for (k in (1:nmod)) 
    	{
        	if (sum(which[k, ]) != 0) 
        	{
            	model.fits[[k]] <- ls.print(lsfit(x[, which[k, ], 
                		drop = FALSE], y, wt = wt), print.it = FALSE)$coef.table[[1]]
        	}
        	else
	  	{ 	
			# This regression runs only the intercept
	        	model.fits[[k]] <- ls.print(lsfit(rep(1, length(y)), 
            	y, wt = wt, int = FALSE), print.it = FALSE)$coef.table[[1]]
        	}
    	}

	###############################################################################
	# Calculate the covariance between the regressors for each different model
	###############################################################################
	model.cov <- as.list(rep(0,nmod))
	for(k in (1:nmod))
	{
		model.cov[[k]] <- ((ls.diag(lsfit(x[,which[k,],drop=F],y, wt = wt))$std.dev)^2)*
			(ls.diag(lsfit(x[,which[k,],drop=F],y,wt=wt))$cov.unscaled)
	} 
	covMk <- model.cov

	###############################################################################
	# This section averages over the expected values and standard deviations from 
	# each of the models just estimated.
	###############################################################################
	# storage matrices
	# Notice that the "+ 1" adds the intercept
   	Ebi <- rep(0, (nvar + 1))
    	SDbi <- rep(0, (nvar + 1))
   	CEbi <- Ebi
    	CSDbi <- SDbi
	# These matrices are for each model and each regressor
    	EbiMk <- matrix(rep(0, nmod * (nvar + 1)), nrow = nmod)
    	sebiMk <- matrix(rep(0, nmod * (nvar + 1)), nrow = nmod)
   	# Loop through each of the variables 
	for (i in 1:(nvar + 1)) 
    	{
        	if ((i == 1) || (sum(which[, (i - 1)] != 0))) 
        	{
			# Loop through each of the models
            	for (k in (1:nmod)) 
            	{
                		if ((i == 1) || (which[k, (i - 1)] == TRUE)) 
                		{
                  		if (i == 1)
                  		{ 
                    			pos <- 1
                  		}
                  		else
                  		{ 
						pos <- 1 + sum(which[k, (1:(i - 1))])
					}		
					# This is the expected value of variable i for model k
                  		EbiMk[k, i] <- model.fits[[k]][pos, 1]
					# This is the standard error of variable i for model k
                  		sebiMk[k, i] <- model.fits[[k]][pos, 2]
                		}
            	}
			# This is the expected value of variable i averaged over all models
            	Ebi[i] <- as.numeric(sum(postprob * EbiMk[, i]))
            	# This is the standard error of variable i averaged over all models
            	SDbi[i] <- sqrt(postprob %*% (sebiMk[, i]^2) + postprob %*% 
                	((EbiMk[, i] - Ebi[i])^2))
            	if (i == 1) 
            	{
                		CEbi[i] <- Ebi[i]
                		CSDbi[i] <- SDbi[i]
            	}
            	else 
            	{
                		sel <- which[, i - 1]
                		cpp <- postprob[sel]/sum(postprob[sel])
                		CEbi[i] <- as.numeric(sum(cpp * EbiMk[sel, i]))
                		CSDbi[i] <- sqrt(cpp %*% (sebiMk[sel, i]^2) + 
                  	cpp %*% ((EbiMk[sel, i] - CEbi[i])^2))
            	}
        	}
    	}

	#############################################################################
	# Calculate the overall covariance matrix averaged over each of the models
	#############################################################################
	# Make sure to add "+ 1" for the intercept
	nvarint <- ncol(x) + 1
		model.cov <- as.list(rep(0, nmod))
		covmat1 <- matrix(0,nvarint,nvarint)
		covmat <- matrix(0,nvarint,nvarint)
		for(k in (1:nmod)) 
		{
					model.cov[[k]] <- ((ls.diag(lsfit(x[, which[k,  ], 
							drop = F], y, wt = wt))$std.dev)^2) * (
									ls.diag(lsfit(x[, which[k,  ], drop = F], y, 
									wt = wt))$cov.unscaled)
										mats <- EbiMk[k,]%*%t(EbiMk[k,])
					modc <- model.cov[[k]]
					for (i in (1:(nvarint)))
					{
						# Note: all models include an intercept
						if (i>1)
						{
							if (which[k, i-1]==F)
							{
								# If model "k" does not include explanatory variable "i" (i.e. which[k,i]==F),
								# then assign a column/row of zeros for those elements of the covariance matrix 
								if (i<=nrow(modc))
								{
									# This line creates the row of the covariance matrix
									modc <- rbind(modc[(1:(i-1)),],c(rep(0,ncol(modc))), modc[(i:(nrow(modc))), ])
									# This line creates the column of the covariance matrix
									modc <- cbind(modc[,(1:(i-1))], c(rep(0,nrow(modc))),modc[, (i:(ncol(modc)))])
	    						}
								else
								{
									modc <- rbind(modc[(1:(i-1)),],c(rep(0,ncol(modc))))
									modc <- cbind(modc[,(1:(i-1))], c(rep(0,nrow(modc))))
	    						}
      						}
						}
					}
					covmat <- covmat + ((modc + mats)*postprob[k])
		}
	   	covmat1 <- (covmat - (Ebi%*%t(Ebi)))
		var.names <- c("Intercept",row.names(probne0))
		dimnames(covmat1)[[1]]	<- var.names
		dimnames(covmat1)[[2]]	<- var.names

	########################################################################################
	# This section collects the output into a "list" variable and returns the list.
	########################################################################################	
    	dimnames(which) <- list(NULL, dimnames(x)[[2]])
    	dimnames(EbiMk) <- dimnames(sebiMk) <- list(NULL, c("Int", 
      dimnames(x)[[2]]))
    	result <- list(postprob = postprob, namesx = xnames, label = label, 
        r2 = r2, bic = bic, size = (size - 1), which = which, 
        probne0 = c(probne0), postmean = Ebi, postsd = SDbi, postcov = covmat1,
        condpostmean = CEbi, condpostsd = CSDbi, cov = covMk, ols = EbiMk, 
        se = sebiMk, reduced = reduced, dropped = dropped, call = cl, 
        n.models = length(postprob), n.vars = length(probne0))
    	class(result) <- "bicreg"
    	result
}

test1 <- bicreg.composite(x, y, strict = FALSE, OR = 1000000)
summary(test1)
test1$postcov
