library(BMA);

# load in data 
mydata<- read.table(file="c:/Interaction-data.txt", header=TRUE);
 

# y is dependent var.; x regressor matrix 
y<- mydata[,1];
x<- cbind(mydata[,2:50])
  
# data check 
fix(x)
fix(y)
 
# run bicreg
lma<- bicreg(x, y, strict = FALSE, OR = 100000, nbest=10, maxCol = 50);
summary(lma);

# summary plot
imageplot.bma(lma);
