library(BMA);

# load in data 
mydata<- read.table(file="c:/Global-data.txt", header=TRUE);
 

# y is dependent var.; x regressor matrix 
y<- mydata[,1];
x<- cbind(mydata[,2:25])
  
# data check 
fix(x)
fix(y)
 
# run bicreg
lma<- bicreg(x, y, strict = FALSE, OR = 100000, nbest=10, maxCol = 33);
summary(lma);

# summary plot
imageplot.bma(lma);
