% ML_nfactorsGDFM - Percentage of Variance Explained by the firs q Dynamic Factors
% 
% ML_nfactorsGDFM(y,M);
%   y - standardized data
%   M - covariogram truncation
% 
%  Written by Matteo Luciani (mluciani@ulb.ac.be)

function [xx yy]=ML_nfactorsGDFM(y,M)

[~, ~, ~, xx, yy] = gdfm_twosided(y,1, M, M, 1);                                  % twosided estimation 

disp(' ______________________________________________________________________')
disp(' Percentage Cumulative Variance Explained by the firs q Dynamic Factors'); 
disp(' ')
disp('=================================')
disp('   Nfactors    %Var    Cum Var')
disp('---------------------------------')
disp([(1:10)' xx(1:10) cumsum(xx(1:10))])
disp('=================================')

H=2*M+1;
axes('Parent',figure,'FontSize',10); jj=0;
plot(yy(1:15,:),'-*'), axis([0.5 15.05 0 max(yy(1,:))+.1])
title('\it Percentage of Variance Explained by the first q Dynamic Factors at Different Frequences',...
    'fontweight','bold','fontsize',14)
xlabel('Largest Eigenvalue','fontweight','bold','fontsize',12)
ylabel('% of Explained Variance','fontweight','bold','fontsize',12)
legend(num2str((0:2*pi/H:2*pi*M/H)'))