% ML_lag - Given x(t) produces x(t-j0) .... x(t-k)
%
% xx=ML_lag(x,k,j0)
% by default j0 is 1
%

% Matteo Luciani
% matteo.luciani@.ulb.ac.be
% January 2010

function xx=ML_lag(x,k,j0)
[T N] = size(x);

if nargin<3; j0=1; end;    
n=1;

xx=zeros(T-k,N*(k+1-j0));  

for i=1:N; 
    for j=j0:k,                                
        xx(:,n)=x(k+1-j:T-j,i);            
        n=n+1;        
    end;       
end;
    
    
    