% ML_diff - First difference of the data;
% xx=ML_diff(x,jj)
%
% by default takes first difference of the series;
% jj is optional if actived the result is annual difference:
%   jj=1 for quarterly data
%   jj=2 for monthly data
%

% Written by Matteo Luciani
% matteo.luciani@.ulb.ac.be

function xx=ML_diff(x,jj)

[T N] = size(x);
if nargin ==1;
    for ii=1:N; xx(:,ii)=x(2:T,ii)-x(1:T-1,ii); end;
else
    for ii=1:N;     
        if      jj==1; xx(:,ii)=x(5:T,ii)-x(1:T-4,ii); 
        elseif  jj==2; xx(:,ii)=x(13:T,ii)-x(1:T-12,ii); end;        
    end;
end;
    