% ML_decompose - Historical Decomposition
% 
% [Y y] = ML_decompose(C, sh)
% Outputs:
%   Y - Average Historical decomposition across all good rotations
%   Y - All Historical decomposition
% Inputs:
%   C - Impulse Responses
%  sh - Structural shocks
% 

% Written by Mario Forni
% customized by Matteo Luciani (matteo.luciani@ulb.ac.be)

function [Y y] = ML_decompose(C, sh)

[n,q,~,s] = size(C);
T = size(sh,1);
y = nan*zeros(T, n, q, s);
for k = 1:s
    for i = 1:n    
        for j = 1:q        
            y(:,i,j,k) = filter(squeeze(C(i,j,:,k)),1,sh(:,j,k));    
        end
    end
end
% y = y(h:end,:,:,:);
Y = mean(y,4);