%% ML_SmokingGun_ReplicationFile2 - Reproduces Figure 1
%
% Replication File for the paper 
% Monetary Policy and the Housing Market: A Structural Factor Analysis
% by Matteo Luciani (matteo.luciani@ulb.ac.be)
% ECARES Working Paper 2012-035 
% To appear on the Journal of Applied Econometrics
% 

clear all; close all; clc
ML_graph_options                                                            % Default Graphs Options
TR=1;                                                                       % Data transformation
out=1;                                                                      % Elimination of Outliers
[db, label,cd] = ML_SmokingGun_Data(1,1);                                   % Upload Data
name=ML_SmokingGunNames;                                                    % variables name
[DB]= ML_SmokingGun_Data(0,0); TT=1963:.25:2010.75;                         % Upload Raw Data
T=size(db,1); t0=1963+.25*TR; tt=t0:0.25:t0+(T-1)*0.25;                     % useful objects
tb=find(tt==1982.5); te=find(tt==2008); tg=find(tt==2002.25);               % Extremes to truncate the sample
db(1:tb,:)=[]; [T N]=size(db); tt=tt(tb)+.25:0.25:tt(tb)+T*0.25;            % I consider only the second half of the sample

% ___________________________ %
% Setting-up Model Parameters %
%  %
[y, My, Sy]=ML_Standardize(db);                                             % Standardize Data
yc=db-repmat(My,T,1);                                                       % Compute demeaned variables Useful for Historical Decomposition
r=7; p=1; q=4; s=21;                                                        % Parameter of the factor model
draws=20000;                                                                % number of draws for the rotation matrix
boot=500;                                                                   % bootstrap draws
maxrot=25;                                                                  % maximum number of rotations
FP=1;                                                                       % Set wether to use the Fry Pagan modification for sign restrictions
nrest=ones(q,1)*68;                                                         % Normalization Restriction
h=4;                                                                        % Number of lags on which sign restritions are imposed
for kk=1:h; rest{kk}=[[31 7 23 108:109]' -ones(5,1);68 1]; ID=1; end;       % Sign Restrictions

disp('  ______________________ ')
disp('  Sample Characteristics ')
disp('   ')
fprintf('   Transformation: '); if TR==0; disp('None'); elseif TR==1; disp('Light'); else disp('Hard'); end
fprintf('   Outliers: ');       if out==0; disp('None'); else disp('Removed'); end
fprintf('   Sample: ');         disp([ML_TimeLabel(tt(1)) '-'  ML_TimeLabel(tt(end))]);
disp(['   Static Factors: ' num2str(r)]);
disp(['   Dynamic Factors: ' num2str(q)]);
disp(['   Number of Lags in the VAR of the Factors: ' num2str(p)]);
disp(['   Number of lags on which sign restritions are imposed: ' num2str(h)]);
fprintf('   Fry & Pagan: '); if FP==0; disp('No'); else disp('Yes'); end
disp('   Variables on which sign restrictions are imposed:'); 
for kk=1:size(rest{1},1); disp(['    - ' name{rest{1}(kk,1)}]); end;

disp('  _______________________  ')
disp('    ')
disp('  Factor Model Estimation  ')
disp('  _______________________  ')
disp('    ')
[Imp,Dimp,sh,~,R,rsh,F,L,A,G]=ML_SmokingGun_DfmSignImp(db,cd,q,r,p,s,nrest,rest,draws,h,maxrot,FP);	% Impulse responses whole sample
chi=(F*L').*repmat(Sy,T,1); xsi=y.*repmat(Sy,T,1)-chi;                                              % The Common and the Idiosyncratic Component
share=var(chi)./var(db);                                                                            % Percentage of variance accounted for the common component
[CC0] = ML_SmokingGun_SignBoot(db,cd,q,r,p,s,nrest,rest,draws,h,boot,maxrot,FP);                    % Bootstrap Confidence Band
for bb=1:boot; tgr(bb)=size(CC0{bb},4); end; tgr=[0 tgr];                                           % idemtifies how many rotations we have;
CC=zeros(N,q,s,sum(tgr)); for bb=1:boot; CC(:,:,:,sum(tgr(1:bb))+1:sum(tgr(1:bb+1)))=CC0{bb}; end   % convert from cell to matrix
CC = cat(4,CC,Imp); clear CC0                                                                       % Distribution of IRF = Sample + Bootstrap
gr=size(CC,4); gsr=size(Imp,4);                                                                     % Number of good rotations
IRF=zeros(s,N,gr); irf=zeros(s,N,gsr);                                                              % preallocates IRF
for jj=1:gr; IRF(:,:,jj)=IRFnormalize(squeeze(CC(:,1,:,jj))',.5,68); end; clear CC                  % Standardize all IRF obtained with Bootstrap
for jj=1:gsr; irf(:,:,jj)=IRFnormalize(squeeze(Imp(:,1,:,jj))',.5,68); end                          % This is the irf estimated on the sample
IRFu=prctile(IRF,84,3); IRFd=prctile(IRF,16,3); IRFm=prctile(IRF,50,3);                             % Median and confidence band


%% Figure 1. Impulse Response Functions %%
idvar=[68 7 31 36 41 43 35 55 56]; nv=size(idvar,2);
axes('Parent',figure,'FontSize',10); ML_FigureSize
for ii=1:nv;
    subplot(3,3,ii); hold on        
    ha=area(0:20,[IRFd(1:21,idvar(ii),2) IRFu(1:21,idvar(ii),2)-IRFd(1:21,idvar(ii),2)],'linestyle','none');% Confidence band Benchmark
    set(ha(1), 'FaceColor', 'none'); set(ha(2), 'FaceColor', [0.7 0.7 0.7]) 
    plot(0:20,zeros(21,1),'k','linewidth',0.5)                                                              % zero line 
    plot(0:20,IRFm(1:21,idvar(ii),2),'k','linewidth',1)                                                   % Median q=4
    hold off; title(name{idvar(ii)},'FontAngle','italic','fontsize',10); axis tight                         % title    
end


stop