###################################################################################################################################################
#############                                                                                                                        ##############
#############    Codes for paper: "Out-of-Sample Return Predictability: a Quantile Combination Approach"                             ##############
#############    Created by Luiz Renato Lima and Fanning Meng                                                                        ##############
#############                                                                                                                        ##############
###################################################################################################################################################


#############    First, set up the file directory to the local file   ###########
setwd("C:/Users/Fanning/Documents/work/Dessertation/VaR/Density Forecast for lasso/modified figures/Excess return")

#############    Install and recall the following packages            ############
library(stats)
library(quantreg)
library(nlme)
library(grDevices)
library(sROC)
library(quadprog)
library(MatrixModels)
library(psych)
library(lars)
library(glmnet)
library(ggplot2)
library(forecast)

##################################################################################
#############    Import data into R                                   ############
##################################################################################

filename="goyal_welch_RF.csv"
XY = read.csv(filename, header=TRUE, quote="\"",dec=".", fill=TRUE)

#############    Generate covariable matrix with 15 predictors        ############
pX=as.matrix(XY[,3:17])

#############    Covariable matrix including intercept                ############
X=XY[,2:17]

#############    Generate forecast variable: Equity premium           ############
ER=XY[,18]-XY[,19]
Y= ts(ER, start=1, freq=1) 

##################################################################################
#############    Separation of total observations into in-sample      ############
#############    and out-of-sample part for the recursive             ############
#############    scheme                                               ############
##################################################################################

#############    Total number of observations: T                      ############
T=length(Y)
#############    Recursive window starts with Tini observations       ############
Tini=361
#############    Out-of-sample size TF                                ############
TF=T-Tini
#############    An initial hold-out period for PLQC3 and PLQC4 is TR ############
TR=120
#############    The final post-holdout OOS periods is OS             ############
OS=TF-TR
#############    Initial estimation sample including holdout period   ############
TNew=481
#############    Out-of-sample portion of Y                           ############
v_y=Y[(Tini+1):T]
#############    Post-holdout out-of-sample portion of Y              ############
v_y2=v_y[(TR+1):TF]



##################################################################################
#############    Proposed forecast model :                            ############
#############    Post-LASSO Quantile Combination (PLQC)               ############
##################################################################################

#############    The set of quantiles                                 ############
tau=seq(from=0.3, to=0.7, by=0.1)
n_tau=length(tau)
tau2=c(0.3,0.5,0.7)
n_tau2=length(tau2)


#############    Function Sn generates the empirical distribution of  ############
#############    a pivatol quantity for the choice of lambda in LASSO ############
#############    selection                                            ############
Sn <- function(tau, x, ntrials){
n_tau=length(tau)
T=nrow(x)
Sn2=matrix(nrow=ntrials,ncol=n_tau)
for (j in 1:ntrials)
{
u=matrix(runif(T),nrow=T,ncol=1)
 for (i in 1:n_tau)
 {
 I=u-tau[i]<=0
 s=apply(x,2,function(x) (tau[i]-I)*(x) )
 sn=apply(s,2,mean)
 Sn2[j,i]=T*max(abs(sn))
 }
}
result=Sn2
return(result)
}

#############   Parameter "alpha" and "c" for the choice of lambda   ############
alpha=0.05
c=2

#############   Generation of lambda for each quantile at each time  ############
QuantileM=matrix(nrow=TF,ncol=n_tau)
lambdastar_c2=matrix(nrow=TF,ncol=n_tau)
ntr=500
for (t in Tini:(T-1))
{
x=pX[1:(t-1),]
set.seed(12345)
M=Sn(tau,x,ntr)
QuantileM[t-Tini+1,]=apply(M,2,function(x) quantile(x,1-alpha))
lambdastar_c2[(t-Tini+1),]=c*QuantileM[t-Tini+1,]
}


#############   Generation of post-LASSO quantile forecasts (PLQF)   ############ 
#############   and at the same time,                                ############
#############   record the outcome of selected predictors            ############
predi_sp2=matrix(nrow=TF,ncol=n_tau)
II_sp2=array(0,dim=c(TF,n_tau,15))

for (t in Tini:(T-1))
{
x=pX[1:(t-1),]
y=Y[2:t]
 for (i in 1:n_tau)
 {
 lambdas=lambdastar_c2[(t-Tini+1),i]*(tau[i]*(1-tau[i]))^(0.5)/(t-1)
 eq=rqss(y~x,method="lasso",tau=tau[i],lambda=lambdas)
 s1=summary(eq)
 pvalue_sp=s1$coef[2:16,4]
 II=pvalue_sp<=0.05
 if (sum(II)==0){
 II=rank(pvalue_sp)==1
 }
 II_sp2[(t-Tini+1),i,1:sum(II)]=which(II)
 xx=as.matrix(subset(pX[1:t,],select=which(II)))
 eq=rq(y~xx[1:(t-1),],tau=tau[i])
 predi_sp2[(t-Tini+1),i]=c(1,xx[t,])%*%eq$coef
 }
}

#############   Generation of forecasts PLQC1 and PLQC2 based on     ############  
#############   simple average of 3 or 5 quantile forecasts          ############
se1=c(1,3,5)
mean_qu30=apply(predi_sp2[(TR+1):TF,se1],1,mean)
mean_qu31=apply(predi_sp2[(TR+1):TF,],1,mean)

#############   Generation of forecasts PLQC3 and PLQC4 based on     ############  
#############   weighted average of 3 or 5 quantile forecasts        ############
v_lasso=matrix(nrow=OS,ncol=2)
for (t in (TR+1):TF)
{
yy=v_y[1:(t-1)]
xx=predi_sp2[1:t,]
#############   Time-varying weight scheme 1                         ############
XX1=xx[1:(t-1),se1]
D=t(XX1) %*% XX1
d=t(yy) %*% XX1
C=cbind(rep(1,3),diag(3))
b=c(1,0,0,0)
eq=solve.QP(Dmat = D, dvec = d, Amat = C, bvec = b, meq = 1)
v_lasso[(t-TR),1]=t(eq$solution)%*%xx[t,se1]
#############   Time-varying weight scheme 2                         ############
XX2=xx[1:(t-1),]
D=t(XX2) %*% XX2
d=t(yy) %*% XX2
C=cbind(rep(1,5), diag(5))
b=c(1,0,0,0,0,0)
eq=solve.QP(Dmat = D, dvec = d, Amat = C, bvec = b, meq = 1)
v_lasso[(t-TR),2]=t(eq$solution)%*%xx[t,]
}

##################################################################################
#############    Quantile forecast models                             ############
#############    based on fixed predictors FQR and FOLS models        ############
##################################################################################
 
#############    Fixed quantile forecasts and Fixed OLS forecasts     ############
#############    based on 3 quantile levels                           ############
II_plqc1=II_sp2[,se1,]
PF_plqc1=matrix(nrow=TF,ncol=1)
QF_plqc1=matrix(nrow=TF,ncol=n_tau2)
for (t in Tini:(T-1))
{
y=Y[2:t]
II1=c(unique(II_plqc1[(t-Tini+1),1,]),unique(II_plqc1[(t-Tini+1),2,]),unique(II_plqc1[(t-Tini+1),3,]))
II=unique(II1)
xx=as.matrix(subset(pX[1:t,],select=II))
eq=lm(y~xx[1:(t-1),])
PF_plqc1[(t-Tini+1),1]=c(1,xx[t,])%*%eq$coef
 for (i in 1:n_tau2)
 {
 qeq=rq(y~xx[1:(t-1),],tau=tau2[i])
 QF_plqc1[(t-Tini+1),i]=c(1,xx[t,])%*%qeq$coef
 }
}

#############    Fixed quantile forecasts and Fixed OLS forecasts     ############
#############    based on 5 quantile levels                           ############
II_plqc2=II_sp2 
PF_plqc2=matrix(nrow=TF,ncol=1)
QF_plqc2=matrix(nrow=TF,ncol=n_tau)
for (t in Tini:(T-1))
 {
y=Y[2:t]
II1=c(unique(II_plqc2[(t-Tini+1),1,]),unique(II_plqc2[(t-Tini+1),2,]),unique(II_plqc2[(t-Tini+1),3,]),unique(II_plqc2[(t-Tini+1),4,]),unique(II_plqc2[(t-Tini+1),5,]))
II=unique(II1)
xx=as.matrix(subset(pX[1:t,],select=II))
eq=lm(y~xx[1:(t-1),])
PF_plqc2[(t-Tini+1),1]=c(1,xx[t,])%*%eq$coef
 for (i in 1:n_tau)
 {
 qeq=rq(y~xx[1:(t-1),],tau=tau[i])
 QF_plqc2[(t-Tini+1),i]=c(1,xx[t,])%*%qeq$coef
 }
}

#############    FQR1 and FQR2 based on equal weights                 ############
QF1=apply(QF_plqc1[(TR+1):TF,],1,mean)
QF2=apply(QF_plqc2[(TR+1):TF,],1,mean)

#############    FQR3 and FQR4 based on time-varying weights          ############
QF34=matrix(nrow=OS,ncol=2)
for (t in (TR+1):TF)
{
yy=v_y[1:(t-1)]
xx=QF_plqc1[1:t,]
XX1=xx[1:(t-1),]
D=t(XX1) %*% XX1
d=t(yy) %*% XX1
C=cbind(rep(1,3),diag(3))
b=c(1,0,0,0)
eq=solve.QP(Dmat = D, dvec = d, Amat = C, bvec = b, meq = 1)
QF34[(t-TR),1]=t(eq$solution)%*%xx[t,]
xx=QF_plqc2[1:t,]
XX1=xx[1:(t-1),]
D=t(XX1) %*% XX1
d=t(yy) %*% XX1
C=cbind(rep(1,5), diag(5))
b=c(1,0,0,0,0,0)
eq=solve.QP(Dmat = D, dvec = d, Amat = C, bvec = b, meq = 1)
QF34[(t-TR),2]=t(eq$solution)%*%xx[t,]
}


##################################################################################
#############    Single-predictor Models                              ############
##################################################################################
mean_uni=matrix(nrow=TF,ncol=15)
for (t in Tini:(T-1))
{
yy=Y[2:t]
 for (i in 1:15)
 {
 px=pX[1:(t-1),i]
 eq=lm(yy~px)
 mean_uni[(t-Tini+1),i]=eq$coef[1]+eq$coef[2]*pX[t,i]
 }
}

pf=mean_uni[(TR+1):TF,]

##################################################################################
#############    Complete Subset regression models (CSR k=1, 2 and 3) ############
##################################################################################

#############    CSR with k=1 and K=15                                ############
mean_uni_avg=apply(mean_uni,1,mean)
mean_uni_avg2=mean_uni_avg[(TR+1):TF]

#############    CSR with k=2 and K=15                                ############
K=15
k=2
beta=matrix(nrow=choose(K,k),ncol=16)
beta_csr=matrix(nrow=OS,ncol=16)
CSR=matrix(nrow=OS)
for (t in TNew:(T-1))
{
y=Y[2:t]
r=0
 for (m in (1:14)){
   for (n in ((m+1):15)){
   r=r+1
   x=pX[1:(t-1),c(m,n)]
   eq=lm(y~x)
   beta[r,c(m,n,16)]=eq$coef[c(2:3,1)]
   }
 }
beta_csr[(t-TNew+1),]=apply(beta,2,function(x) sum(x,na.rm=TRUE)/choose(K,k))
CSR[(t-TNew+1)]=c(pX[t,],1)%*%beta_csr[(t-TNew+1),]
}

#############    CSR with k=3 and K=15                                ############
K=15
k=3
beta=matrix(nrow=choose(K,k),ncol=16)
betak3_csr=matrix(nrow=OS,ncol=16)
CSRk3=matrix(nrow=OS)
for (t in TNew:(T-1))
{
y=Y[2:t]
r=0
 for (m in (1:13)){
  for (n in ((m+1):14)){
   for (q in ((n+1):15)){
   r=r+1
   x=pX[1:(t-1),c(m,n,q)]
   eq=lm(y~x)
   beta[r,c(m,n,q,16)]=eq$coef[c(2:4,1)]
   }
  }
 }
betak3_csr[(t-TNew+1),]=apply(beta,2,function(x) sum(x,na.rm=TRUE)/choose(K,k))
CSRk3[(t-TNew+1)]=c(pX[t,],1)%*%betak3_csr[(t-TNew+1),]
}


##################################################################################
#############     Benchmark model: Historical Avarege model           ############
##################################################################################
hsy=matrix(nrow=TF,ncol=1)
for (t in Tini:(T-1))
{
yy=Y[1:t]
eq=lm(yy ~ 1)
hsy[t-Tini+1,1]=eq$coef
}



##################################################################################
#############                                                         ############
#############     Robustness Check Analysis : AL-LASSO, RFC and       ############
#############     single-predictor quantile forecasting models        ############
#############                                                         ############
##################################################################################

##################################################################################
#############     Single-predictor Quantile models                    ############
##################################################################################
qindi1=matrix(nrow=TF,ncol=15)
qindi2=matrix(nrow=TF,ncol=15)
qindi3=matrix(nrow=TF,ncol=15)
qindi4=matrix(nrow=TF,ncol=15)
qindi5=matrix(nrow=TF,ncol=15)
for (t in Tini:(T-1))
{
yy=Y[2:t]
 for (m in 1:15)
 {
 xx=pX[1:(t-1),m]
 eq1=rq(yy~xx,tau=tau[1])
 qindi1[(t-Tini+1),m]=t(c(1,pX[t,m]))%*%eq1$coef
 eq2=rq(yy~xx,tau=tau[2])
 qindi2[(t-Tini+1),m]=t(c(1,pX[t,m]))%*%eq2$coef
 eq3=rq(yy~xx,tau=tau[3])
 qindi3[(t-Tini+1),m]=t(c(1,pX[t,m]))%*%eq3$coef
 eq4=rq(yy~xx,tau=tau[4])
 qindi4[(t-Tini+1),m]=t(c(1,pX[t,m]))%*%eq4$coef
 eq5=rq(yy~xx,tau=tau[5])
 qindi5[(t-Tini+1),m]=t(c(1,pX[t,m]))%*%eq5$coef
 }
}

#############     Single-predictor quantile forecasts                 ############
#############     based on the equal weight scheme                    ############
qindi_sa=matrix(nrow=TF,ncol=15)
for (m in 1:15)
{
qindi_sa[,m]=apply(cbind(qindi1[,m],qindi2[,m],qindi3[,m]),1,mean)
}

##################################################################################
#############     Robust Forecast combination model                   ############
#############     based on 3 quantile estimates                       ############
##################################################################################
qindi_avg=cbind(apply(qindi1,1,mean),apply(qindi3,1,mean),apply(qindi5,1,mean))
rfc1=apply(qindi_avg[(TR+1):TF,],1,mean)

##################################################################################
#############     AL-LASSO model from Meligkotsidoua et al.(2015)     ############
##################################################################################
Q1=apply(qindi1[,1:14],2,function(x) x-qindi1[,15])
Q2=apply(qindi2[,1:14],2,function(x) x-qindi2[,15])
Q3=apply(qindi3[,1:14],2,function(x) x-qindi3[,15])
Q4=apply(qindi4[,1:14],2,function(x) x-qindi4[,15])
Q5=apply(qindi5[,1:14],2,function(x) x-qindi5[,15])
V1=v_y-qindi1[,15]
V2=v_y-qindi2[,15]
V3=v_y-qindi3[,15]
V4=v_y-qindi4[,15]
V5=v_y-qindi5[,15]
ALlasso1=matrix(nrow=OS,ncol=5)
for (t in (TR+1):TF)
{
yy=V1[1:(t-1)]
xx=Q1[1:(t-1),]
eq=rqss(yy~xx+0,method="lasso",tau=tau[1],lambda=1.4)
s1=summary(eq)
co15=1-sum(s1$coef[,1])
ALlasso1[(t-TR),1]=qindi1[t,15]*co15+qindi1[t,1:14]%*%s1$coef[,1]

yy=V2[1:(t-1)]
xx=Q2[1:(t-1),]
eq=rqss(yy~xx+0,method="lasso",tau=tau[2],lambda=1.4)
s1=summary(eq)
co15=1-sum(s1$coef[,1])
ALlasso1[(t-TR),2]=qindi2[t,15]*co15+qindi2[t,1:14]%*%s1$coef[,1]

yy=V3[1:(t-1)]
xx=Q3[1:(t-1),]
eq=rqss(yy~xx+0,method="lasso",tau=tau[3],lambda=1.4)
s1=summary(eq)
co15=1-sum(s1$coef[,1])
ALlasso1[(t-TR),3]=qindi3[t,15]*co15+qindi3[t,1:14]%*%s1$coef[,1]

yy=V4[1:(t-1)]
xx=Q4[1:(t-1),]
eq=rqss(yy~xx+0,method="lasso",tau=tau[4],lambda=1.4)
s1=summary(eq)
co15=1-sum(s1$coef[,1])
ALlasso1[(t-TR),4]=qindi4[t,15]*co15+qindi4[t,1:14]%*%s1$coef[,1]

yy=V5[1:(t-1)]
xx=Q5[1:(t-1),]
eq=rqss(yy~xx+0,method="lasso",tau=tau[5],lambda=1.4)
s1=summary(eq)
co15=1-sum(s1$coef[,1])
ALlasso1[(t-TR),5]=qindi5[t,15]*co15+qindi5[t,1:14]%*%s1$coef[,1]
}
#############     AL-LASSO 1                                          ############
ALlasso31=apply(ALlasso1[,se1],1,mean)
#############     AL-LASSO 2                                          ############
ALlasso51=apply(ALlasso1,1,mean)


##################################################################################
#############                                                         ############
#############      Forecast Evaluation                                ############
#############                                                         ############
##################################################################################

rmatrx2=as.matrix(cbind(pf, mean_uni_avg2, CSR, CSRk3, PF_plqc1[(TR+1):TF],PF_plqc2[(TR+1):TF], QF1,QF2,QF34, mean_qu30, mean_qu31,v_lasso, ALlasso31, rfc1, qindi_sa[(TR+1):TF,],hsy[(TR+1):TF]))

##################################################################################
#############                                                         ############
#############      Table 1 Construction                               ############
#############                                                         ############
##################################################################################

##################################################################################
#############      OOS : 1967-2013                                    ############
##################################################################################

NM=ncol(rmatrx2)
#############      Clark and West (2007) test                         ############
MSPE2=matrix(nrow=OS, ncol=(NM-1))
for (m in 1:(NM-1))
{
MSPE2[,m]=(v_y2-rmatrx2[,NM])^2-(v_y2-rmatrx2[,m])^2+(rmatrx2[,NM]-rmatrx2[,m])^2 
}
pvalue2=matrix(nrow=(NM-1))
for (m in 1:(NM-1))
{
eq=t.test(MSPE2[,m],alternative="greater", confi.level=0.90)
pvalue2[m,]=eq$p.value
}

#############      Diebold and Mariano (1995) test                    ############
umatrx=apply(rmatrx2,2,function(x) v_y2-x)
u1=umatrx[,ncol(umatrx)]
u2=umatrx[,1:(ncol(umatrx)-1)]
##################### Diebold-Mariano test ##############################
dmpval=matrix(nrow=ncol(umatrx)-1)
for (i in 1:(ncol(umatrx)-1)){
dm=dm.test(u1,u2[,i],alternative="greater",h=1,power=1)
dmpval[i]=dm$p.value
}

#############      R2 statistics                                      ############
mse_matrx2=apply(rmatrx2,2,function(x) mean((v_y2-x)^2) )
R2_s=matrix(nrow=(NM-1))
for (i in 1:(NM-1))
{
R2_s[i]=1-mse_matrx2[i]/mse_matrx2[NM]
}

#############      Utility Gains                                      ############
ry=XY[,18]
sigma2=matrix(nrow=TF)
for (t in Tini:(T-1))
{
yy=ry[1:t]
sigma2[(t-Tini+1),]=var(yy)
}
sigma2_s=sigma2[(TR+1):TF]
rf=XY[TNew:(T-1),19]
return=apply(rmatrx2,2,function(x) x+rf)
W2=matrix(nrow=OS,ncol=NM)
g=3
for (w in 1:NM)
{
W2[,w]=(1/g)*(return[,w]/sigma2_s)
}
W2[W2<0]=0
W2[W2>1.5]=1.5
rf2=XY[482:T,19]
ret=ry[482:T]
V2=matrix(nrow=OS,ncol=NM)
for (k in 1:NM)
{
V2[,k]=W2[,k]*ret+(1-W2[,k])*rf2
}
mu2=apply(V2,2,function(x) mean(x))
sigma_s=apply(V2,2,function(x) var(x))
Vj2=mu2-0.5*g*sigma_s
U2=matrix(nrow=NM-1)
for (m in 1:(NM-1))
{
U2[m]=(Vj2[m]-Vj2[NM])*1200
}

f1=cbind(R2_s[1:28,]*100,dmpval[1:28,],pvalue2[1:28,],U2[1:28,])


##################################################################################
#############      OOS : 1967-1990                                    ############
##################################################################################
TS=1
TE=288
rmatrx3=rmatrx2[TS:TE,]
OS2=nrow(rmatrx3)
MSPE2=matrix(nrow=OS2, ncol=(NM-1))
v_y4=v_y2[TS:TE]
#############      Clark and West (2007) test                         ############
for (m in 1:(NM-1))
{
MSPE2[,m]=(v_y4-rmatrx3[,NM])^2-(v_y4-rmatrx3[,m])^2+(rmatrx3[,NM]-rmatrx3[,m])^2 
}
pvalue2=matrix(nrow=(NM-1))
for (m in 1:(NM-1))
{
eq=t.test(MSPE2[,m],alternative="greater", confi.level=0.90)
pvalue2[m,]=eq$p.value
}

#############      Diebold and Mariano (1995) test                    ############
umatrx=apply(rmatrx3,2,function(x) v_y4-x)
u1=umatrx[,ncol(umatrx)]
u2=umatrx[,1:(ncol(umatrx)-1)]
dmpval=matrix(nrow=ncol(umatrx)-1)
for (i in 1:(ncol(umatrx)-1)){
dm=dm.test(u1,u2[,i],alternative="greater",h=1,power=1)
dmpval[i]=dm$p.value
}

#############      R2 statistics                                      ############
mse_matrx2=apply(rmatrx3,2,function(x) mean((v_y4-x)^2))
R2_s=matrix(nrow=(NM-1))
for (i in 1:(NM-1))
{
R2_s[i]=1-mse_matrx2[i]/mse_matrx2[NM]
}

#############      Utility Gains                                      ############
V=V2[TS:TE,]
mu2=apply(V,2,function(x) mean(x))
sigma_s=apply(V,2,function(x) var(x))
Vj2=mu2-0.5*g*sigma_s
U2=matrix(nrow=NM-1)
for (m in 1:(NM-1))
{
U2[m]=(Vj2[m]-Vj2[NM])*1200
}
f2=cbind(R2_s[1:28,]*100,dmpval[1:28,],pvalue2[1:28,],U2[1:28,])


##################################################################################
#############      OOS : 1991-2013                                    ############
##################################################################################
TS=289
TE=564
rmatrx3=rmatrx2[TS:TE,]
OS2=nrow(rmatrx3)
MSPE2=matrix(nrow=OS2, ncol=(NM-1))
v_y4=v_y2[TS:TE]
#############      Clark and West (2007) test                         ############
for (m in 1:(NM-1))
{
MSPE2[,m]=(v_y4-rmatrx3[,NM])^2-(v_y4-rmatrx3[,m])^2+(rmatrx3[,NM]-rmatrx3[,m])^2 
}
pvalue2=matrix(nrow=(NM-1))
for (m in 1:(NM-1))
{
eq=t.test(MSPE2[,m],alternative="greater", confi.level=0.90)
pvalue2[m,]=eq$p.value
}

#############      Diebold and Mariano (1995) test                    ############
umatrx=apply(rmatrx3,2,function(x) v_y4-x)
u1=umatrx[,ncol(umatrx)]
u2=umatrx[,1:(ncol(umatrx)-1)]
##################### Diebold-Mariano test ##############################
dmpval=matrix(nrow=ncol(umatrx)-1)
for (i in 1:(ncol(umatrx)-1)){
dm=dm.test(u1,u2[,i],alternative="greater",h=1,power=1)
dmpval[i]=dm$p.value
}

#############      R2 statistics                                      ############
mse_matrx2=apply(rmatrx3,2,function(x) mean((v_y4-x)^2))
R2_s=matrix(nrow=(NM-1))
for (i in 1:(NM-1))
{
R2_s[i]=1-mse_matrx2[i]/mse_matrx2[NM]
}

#############      Utility Gains                                      ############
V=V2[TS:TE,]
##For mu and sigma
mu2=apply(V,2,function(x) mean(x))
sigma_s=apply(V,2,function(x) var(x))
Vj2=mu2-0.5*g*sigma_s
U2=matrix(nrow=NM-1)
for (m in 1:(NM-1))
{
U2[m]=(Vj2[m]-Vj2[NM])*1200
}

f3=cbind(R2_s[1:28,]*100,dmpval[1:28,],pvalue2[1:28,],U2[1:28,])


##################################################################################
#############      OOS : 2008-2013                                    ############
##################################################################################
TS=493
TE=564
rmatrx3=rmatrx2[TS:TE,]
OS2=nrow(rmatrx3)
MSPE2=matrix(nrow=OS2, ncol=(NM-1))
v_y4=v_y2[TS:TE]
#############      Clark and West (2007) test                         ############
for (m in 1:(NM-1))
{
MSPE2[,m]=(v_y4-rmatrx3[,NM])^2-(v_y4-rmatrx3[,m])^2+(rmatrx3[,NM]-rmatrx3[,m])^2 
}
pvalue2=matrix(nrow=(NM-1))
for (m in 1:(NM-1))
{
eq=t.test(MSPE2[,m],alternative="greater", confi.level=0.90)
pvalue2[m,]=eq$p.value
}

#############      Diebold and Mariano (1995) test                    ############
umatrx=apply(rmatrx3,2,function(x) v_y4-x)
u1=umatrx[,ncol(umatrx)]
u2=umatrx[,1:(ncol(umatrx)-1)]
dmpval=matrix(nrow=ncol(umatrx)-1)
for (i in 1:(ncol(umatrx)-1)){
dm=dm.test(u1,u2[,i],alternative="greater",h=1,power=1)
dmpval[i]=dm$p.value
}

#############      R2 statistics                                      ############
mse_matrx2=apply(rmatrx3,2,function(x) mean((v_y4-x)^2))
R2_s=matrix(nrow=(NM-1))
for (i in 1:(NM-1))
{
R2_s[i]=1-mse_matrx2[i]/mse_matrx2[NM]
}

#############      Utility Gains                                      ############
V=V2[TS:TE,]
mu2=apply(V,2,function(x) mean(x))
sigma_s=apply(V,2,function(x) var(x))
Vj2=mu2-0.5*g*sigma_s
U2=matrix(nrow=NM-1)
for (m in 1:(NM-1))
{
U2[m]=(Vj2[m]-Vj2[NM])*1200
}

f4=cbind(R2_s[1:28,]*100,dmpval[1:28,],pvalue2[1:28,],U2[1:28,])

f=cbind(f1,f2,f3,f4)

##################################################################################
#############      Output results of Table 1                          ############
##################################################################################
write.csv(f,file="table1new.csv")


##################################################################################
#############                                                         ############
#############      Table 2 Construction                               ############
#############                                                         ############
##################################################################################
MSPE1=apply(rmatrx2[1:288,c(20,24,28)],2,function(x) mean((v_y2[1:288]-x)^2))
MSPE2=apply(rmatrx2[289:564,c(20,24,28)],2,function(x) mean((v_y2[289:564]-x)^2))
Dcp=cbind(MSPE1,MSPE2)
e2=(Dcp[2,]-Dcp[3,])
e1=(Dcp[1,]-Dcp[2,])
e=e1+e2
#############      % of MSPE errors Pre-90                            ############
e1[1]/e[1]
e2[1]/e[1]
#############      % of MSPE errors Post-90                           ############
e1[2]/e[2]
e2[2]/e[2]


##################################################################################
#############                                                         ############
#############      Table 4 Construction                               ############
#############                                                         ############
##################################################################################
QS=matrix(nrow=17,ncol=5)
I=v_y2-predi_sp2[121:TF,]<=0
for (k in 1:5){
QS[1,k]=mean((v_y2-predi_sp2[(TR+1):TF,k])*(I[,k]-tau[k]))
}
I=v_y2-ALlasso1<=0
for (k in 1:5){
QS[2,k]=mean((v_y2-ALlasso1[,1])*(I[,k]-tau[k]))
}
for (m in (1:15)) 
{
mm=m+2
I=v_y2-qindi1[(TR+1):TF,m]<=0
QS[mm,1]=mean((v_y2-qindi1[(TR+1):TF,m])*(I-tau[1]))
}
for (m in (1:15)) 
{
mm=m+2
I=v_y2-qindi2[(TR+1):TF,m]<=0
QS[mm,2]=mean((v_y2-qindi2[(TR+1):TF,m])*(I-tau[2])) 
}
for (m in (1:15)) 
{
mm=m+2
I=v_y2-qindi3[(TR+1):TF,m]<=0
QS[mm,3]=mean((v_y2-qindi3[(TR+1):TF,m])*(I-tau[3]))
}
for (m in (1:15)) 
{
mm=m+2
I=v_y2-qindi4[(TR+1):TF,m]<=0
QS[mm,4]=mean((v_y2-qindi4[(TR+1):TF,m])*(I-tau[4]))
}

for (m in (1:15)) 
{
mm=m+2
I=v_y2-qindi5[(TR+1):TF,m]<=0
QS[mm,5]=mean((v_y2-qindi5[(TR+1):TF,m])*(I-tau[5]))
}

#############      Output results of Table 4                          ############
QS*100



##################################################################################
#############                                                         ############
#############      Fig 1, 2, 6 : Cumulative Sqaured Predictor Errors  ############
#############                                                         ############
##################################################################################
cpe=matrix(nrow=OS,ncol=NM-1)
for (m in (1:(NM-1)))
{
cpe[,m]=cumsum((v_y2-rmatrx2[,NM])^2-(v_y2-rmatrx2[,m])^2)
}
cpe100=apply(cpe,2,function(x) x*100)
z=rep(0,OS)
zz=ts(z,frequency=12,start=c(1967,1))
date=seq(as.Date("1967-01-01"),by="month",along=zz)
cpe_data=ts(cpe100[,],frequency=12,start=c(1967,1))

#############      Figure 1 : Single-predictor forecasts              ############
uni_var=c("DP", "DY","EP","DE", "SVAR", "BM", "NTIS","TBL","LTY","LTR", "TMS", "DFY", "DFR", "INFL", "E10P")
par(mar=c(3,4,0.2,0.5))
par(mfrow=c(3,5))
for (i in 1:15)
{
plot(cpe_data[,i],type="l",ylab=uni_var[i],ylim=c(-4,2.5),xlab="")
lines(zz,lty="dashed")
abline(v=c(1990,12),lty=4,col="red")
axis(1,at=seq(date[1],date[2],along=date), label=(format(date,"%Y-%m")))
}

#############      Figure 2 : PLQC FQR FOLS and CSR Forecasts          ############
com_va=c("PLQC1","PLQC2","PLQC3", "PLQC4","FQR1","FQR2","FQR3","FQR4","FOLS1","FOLS2","CSR k=1","CSR k=2","CSR k=3")
par(mar=c(3,4,0.2,0.5))
par(mfrow=c(4,4))
nn=0
for (i in c(25:28,21:24,19:20,16:18))
{ 
nn=nn+1
plot(cpe_data[,i],type="l",ylab=com_va[nn],ylim=c(-1,3),xlab="",xlim=c(1967,2013))
lines(zz,lty="dashed")
abline(v=c(1990,12),lty=4,col="red")
axis(1,at=seq(date[1],date[2],along=date), label=(format(date,"%Y-%m")))
}

#############      Figure 6 : PLQC1, AL-LASSO1, RFC1 and singe-        ############
#############      predictor quantile forecasts                        ############
com_va=c("PLQC 1","AL-LASSO 1","RFC 1","QDP", "QDY","QEP","QDE", "QSVAR", "QBM", "QNTIS","QTBL","QLTY","QLTR", "QTMS", "QDFY", "QDFR", "QINFL", "QE10P")
par(mar=c(3,4,0.2,0.5))
par(mfrow=c(3,6))
nn=0
for (i in c(25,29:45))
{ 
nn=nn+1
plot(cpe_data[,i],type="l",ylab=com_va[nn],ylim=c(-10,3),xlab="",xlim=c(1967,2013))
lines(zz,lty="dashed")
abline(v=c(1990,12),lty=4,col="red")
axis(1,at=seq(date[1],date[2],along=date), label=(format(date,"%Y-%m")))
}

##################################################################################
#############                                                         ############
#############      Fig 3 & 4: Bias and Variance Decomposition         ############
#############                                                         ############
##################################################################################

#############      Fig 3: OOS: 1967~1990                              ############
uni_var2=c("DP", "DY","EP","DE", "SVAR", "BM", "NTIS","TBL","LTY","LTR", "TMS", "DFY", "DFR", "INFL", "E10P")
com_va3=c("CSR k=1", "CSR k=2","CSR k=3","FOLS1","FOLS2","FQR1","FQR2","FQR3","FQR4","PLQC1","PLQC2","PLQC3", "PLQC4" )
name_main2=c(uni_var2, com_va3, "HA")
main3=rmatrx2[1:288,c(1:28,NM)]
v_y4=v_y2[1:288]
mse_matrx2=apply(main3,2,function(x) mean((v_y4-x)^2))
var=apply(main3,2,function(x) var(x))
bias=mse_matrx2-var 
N=length(bias)
bias_dif=(bias-bias[N])*100000
var_dif=(var-var[N])*100000
df2=as.data.frame(cbind(var_dif,bias_dif))
ha=subset(df2,name_main2=="HA")
ggplot(df2, aes(x=bias_dif,y=var_dif)) +geom_point(data=ha, colour="red")+ geom_text(data=df2,aes(label=name_main2), size=5, vjust=0,hjust=0.75)+theme(text = element_text(size=20))+ylab("Forecast Variance Difference(e^(-5))")+xlab("Squared Forecast Bias Difference(e^(-5))") 

#############      Fig 4: OOS: 1991~2013                               ############
name_sub3=c("DP", "DY","EP","DE", "SVAR", "BM", "NTIS","LTR", "TMS", "DFY", "DFR","INFL","E10P",com_va3,"HA")
name_sub2=c("DP", "DY","EP","DE", "SVAR", "BM", "NTIS","TBL","LTY","LTR", "TMS", "DFY", "DFR","INFL","E10P","MEAN","BCAF","PLQC1","PLQC2","PLQC3", "PLQC4","CSR k=2","CSR k=3","AL_LASSO1","HA")
main4=rmatrx2[289:564,c(1:28,NM)]
v_y4=v_y2[289:564]
mse_matrx2=apply(main4,2,function(x) mean((v_y4-x)^2))
var=apply(main4,2,function(x) var(x))
bias=mse_matrx2-var 
N=length(bias)
bias_dif=(bias-bias[N])*100000
var_dif=(var-var[N])*100000
df2=as.data.frame(cbind(var_dif,bias_dif))
ha=subset(df2,name_main2=="HA")
tbl=subset(df2,name_sub2=="TBL")
lty=subset(df2,name_sub2=="LTY")
sub=subset(df2,name_sub2!="LTY" & name_sub2!="TBL" )
ggplot(df2, aes(x=bias_dif,y=var_dif)) +geom_point(data=ha, colour="red")+ geom_text(data=sub,aes(label=name_sub3), size=5, vjust=0,hjust=0.75)+geom_text(data=tbl,label="TBL", size=5, vjust=0,hjust=0)+geom_text(data=lty,label="LTY", size=5, vjust=1,hjust=0)+theme(text = element_text(size=20))+ylab("Forecast Variance Difference(e^(-5))")+xlab("Squared Forecast Bias Difference(e^(-5))") 


##################################################################################
#############                                                         ############
#############      Fig 5 & Tab 3: Variable Selection                  ############
#############                                                         ############
##################################################################################

#############      Tab 3 : Frequency of variables selected            ############
II_sp2new=II_sp2[121:TF,,]
select1=apply(II_sp2new[1:564, ,],2,table)
select1[1]
select1[2]
select1[3]
select1[4]
select1[5]
############# The frequency in % is calculated by dividing the above number with 564 #

#############      Fig 5 : variables selection                        ############
write.csv(II_sp2[121:TF,1,1:15],file="tau30.csv")
write.csv(II_sp2[121:TF,2,1:15],file="tau40.csv")
write.csv(II_sp2[121:TF,3,1:15],file="tau50.csv")
write.csv(II_sp2[121:TF,4,1:15],file="tau60.csv")
write.csv(II_sp2[121:TF,5,1:15],file="tau70.csv")
#############      The rest is done in Matlab codes                   ############

save.image("Paper Results.RData")



