###################################################################################################################################################
#############                                                                                                                        ##############
#############    Codes for Online Appendix: "Out-of-Sample Return Predictability: a Quantile Combination Approach"                   ##############
#############    Created by Luiz Renato Lima and Fanning Meng                                                                        ##############
#############                                                                                                                        ##############
###################################################################################################################################################

#############    First, set up the file directory to the local file   ###########
setwd("C:/Users/Fanning/Documents/work/Dessertation/VaR/Density Forecast for lasso/modified figures/Excess return")

#############    Install and recall the following packages            ############
library(stats)
library(quantreg)
library(nlme)
library(grDevices)
library(sROC)
library(quadprog)
library(MatrixModels)
library(psych)
library(lars)
library(glmnet)
library(ggplot2)
library(forecast)


#############    Import Data                                          ############
load("Paper Results.RData")

##################################################################################
#############                                                         ############
#############    Monte Carlo Simulation Experiment                    ############
#############                                                         ############
##################################################################################

##################################################################################
#############    The DGP : y_t+1=beta X_t+ gamma X_t v_t+1            ############
#############    v_t+1 ~ N(0,sigma2)                                  ############
##################################################################################

#############    Set of quantile levels                               ############
tau=c(0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9)
ntau=length(tau)

ntr=100
alpha=0.05
Sn <- function(tau, x, ntrials){
n_tau=length(tau)
T=nrow(x)

Sn2=matrix(nrow=ntrials,ncol=n_tau)
for (j in 1:ntrials)
{
u=matrix(runif(T),nrow=T,ncol=1)
for (i in 1:n_tau)
{
I=u-tau[i]<=0
s=apply(x,2,function(x) (tau[i]-I)*(x) )
sn=apply(s,2,mean)
Sn2[j,i]=T*max(abs(sn))
}
}
result=Sn2
return(result)
}

#############    Total rounds of simulation                            ############
R= 25000
sed=1:R
T = 1000
############# Correlation parameter rho  ##############################################
ro=c(0,0.1,0.25,0.5,0.95)
nro=length(ro)



##################################################################################
#############                                                         ############
#############    Monte Carlo Experiment 1: both fully and partially   ############
#############                                                         ############
##################################################################################

#############    Number of Xs as indicators                           ############
K=6
b=cbind(rep(1,T),rep(1,T),rep(0,T),rep(0,T),rep(0,T),rep(0,T))
#############    LASSO selection outcomes                             ############
II2=array(0,dim=c(length(ro),R,ntau,K))
#############    PLQF                                                 ############
predi_sp2=array(0,dim=c(length(ro),R,ntau))
#############    FQR and FOLS                                         ############
PF_plqc2=matrix(nrow=R,ncol=length(ro))
QF_plqc2=array(0,dim=c(length(ro),R,ntau))
#############    Single predictor model                               ############
mean_uni=array(0,dim=c(length(ro),R,K))
#############    Complete subset regression k=2,3                     ############
CSRk2=matrix(nrow=R,ncol=length(ro))
CSRk3=matrix(nrow=R,ncol=length(ro))
#############    Benchmark case Historical prevailing mean model      ############
hsy=matrix(nrow=R,ncol=length(ro))
#############    To record the true value                             ############
ry=matrix(nrow=R,ncol=length(ro))
for (j in 1:nro)
{
#############    Create the correlated X matrix                       ############
m=diag(1,K,K)
m[outer(1:K, 1:K, function(i,j) i!=j)] = ro[j]
# Cholesky decomposition
L = chol(m)
for (r in 1:R)
{
set.seed(r)
X=matrix(runif(K*T), nrow=K, ncol=T)
XX = t(L) %*% X
x = t(XX)
sigma=0.75
set.seed(r)
v=rnorm(T,mean=0,sd=sigma)
#############    Create partially weak predictors                     ############
I=v<=qnorm(0.5,sd=sigma) 
b1=b[,1]*I
I=v>qnorm(0.5,sd=sigma)
b2=b[,2]*I
B=cbind(b1,b2,b[,3:K])
ga=rep(1*sigma,T)
I=abs(v)>1.96
ga[which(I)]=5*sigma
co=c(-1.5,1.5,rep(0,4))
beta=t(apply(B,1,function(x) co*x*sigma))
go=c(5,5,rep(0,4))
gamma=t(apply(B,1,function(x) go*x*sigma))
f=x*beta
g=x*gamma
ff=apply(f,1,sum)
gg=apply(g,1,sum)
f0=1
y=f0+ff+gg*v+ga*v

xx=x[1:(T-1),]
yy=y[1:(T-1)] 
ry[r,j]=y[T]

##################################################################################
#############     Historical Average model                            ############
##################################################################################
eq=lm(yy~1)
hsy[r,j]=eq$coef

##################################################################################
#############     PLQC model                                          ############
##################################################################################
set.seed(r)
M=Sn(tau,x,ntr)
QuantileM=apply(M,2,function(x) quantile(x,1-alpha))
lambdastar_c2=2*QuantileM 
for (i in 1:ntau)
{
lambdas=lambdastar_c2[i]*(tau[i]*(1-tau[i]))^(0.5)/(T-1) 
eq=rqss(yy~xx,method="lasso",tau=tau[i],lambda=lambdas)
s1=summary(eq)
pvalue_sp=s1$coef[2:(K+1),4]
II=pvalue_sp<=0.05
if (sum(II)==0){
II=rank(pvalue_sp)==1
}
II2[j,r,i,1:sum(II)]=which(II)
px=as.matrix(x[,which(II)])
eq=summary(rq(yy~px[1:(T-1),],tau=tau[i]))
predi_sp2[j,r,i]=c(1,px[T,])%*%eq$coef[,1]
}

##################################################################################
#############     FQR and FOLS models                                 ############
##################################################################################
II_plqc2=II2[j,r,,]
II1=c(unique(II_plqc2[1,]),unique(II_plqc2[2,]),unique(II_plqc2[3,]),unique(II_plqc2[4,]),unique(II_plqc2[5,]),unique(II_plqc2[6,]),unique(II_plqc2[7,]),unique(II_plqc2[8,]),unique(II_plqc2[9,]))
II=unique(II1)
px=as.matrix(x[,select=II])
eq=lm(yy~px[1:(T-1),])
PF_plqc2[r,j]=c(1,px[T,])%*%eq$coef
for (i in 1:ntau)
{
qeq=rq(yy~px[1:(T-1),],tau=tau[i])
QF_plqc2[j,r,i]=c(1,px[T,])%*%qeq$coef
}

##################################################################################
#############     Single-predictor Models                             ############
##################################################################################
for (i in 1:K)
{
px=xx[,i]
eq=lm(yy~px)
mean_uni[j,r,i]=eq$coef[1]+eq$coef[2]*x[T,i]
}

##################################################################################
#############     CSR models                                          ############
##################################################################################

#############     k=2                                                 ############
k=2
betaS=matrix(nrow=choose(K,k),ncol=(K+1))
rr=0
for (m in (1:(K-1))){
 for (n in ((m+1):K)){
 rr=rr+1
 px=xx[,c(m,n)]
 eq=lm(yy~px)
 betaS[rr,c(m,n,(K+1))]=eq$coef[c(2:3,1)]
 }
}
beta_csr=apply(betaS,2,function(x) sum(x,na.rm=TRUE)/choose(K,k))
CSRk2[r,j]=c(x[T,],1)%*%beta_csr 

#############     k=3                                                 ############
k=3
betaS=matrix(nrow=choose(K,k),ncol=(K+1))
rr=0
for (m in (1:(K-2))){
 for (n in ((m+1):(K-1))){
  for (q in ((n+1):K)){
  rr=rr+1
  px=xx[,c(m,n,q)]
  eq=lm(yy~px)
  betaS[rr,c(m,n,q,(K+1))]=eq$coef[c(2:4,1)]
  }
 }
}
betak3_csr =apply(betaS,2,function(x) sum(x,na.rm=TRUE)/choose(K,k))
CSRk3[r,j]=c(x[T,],1)%*%betak3_csr 
}
}

#############     CSR k=1                                             ############
mean_uni_avg=matrix(nrow=R,ncol=nro)
#############     PLQC                                                ############
mean_qu31=matrix(nrow=R,ncol=nro)
#############     FQR                                                 ############
FQR2=matrix(nrow=R,ncol=nro)
for (j in (1:nro)){
mean_uni_avg[,j]=apply(mean_uni[j,,],1,mean)
mean_qu31[,j]=apply(predi_sp2[j,,],1,mean)
FQR2[,j]=apply(QF_plqc2[j,,],1,mean)
}


##################################################################################
#############     Forecast Evaluation                                 ############
##################################################################################
for (j in 1:nro){
rmatrx=as.matrix(cbind(mean_uni[j,,], mean_uni_avg[,j],CSRk2[,j],CSRk3[,j],FQR2[,j], PF_plqc2[,j], mean_qu31[,j],hsy[,j]))

################################################################################## 
#############    Generation of results in Table 1                     ############
################################################################################## 
NM=ncol(rmatrx)
MSPE2=matrix(nrow=R, ncol=(NM-1))
v_y=ry[,j]
for (m in 1:(NM-1))
{
MSPE2[,m]=(v_y-rmatrx[,NM])^2-(v_y-rmatrx[,m])^2+(rmatrx[,NM]-rmatrx[,m])^2 
}

#############     Clark and West test                                  ############
pvalue2=matrix(nrow=(NM-1))
for (m in 1:(NM-1))
{
eq=t.test(MSPE2[,m],alternative="greater", confi.level=0.90)
pvalue2[m,]=eq$p.value
}

#############     R2 statistics                                        ############
R2_s=matrix(nrow=(NM-1))
mse_matrx2=apply(rmatrx,2,function(x) mean((v_y-x)^2) )
for (i in 1:(NM-1))
{
R2_s[i]=1-mse_matrx2[i]/mse_matrx2[NM]
}
print(cbind(R2_s*100,pvalue2))
}





##################################################################################
#############                                                         ############
#############    Monte Carlo Experiment 2: all full weak              ############
#############                                                         ############
##################################################################################

#############    Number of Xs as indicators                           ############
K=6
b=cbind(rep(0,T),rep(0,T),rep(0,T),rep(0,T),rep(0,T),rep(0,T))
#############    LASSO selection outcomes                             ############
II2=array(0,dim=c(length(ro),R,ntau,K))
#############    PLQF                                                 ############
predi_sp2=array(0,dim=c(length(ro),R,ntau))
#############    FQR and FOLS                                         ############
PF_plqc2=matrix(nrow=R,ncol=length(ro))
QF_plqc2=array(0,dim=c(length(ro),R,ntau))
#############    Single predictor model                               ############
mean_uni=array(0,dim=c(length(ro),R,K))
#############    Complete subset regression k=2,3                     ############
CSRk2=matrix(nrow=R,ncol=length(ro))
CSRk3=matrix(nrow=R,ncol=length(ro))
#############    Benchmark case Historical prevailing mean model      ############
hsy=matrix(nrow=R,ncol=length(ro))
#############    To record the true value                             ############
ry=matrix(nrow=R,ncol=length(ro))
for (j in 1:nro)
{
#############    Create the correlated X matrix                       ############
m=diag(1,K,K)
m[outer(1:K, 1:K, function(i,j) i!=j)] = ro[j]
# Cholesky decomposition
L = chol(m)
for (r in 1:R)
{
set.seed(r)
X=matrix(runif(K*T), nrow=K, ncol=T)
XX = t(L) %*% X
x = t(XX)
sigma=0.75
set.seed(r)
v=rnorm(T,mean=0,sd=sigma)
#############    Create partially weak predictors                     ############
B=b
ga=rep(1*sigma,T)
I=abs(v)>1.96
ga[which(I)]=5*sigma
co=c(-1.5,-1.5,-1.5,1.5,1.5,1.5)
beta=t(apply(B,1,function(x) co*x*sigma))
go=rep(5,K)
gamma=t(apply(B,1,function(x) go*x*sigma))
f=x*beta
g=x*gamma
ff=apply(f,1,sum)
gg=apply(g,1,sum)
f0=1
y=f0+ff+gg*v+ga*v

xx=x[1:(T-1),]
yy=y[1:(T-1)] 
ry[r,j]=y[T]

##################################################################################
#############     Historical Average model                            ############
##################################################################################
eq=lm(yy~1)
hsy[r,j]=eq$coef

##################################################################################
#############     PLQC model                                          ############
##################################################################################
set.seed(r)
M=Sn(tau,x,ntr)
QuantileM=apply(M,2,function(x) quantile(x,1-alpha))
lambdastar_c2=2*QuantileM 
for (i in 1:ntau)
{
lambdas=lambdastar_c2[i]*(tau[i]*(1-tau[i]))^(0.5)/(T-1) 
eq=rqss(yy~xx,method="lasso",tau=tau[i],lambda=lambdas)
s1=summary(eq)
pvalue_sp=s1$coef[2:(K+1),4]
II=pvalue_sp<=0.05
if (sum(II)==0){
II=rank(pvalue_sp)==1
}
II2[j,r,i,1:sum(II)]=which(II)
px=as.matrix(x[,which(II)])
eq=summary(rq(yy~px[1:(T-1),],tau=tau[i]))
predi_sp2[j,r,i]=c(1,px[T,])%*%eq$coef[,1]
}

##################################################################################
#############     FQR and FOLS models                                 ############
##################################################################################
II_plqc2=II2[j,r,,]
II1=c(unique(II_plqc2[1,]),unique(II_plqc2[2,]),unique(II_plqc2[3,]),unique(II_plqc2[4,]),unique(II_plqc2[5,]),unique(II_plqc2[6,]),unique(II_plqc2[7,]),unique(II_plqc2[8,]),unique(II_plqc2[9,]))
II=unique(II1)
px=as.matrix(x[,select=II])
eq=lm(yy~px[1:(T-1),])
PF_plqc2[r,j]=c(1,px[T,])%*%eq$coef
for (i in 1:ntau)
{
qeq=rq(yy~px[1:(T-1),],tau=tau[i])
QF_plqc2[j,r,i]=c(1,px[T,])%*%qeq$coef
}

##################################################################################
#############     Single-predictor Models                             ############
##################################################################################
for (i in 1:K)
{
px=xx[,i]
eq=lm(yy~px)
mean_uni[j,r,i]=eq$coef[1]+eq$coef[2]*x[T,i]
}

##################################################################################
#############     CSR models                                          ############
##################################################################################

#############     k=2                                                 ############
k=2
betaS=matrix(nrow=choose(K,k),ncol=(K+1))
rr=0
for (m in (1:(K-1))){
 for (n in ((m+1):K)){
 rr=rr+1
 px=xx[,c(m,n)]
 eq=lm(yy~px)
 betaS[rr,c(m,n,(K+1))]=eq$coef[c(2:3,1)]
 }
}
beta_csr=apply(betaS,2,function(x) sum(x,na.rm=TRUE)/choose(K,k))
CSRk2[r,j]=c(x[T,],1)%*%beta_csr 

#############     k=3                                                 ############
k=3
betaS=matrix(nrow=choose(K,k),ncol=(K+1))
rr=0
for (m in (1:(K-2))){
 for (n in ((m+1):(K-1))){
  for (q in ((n+1):K)){
  rr=rr+1
  px=xx[,c(m,n,q)]
  eq=lm(yy~px)
  betaS[rr,c(m,n,q,(K+1))]=eq$coef[c(2:4,1)]
  }
 }
}
betak3_csr =apply(betaS,2,function(x) sum(x,na.rm=TRUE)/choose(K,k))
CSRk3[r,j]=c(x[T,],1)%*%betak3_csr 
}
}

#############     CSR k=1                                             ############
mean_uni_avg=matrix(nrow=R,ncol=nro)
#############     PLQC                                                ############
mean_qu31=matrix(nrow=R,ncol=nro)
#############     FQR                                                 ############
FQR2=matrix(nrow=R,ncol=nro)
for (j in (1:nro)){
mean_uni_avg[,j]=apply(mean_uni[j,,],1,mean)
mean_qu31[,j]=apply(predi_sp2[j,,],1,mean)
FQR2[,j]=apply(QF_plqc2[j,,],1,mean)
}


##################################################################################
#############     Forecast Evaluation                                 ############
##################################################################################
for (j in 1:nro){
rmatrx=as.matrix(cbind(mean_uni[j,,], mean_uni_avg[,j],CSRk2[,j],CSRk3[,j],FQR2[,j], PF_plqc2[,j], mean_qu31[,j],hsy[,j]))

################################################################################## 
#############    Generation of results in Table 2                     ############
################################################################################## 
NM=ncol(rmatrx)
MSPE2=matrix(nrow=R, ncol=(NM-1))
v_y=ry[,j]
for (m in 1:(NM-1))
{
MSPE2[,m]=(v_y-rmatrx[,NM])^2-(v_y-rmatrx[,m])^2+(rmatrx[,NM]-rmatrx[,m])^2 
}

#############     Clark and West test                                  ############
pvalue2=matrix(nrow=(NM-1))
for (m in 1:(NM-1))
{
eq=t.test(MSPE2[,m],alternative="greater", confi.level=0.90)
pvalue2[m,]=eq$p.value
}

#############     R2 statistics                                        ############
R2_s=matrix(nrow=(NM-1))
mse_matrx2=apply(rmatrx,2,function(x) mean((v_y-x)^2) )
for (i in 1:(NM-1))
{
R2_s[i]=1-mse_matrx2[i]/mse_matrx2[NM]
}
print(cbind(R2_s*100,pvalue2))
}





##################################################################################
#############                                                         ############
#############    Monte Carlo Experiment 3: all partially              ############
#############                                                         ############
##################################################################################

#############    Number of Xs as indicators                           ############
K=6
b=cbind(rep(1,T),rep(1,T),rep(1,T),rep(1,T),rep(1,T),rep(1,T))
#############    LASSO selection outcomes                             ############
II2=array(0,dim=c(length(ro),R,ntau,K))
#############    PLQF                                                 ############
predi_sp2=array(0,dim=c(length(ro),R,ntau))
#############    FQR and FOLS                                         ############
PF_plqc2=matrix(nrow=R,ncol=length(ro))
QF_plqc2=array(0,dim=c(length(ro),R,ntau))
#############    Single predictor model                               ############
mean_uni=array(0,dim=c(length(ro),R,K))
#############    Complete subset regression k=2,3                     ############
CSRk2=matrix(nrow=R,ncol=length(ro))
CSRk3=matrix(nrow=R,ncol=length(ro))
#############    Benchmark case Historical prevailing mean model      ############
hsy=matrix(nrow=R,ncol=length(ro))
#############    To record the true value                             ############
ry=matrix(nrow=R,ncol=length(ro))
for (j in 1:nro)
{
#############    Create the correlated X matrix                       ############
m=diag(1,K,K)
m[outer(1:K, 1:K, function(i,j) i!=j)] = ro[j]
# Cholesky decomposition
L = chol(m)
for (r in 1:R)
{
set.seed(r)
X=matrix(runif(K*T), nrow=K, ncol=T)
XX = t(L) %*% X
x = t(XX)
sigma=0.75
set.seed(r)
v=rnorm(T,mean=0,sd=sigma)
#############    Create partially weak predictors                     ############
I=v<=qnorm(0.3,sd=sigma) 
b1=b[,1]*I
I=v<=qnorm(0.4,sd=sigma) 
b2=b[,2]*I
I=v<=qnorm(0.5,sd=sigma) 
b3=b[,3]*I
### Weak predictors upper quantiles ######
I=v>qnorm(0.5,sd=sigma)
b4=b[,4]*I
I=v>=qnorm(0.6,sd=sigma)
b5=b[,5]*I
I=v>=qnorm(0.7,sd=sigma)
b6=b[,6]*I
B=cbind(b1,b2,b3,b4,b5,b6)
ga=rep(1*sigma,T)
I=abs(v)>1.96
ga[which(I)]=5*sigma
co=c(-1.5,-1.5,-1.5,1.5,1.5,1.5)
beta=t(apply(B,1,function(x) co*x*sigma))
go=rep(5,K)
gamma=t(apply(B,1,function(x) go*x*sigma))
f=x*beta
g=x*gamma
ff=apply(f,1,sum)
gg=apply(g,1,sum)
f0=1
y=f0+ff+gg*v+ga*v

xx=x[1:(T-1),]
yy=y[1:(T-1)] 
ry[r,j]=y[T]

##################################################################################
#############     Historical Average model                            ############
##################################################################################
eq=lm(yy~1)
hsy[r,j]=eq$coef

##################################################################################
#############     PLQC model                                          ############
##################################################################################
set.seed(r)
M=Sn(tau,x,ntr)
QuantileM=apply(M,2,function(x) quantile(x,1-alpha))
lambdastar_c2=2*QuantileM 
for (i in 1:ntau)
{
lambdas=lambdastar_c2[i]*(tau[i]*(1-tau[i]))^(0.5)/(T-1) 
eq=rqss(yy~xx,method="lasso",tau=tau[i],lambda=lambdas)
s1=summary(eq)
pvalue_sp=s1$coef[2:(K+1),4]
II=pvalue_sp<=0.05
if (sum(II)==0){
II=rank(pvalue_sp)==1
}
II2[j,r,i,1:sum(II)]=which(II)
px=as.matrix(x[,which(II)])
eq=summary(rq(yy~px[1:(T-1),],tau=tau[i]))
predi_sp2[j,r,i]=c(1,px[T,])%*%eq$coef[,1]
}

##################################################################################
#############     FQR and FOLS models                                 ############
##################################################################################
II_plqc2=II2[j,r,,]
II1=c(unique(II_plqc2[1,]),unique(II_plqc2[2,]),unique(II_plqc2[3,]),unique(II_plqc2[4,]),unique(II_plqc2[5,]),unique(II_plqc2[6,]),unique(II_plqc2[7,]),unique(II_plqc2[8,]),unique(II_plqc2[9,]))
II=unique(II1)
px=as.matrix(x[,select=II])
eq=lm(yy~px[1:(T-1),])
PF_plqc2[r,j]=c(1,px[T,])%*%eq$coef
for (i in 1:ntau)
{
qeq=rq(yy~px[1:(T-1),],tau=tau[i])
QF_plqc2[j,r,i]=c(1,px[T,])%*%qeq$coef
}

##################################################################################
#############     Single-predictor Models                             ############
##################################################################################
for (i in 1:K)
{
px=xx[,i]
eq=lm(yy~px)
mean_uni[j,r,i]=eq$coef[1]+eq$coef[2]*x[T,i]
}

##################################################################################
#############     CSR models                                          ############
##################################################################################

#############     k=2                                                 ############
k=2
betaS=matrix(nrow=choose(K,k),ncol=(K+1))
rr=0
for (m in (1:(K-1))){
 for (n in ((m+1):K)){
 rr=rr+1
 px=xx[,c(m,n)]
 eq=lm(yy~px)
 betaS[rr,c(m,n,(K+1))]=eq$coef[c(2:3,1)]
 }
}
beta_csr=apply(betaS,2,function(x) sum(x,na.rm=TRUE)/choose(K,k))
CSRk2[r,j]=c(x[T,],1)%*%beta_csr 

#############     k=3                                                 ############
k=3
betaS=matrix(nrow=choose(K,k),ncol=(K+1))
rr=0
for (m in (1:(K-2))){
 for (n in ((m+1):(K-1))){
  for (q in ((n+1):K)){
  rr=rr+1
  px=xx[,c(m,n,q)]
  eq=lm(yy~px)
  betaS[rr,c(m,n,q,(K+1))]=eq$coef[c(2:4,1)]
  }
 }
}
betak3_csr =apply(betaS,2,function(x) sum(x,na.rm=TRUE)/choose(K,k))
CSRk3[r,j]=c(x[T,],1)%*%betak3_csr 
}
}

#############     CSR k=1                                             ############
mean_uni_avg=matrix(nrow=R,ncol=nro)
#############     PLQC                                                ############
mean_qu31=matrix(nrow=R,ncol=nro)
#############     FQR                                                 ############
FQR2=matrix(nrow=R,ncol=nro)
for (j in (1:nro)){
mean_uni_avg[,j]=apply(mean_uni[j,,],1,mean)
mean_qu31[,j]=apply(predi_sp2[j,,],1,mean)
FQR2[,j]=apply(QF_plqc2[j,,],1,mean)
}


##################################################################################
#############     Forecast Evaluation                                 ############
##################################################################################
for (j in 1:nro){
rmatrx=as.matrix(cbind(mean_uni[j,,], mean_uni_avg[,j],CSRk2[,j],CSRk3[,j],FQR2[,j], PF_plqc2[,j], mean_qu31[,j],hsy[,j]))

################################################################################## 
#############    Generation of results in Table 3                     ############
################################################################################## 
NM=ncol(rmatrx)
MSPE2=matrix(nrow=R, ncol=(NM-1))
v_y=ry[,j]
for (m in 1:(NM-1))
{
MSPE2[,m]=(v_y-rmatrx[,NM])^2-(v_y-rmatrx[,m])^2+(rmatrx[,NM]-rmatrx[,m])^2 
}

#############     Clark and West test                                  ############
pvalue2=matrix(nrow=(NM-1))
for (m in 1:(NM-1))
{
eq=t.test(MSPE2[,m],alternative="greater", confi.level=0.90)
pvalue2[m,]=eq$p.value
}

#############     R2 statistics                                        ############
R2_s=matrix(nrow=(NM-1))
mse_matrx2=apply(rmatrx,2,function(x) mean((v_y-x)^2) )
for (i in 1:(NM-1))
{
R2_s[i]=1-mse_matrx2[i]/mse_matrx2[NM]
}
print(cbind(R2_s*100,pvalue2))
}


##################################################################################
#############                                                         ############
#############    Measure of consistence                               ############
#############                                                         ############
##################################################################################

################################################################################## 
#############    Construction of table 4                              ############
################################################################################## 
SE=matrix(nrow=OS,ncol=NM-1)
for (m in (1:(NM-1)))
{
SE[,m]=(v_y2-rmatrx2[,NM])^2-(v_y2-rmatrx2[,m])^2
}
NegSE=SE>0
perc=apply(NegSE,2,sum)/OS
#############     Table 4                                             ############
perc[1:28]

################################################################################## 
#############    Construction of Fig 1 and 2                          ############
################################################################################## 
SE_data=ts(SE ,frequency=12,start=c(1967,1))
uni_var=c("DP", "DY","EP","DE", "SVAR", "BM", "NTIS","TBL","LTY","LTR", "TMS", "DFY", "DFR", "INFL", "E10P")
par(mar=c(2,4,2,1))
par(mfrow=c(3,5))
nn=0
for (i in c(1:15))
{
nn=nn+1
st=floor(min(SE_data[,i])*1000)/1000
ed=ceiling(max(SE_data[,i])*1000)/1000
hist(SE_data[,i],breaks= seq(from=st, to=ed,by=0.001),freq=TRUE, main=uni_var[nn], xlim=c(-0.006,0.008),labels=TRUE)
}

name1=c("CSR k=1","CSR k=2","FOLS1","FOLS2","FQR1","FQR2","FQR3","FQR4","PLQC1","PLQC2","PLQC3", "PLQC4")
par(mar=c(2,4,2,1))
par(mfrow=c(3,4))
nn=0
for (i in c(16:17,19:28))
{
nn=nn+1
st=floor(min(SE_data[,i])*1000)/1000
ed=ceiling(max(SE_data[,i])*1000)/1000
hist(SE_data[,i],breaks= seq(from=st, to=ed,by=0.001),freq=TRUE, main=name1[nn],xlim=c(-0.006,0.008),labels=TRUE)
}



##################################################################################
#############                                                         ############
#############    Robustness check: QPC PC and KIC                     ############
#############                                                         ############
##################################################################################


################################################################################## 
#############    PC and QPC                                           ############
################################################################################## 
pc_mean=matrix(nrow=TF,ncol=1)
qpc=matrix(nrow=TF,ncol=n_tau)
for (t in Tini:(T-1))
{
y=Y[2:t]
xx=pX[1:t,]
pcs=princomp(xx,scores=TRUE)
sc=pcs$scores[,1]
eq=lm(y ~ sc[1:(t-1)])
pc_mean[(t-Tini+1),1]=t(eq$coef)%*%c(1,sc[t])
eq3=rq(y~sc[1:(t-1)],tau=tau)
qpc[(t-Tini+1),]=t(eq3$coef)%*%c(1,sc[t])
}
pc=pc_mean[(TR+1):TF,1]
qpc_c1=apply(qpc[(TR+1):TF,se1],1,mean)
qpc_c2=apply(qpc[(TR+1):TF,],1,mean)
qpc_c3=matrix(nrow=OS,ncol=2)
for (t in (TR+1):TF)
{
yy=v_y[1:(t-1)]
xx=qpc[1:t,]
XX1=xx[1:(t-1),se1]
D=t(XX1) %*% XX1
d=t(yy) %*% XX1
C=cbind(rep(1,3),diag(3))
b=c(1,0,0,0)
eq=solve.QP(Dmat = D, dvec = d, Amat = C, bvec = b, meq = 1)
qpc_c3[(t-TR),1]=t(eq$solution)%*%xx[t,se1]
XX2=xx[1:(t-1),]
D=t(XX2) %*% XX2
d=t(yy) %*% XX2
C=cbind(rep(1,5), diag(5))
b=c(1,0,0,0,0,0)
eq=solve.QP(Dmat = D, dvec = d, Amat = C, bvec = b, meq = 1)
qpc_c3[(t-TR),2]=t(eq$solution)%*%xx[t,]
}

################################################################################## 
#############    Kitchen Sink Model                                   ############
################################################################################## 
kic=matrix(nrow=OS)
for (t in (481:(T-1)))
{
y=Y[2:t]
x=pX[1:(t-1),]
eq=lm(y~x)
co=data.frame(eq$coef)
co[is.na(co)]=0
coef=as.matrix(co)
kic[(t-480)]=t(matrix(c(1,pX[t,])))%*%coef[,1]
}

##################################################################################
#############    Figure 3:  PLQCs QPCs PC KS                         #############
##################################################################################
rob1=cbind(rmatrx2[,25:28], qpc_c1,qpc_c2,qpc_c3,pc,kic,rmatrx2[,NM])
name_rob1=c("PLQC1","PLQC2","PLQC3", "PLQC4","QPC1","QPC2","QPC3","QPC4","PC","KS","HA")
subname_rob1=c("PLQC1","PLQC2","PLQC3", "PLCR4","QPC1","QPC3","PC","KS","HA")
v_y4=v_y2 
mse_rob1=apply(rob1,2,function(x) mean((v_y4-x)^2))
var=apply(rob1,2,function(x) var(x))
bias=mse_rob1-var 
N=length(bias)
bias_dif=(bias-bias[N])*100000
var_dif=(var-var[N])*100000
rob1_df2=as.data.frame(cbind(var_dif,bias_dif))
ha=subset(rob1_df2,name_rob1=="HA")
QPC2=subset(rob1_df2,name_rob1=="QPC2")
QPC4=subset(rob1_df2,name_rob1=="QPC4")
sub=subset(rob1_df2, name_rob1!="QPC2"& name_rob1!="QPC4" )
ggplot(rob1_df2, aes(x=bias_dif,y=var_dif))+geom_point(data=ha, colour="red")+ geom_text(data=sub,aes(label=subname_rob1), size=5, vjust=0,hjust=0.75)+geom_text(data=QPC2,label="QPC2", size=5, vjust=-0.5,hjust=-0.5)+geom_text(data=QPC4,label="QPC4", size=5, vjust=-1,hjust=0)+theme(text = element_text(size=20))+ylab("Forecast Variance Difference(e^(-5))")+xlab("Squared Forecast Bias Difference(e^(-5))") 


save.image("Online Results Part 1.RData")


##################################################################################
#############                                                         ############
#############    Replication with Stock Return                        ############
#############                                                         ############
##################################################################################

filename="goyal_welch_RF.csv"
XY = read.csv(filename, header=TRUE, quote="\"",dec=".", fill=TRUE)
pX=as.matrix(XY[,3:17])
X=XY[,2:17]
Y= ts(XY[,18], start=1, freq=1) 

#############   Generation of lambda for each quantile at each time  ############
QuantileM=matrix(nrow=TF,ncol=n_tau)
lambdastar_c2=matrix(nrow=TF,ncol=n_tau)
ntr=500
for (t in Tini:(T-1))
{
x=pX[1:(t-1),]
set.seed(12345)
M=Sn(tau,x,ntr)
QuantileM[t-Tini+1,]=apply(M,2,function(x) quantile(x,1-alpha))
lambdastar_c2[(t-Tini+1),]=2*QuantileM[t-Tini+1,]
}

#############   Generation of post-LASSO quantile forecasts (PLQF)   ############ 
#############   and at the same time,                                ############
#############   record the outcome of selected predictors            ############
for (t in Tini:(T-1))
{
x=pX[1:(t-1),]
y=Y[2:t]
 for (i in 1:n_tau)
 {
 lambdas=lambdastar_c2[(t-Tini+1),i]*(tau[i]*(1-tau[i]))^(0.5)/(t-1)
 eq=rqss(y~x,method="lasso",tau=tau[i],lambda=lambdas)
 s1=summary(eq)
 pvalue_sp=s1$coef[2:16,4]
 II=pvalue_sp<=0.05
 if (sum(II)==0){
 II=rank(pvalue_sp)==1
 }
 II_sp2[(t-Tini+1),i,1:sum(II)]=which(II)
 xx=as.matrix(subset(pX[1:t,],select=which(II)))
 eq=rq(y~xx[1:(t-1),],tau=tau[i])
 predi_sp2[(t-Tini+1),i]=c(1,xx[t,])%*%eq$coef
 }
}

#############   Generation of forecasts PLQC1 and PLQC2 based on     ############  
#############   simple average of 3 or 5 quantile forecasts          ############
se1=c(1,3,5)
mean_qu30=apply(predi_sp2[(TR+1):TF,se1],1,mean)
mean_qu31=apply(predi_sp2[(TR+1):TF,],1,mean)

#############   Generation of forecasts PLQC3 and PLQC4 based on     ############  
#############   weighted average of 3 or 5 quantile forecasts        ############
v_lasso=matrix(nrow=OS,ncol=2)
for (t in (TR+1):TF)
{
yy=v_y[1:(t-1)]
xx=predi_sp2[1:t,]
#############   Time-varying weight scheme 1                         ############
XX1=xx[1:(t-1),se1]
D=t(XX1) %*% XX1
d=t(yy) %*% XX1
C=cbind(rep(1,3),diag(3))
b=c(1,0,0,0)
eq=solve.QP(Dmat = D, dvec = d, Amat = C, bvec = b, meq = 1)
v_lasso[(t-TR),1]=t(eq$solution)%*%xx[t,se1]
#############   Time-varying weight scheme 2                         ############
XX2=xx[1:(t-1),]
D=t(XX2) %*% XX2
d=t(yy) %*% XX2
C=cbind(rep(1,5), diag(5))
b=c(1,0,0,0,0,0)
eq=solve.QP(Dmat = D, dvec = d, Amat = C, bvec = b, meq = 1)
v_lasso[(t-TR),2]=t(eq$solution)%*%xx[t,]
}


##################################################################################
#############    Quantile forecast models                             ############
#############    based on fixed predictors FQR and FOLS models        ############
##################################################################################
 
#############    Fixed quantile forecasts and Fixed OLS forecasts     ############
#############    based on 3 quantile levels                           ############
II_plqc1=II_sp2[,se1,]
PF_plqc1=matrix(nrow=TF,ncol=1)
QF_plqc1=matrix(nrow=TF,ncol=n_tau2)
for (t in Tini:(T-1))
{
y=Y[2:t]
II1=c(unique(II_plqc1[(t-Tini+1),1,]),unique(II_plqc1[(t-Tini+1),2,]),unique(II_plqc1[(t-Tini+1),3,]))
II=unique(II1)
xx=as.matrix(subset(pX[1:t,],select=II))
eq=lm(y~xx[1:(t-1),])
PF_plqc1[(t-Tini+1),1]=c(1,xx[t,])%*%eq$coef
 for (i in 1:n_tau2)
 {
 qeq=rq(y~xx[1:(t-1),],tau=tau2[i])
 QF_plqc1[(t-Tini+1),i]=c(1,xx[t,])%*%qeq$coef
 }
}

#############    Fixed quantile forecasts and Fixed OLS forecasts     ############
#############    based on 5 quantile levels                           ############
II_plqc2=II_sp2 
PF_plqc2=matrix(nrow=TF,ncol=1)
QF_plqc2=matrix(nrow=TF,ncol=n_tau)
for (t in Tini:(T-1))
 {
y=Y[2:t]
II1=c(unique(II_plqc2[(t-Tini+1),1,]),unique(II_plqc2[(t-Tini+1),2,]),unique(II_plqc2[(t-Tini+1),3,]),unique(II_plqc2[(t-Tini+1),4,]),unique(II_plqc2[(t-Tini+1),5,]))
II=unique(II1)
xx=as.matrix(subset(pX[1:t,],select=II))
eq=lm(y~xx[1:(t-1),])
PF_plqc2[(t-Tini+1),1]=c(1,xx[t,])%*%eq$coef
 for (i in 1:n_tau)
 {
 qeq=rq(y~xx[1:(t-1),],tau=tau[i])
 QF_plqc2[(t-Tini+1),i]=c(1,xx[t,])%*%qeq$coef
 }
}

#############    FQR1 and FQR2 based on equal weights                 ############
QF1=apply(QF_plqc1[(TR+1):TF,],1,mean)
QF2=apply(QF_plqc2[(TR+1):TF,],1,mean)

#############    FQR3 and FQR4 based on time-varying weights          ############
QF34=matrix(nrow=OS,ncol=2)
for (t in (TR+1):TF)
{
yy=v_y[1:(t-1)]
xx=QF_plqc1[1:t,]
XX1=xx[1:(t-1),]
D=t(XX1) %*% XX1
d=t(yy) %*% XX1
C=cbind(rep(1,3),diag(3))
b=c(1,0,0,0)
eq=solve.QP(Dmat = D, dvec = d, Amat = C, bvec = b, meq = 1)
QF34[(t-TR),1]=t(eq$solution)%*%xx[t,]
xx=QF_plqc2[1:t,]
XX1=xx[1:(t-1),]
D=t(XX1) %*% XX1
d=t(yy) %*% XX1
C=cbind(rep(1,5), diag(5))
b=c(1,0,0,0,0,0)
eq=solve.QP(Dmat = D, dvec = d, Amat = C, bvec = b, meq = 1)
QF34[(t-TR),2]=t(eq$solution)%*%xx[t,]
}


##################################################################################
#############    Single-predictor Models                              ############
##################################################################################
mean_uni=matrix(nrow=TF,ncol=15)
for (t in Tini:(T-1))
{
yy=Y[2:t]
 for (i in 1:15)
 {
 px=pX[1:(t-1),i]
 eq=lm(yy~px)
 mean_uni[(t-Tini+1),i]=eq$coef[1]+eq$coef[2]*pX[t,i]
 }
}

pf=mean_uni[(TR+1):TF,]

##################################################################################
#############    Complete Subset regression models (CSR k=1, 2 and 3) ############
##################################################################################

#############    CSR with k=1 and K=15                                ############
mean_uni_avg=apply(mean_uni,1,mean)
mean_uni_avg2=mean_uni_avg[(TR+1):TF]

#############    CSR with k=2 and K=15                                ############
K=15
k=2
beta=matrix(nrow=choose(K,k),ncol=16)
beta_csr=matrix(nrow=OS,ncol=16)
CSR=matrix(nrow=OS)
for (t in TNew:(T-1))
{
y=Y[2:t]
r=0
 for (m in (1:14)){
   for (n in ((m+1):15)){
   r=r+1
   x=pX[1:(t-1),c(m,n)]
   eq=lm(y~x)
   beta[r,c(m,n,16)]=eq$coef[c(2:3,1)]
   }
 }
beta_csr[(t-TNew+1),]=apply(beta,2,function(x) sum(x,na.rm=TRUE)/choose(K,k))
CSR[(t-TNew+1)]=c(pX[t,],1)%*%beta_csr[(t-TNew+1),]
}

#############    CSR with k=3 and K=15                                ############
K=15
k=3
beta=matrix(nrow=choose(K,k),ncol=16)
betak3_csr=matrix(nrow=OS,ncol=16)
CSRk3=matrix(nrow=OS)
for (t in TNew:(T-1))
{
y=Y[2:t]
r=0
 for (m in (1:13)){
  for (n in ((m+1):14)){
   for (q in ((n+1):15)){
   r=r+1
   x=pX[1:(t-1),c(m,n,q)]
   eq=lm(y~x)
   beta[r,c(m,n,q,16)]=eq$coef[c(2:4,1)]
   }
  }
 }
betak3_csr[(t-TNew+1),]=apply(beta,2,function(x) sum(x,na.rm=TRUE)/choose(K,k))
CSRk3[(t-TNew+1)]=c(pX[t,],1)%*%betak3_csr[(t-TNew+1),]
}


##################################################################################
#############     Benchmark model: Historical Avarege model           ############
##################################################################################
hsy=matrix(nrow=TF,ncol=1)
for (t in Tini:(T-1))
{
yy=Y[1:t]
eq=lm(yy ~ 1)
hsy[t-Tini+1,1]=eq$coef
}


rmatrx2=as.matrix(cbind(pf, mean_uni_avg2, CSR, CSRk3, PF_plqc1[(TR+1):TF],PF_plqc2[(TR+1):TF], QF1,QF2,QF34, mean_qu30, mean_qu31,v_lasso,hsy[(TR+1):TF]))

##################################################################################
#############                                                         ############
#############      Table 5 Construction                               ############
#############                                                         ############
##################################################################################

##################################################################################
#############      OOS : 1967-2013                                    ############
##################################################################################

NM=ncol(rmatrx2)
#############      Clark and West (2007) test                         ############
MSPE2=matrix(nrow=OS, ncol=(NM-1))
for (m in 1:(NM-1))
{
MSPE2[,m]=(v_y2-rmatrx2[,NM])^2-(v_y2-rmatrx2[,m])^2+(rmatrx2[,NM]-rmatrx2[,m])^2 
}
pvalue2=matrix(nrow=(NM-1))
for (m in 1:(NM-1))
{
eq=t.test(MSPE2[,m],alternative="greater", confi.level=0.90)
pvalue2[m,]=eq$p.value
}

#############      Diebold and Mariano (1995) test                    ############
umatrx=apply(rmatrx2,2,function(x) v_y2-x)
u1=umatrx[,ncol(umatrx)]
u2=umatrx[,1:(ncol(umatrx)-1)]
##################### Diebold-Mariano test ##############################
dmpval=matrix(nrow=ncol(umatrx)-1)
for (i in 1:(ncol(umatrx)-1)){
dm=dm.test(u1,u2[,i],alternative="greater",h=1,power=1)
dmpval[i]=dm$p.value
}

#############      R2 statistics                                      ############
mse_matrx2=apply(rmatrx2,2,function(x) mean((v_y2-x)^2) )
R2_s=matrix(nrow=(NM-1))
for (i in 1:(NM-1))
{
R2_s[i]=1-mse_matrx2[i]/mse_matrx2[NM]
}

#############      Utility Gains                                      ############
ry=XY[,18]
sigma2=matrix(nrow=TF)
for (t in Tini:(T-1))
{
yy=ry[1:t]
sigma2[(t-Tini+1),]=var(yy)
}
sigma2_s=sigma2[(TR+1):TF]
rf=XY[TNew:(T-1),19]
return=apply(rmatrx2,2,function(x) x+rf)
W2=matrix(nrow=OS,ncol=NM)
g=3
for (w in 1:NM)
{
W2[,w]=(1/g)*(return[,w]/sigma2_s)
}
W2[W2<0]=0
W2[W2>1.5]=1.5
rf2=XY[482:T,19]
ret=ry[482:T]
V2=matrix(nrow=OS,ncol=NM)
for (k in 1:NM)
{
V2[,k]=W2[,k]*ret+(1-W2[,k])*rf2
}
mu2=apply(V2,2,function(x) mean(x))
sigma_s=apply(V2,2,function(x) var(x))
Vj2=mu2-0.5*g*sigma_s
U2=matrix(nrow=NM-1)
for (m in 1:(NM-1))
{
U2[m]=(Vj2[m]-Vj2[NM])*1200
}

f1=cbind(R2_s[1:28,]*100,dmpval[1:28,],pvalue2[1:28,],U2[1:28,])


##################################################################################
#############      OOS : 1967-1990                                    ############
##################################################################################
TS=1
TE=288
rmatrx3=rmatrx2[TS:TE,]
OS2=nrow(rmatrx3)
MSPE2=matrix(nrow=OS2, ncol=(NM-1))
v_y4=v_y2[TS:TE]
#############      Clark and West (2007) test                         ############
for (m in 1:(NM-1))
{
MSPE2[,m]=(v_y4-rmatrx3[,NM])^2-(v_y4-rmatrx3[,m])^2+(rmatrx3[,NM]-rmatrx3[,m])^2 
}
pvalue2=matrix(nrow=(NM-1))
for (m in 1:(NM-1))
{
eq=t.test(MSPE2[,m],alternative="greater", confi.level=0.90)
pvalue2[m,]=eq$p.value
}

#############      Diebold and Mariano (1995) test                    ############
umatrx=apply(rmatrx3,2,function(x) v_y4-x)
u1=umatrx[,ncol(umatrx)]
u2=umatrx[,1:(ncol(umatrx)-1)]
dmpval=matrix(nrow=ncol(umatrx)-1)
for (i in 1:(ncol(umatrx)-1)){
dm=dm.test(u1,u2[,i],alternative="greater",h=1,power=1)
dmpval[i]=dm$p.value
}

#############      R2 statistics                                      ############
mse_matrx2=apply(rmatrx3,2,function(x) mean((v_y4-x)^2))
R2_s=matrix(nrow=(NM-1))
for (i in 1:(NM-1))
{
R2_s[i]=1-mse_matrx2[i]/mse_matrx2[NM]
}

#############      Utility Gains                                      ############
V=V2[TS:TE,]
mu2=apply(V,2,function(x) mean(x))
sigma_s=apply(V,2,function(x) var(x))
Vj2=mu2-0.5*g*sigma_s
U2=matrix(nrow=NM-1)
for (m in 1:(NM-1))
{
U2[m]=(Vj2[m]-Vj2[NM])*1200
}
f2=cbind(R2_s[1:28,]*100,dmpval[1:28,],pvalue2[1:28,],U2[1:28,])


##################################################################################
#############      OOS : 1991-2013                                    ############
##################################################################################
TS=289
TE=564
rmatrx3=rmatrx2[TS:TE,]
OS2=nrow(rmatrx3)
MSPE2=matrix(nrow=OS2, ncol=(NM-1))
v_y4=v_y2[TS:TE]
#############      Clark and West (2007) test                         ############
for (m in 1:(NM-1))
{
MSPE2[,m]=(v_y4-rmatrx3[,NM])^2-(v_y4-rmatrx3[,m])^2+(rmatrx3[,NM]-rmatrx3[,m])^2 
}
pvalue2=matrix(nrow=(NM-1))
for (m in 1:(NM-1))
{
eq=t.test(MSPE2[,m],alternative="greater", confi.level=0.90)
pvalue2[m,]=eq$p.value
}

#############      Diebold and Mariano (1995) test                    ############
umatrx=apply(rmatrx3,2,function(x) v_y4-x)
u1=umatrx[,ncol(umatrx)]
u2=umatrx[,1:(ncol(umatrx)-1)]
##################### Diebold-Mariano test ##############################
dmpval=matrix(nrow=ncol(umatrx)-1)
for (i in 1:(ncol(umatrx)-1)){
dm=dm.test(u1,u2[,i],alternative="greater",h=1,power=1)
dmpval[i]=dm$p.value
}

#############      R2 statistics                                      ############
mse_matrx2=apply(rmatrx3,2,function(x) mean((v_y4-x)^2))
R2_s=matrix(nrow=(NM-1))
for (i in 1:(NM-1))
{
R2_s[i]=1-mse_matrx2[i]/mse_matrx2[NM]
}

#############      Utility Gains                                      ############
V=V2[TS:TE,]
##For mu and sigma
mu2=apply(V,2,function(x) mean(x))
sigma_s=apply(V,2,function(x) var(x))
Vj2=mu2-0.5*g*sigma_s
U2=matrix(nrow=NM-1)
for (m in 1:(NM-1))
{
U2[m]=(Vj2[m]-Vj2[NM])*1200
}

f3=cbind(R2_s[1:28,]*100,dmpval[1:28,],pvalue2[1:28,],U2[1:28,])


##################################################################################
#############      OOS : 2008-2013                                    ############
##################################################################################
TS=493
TE=564
rmatrx3=rmatrx2[TS:TE,]
OS2=nrow(rmatrx3)
MSPE2=matrix(nrow=OS2, ncol=(NM-1))
v_y4=v_y2[TS:TE]
#############      Clark and West (2007) test                         ############
for (m in 1:(NM-1))
{
MSPE2[,m]=(v_y4-rmatrx3[,NM])^2-(v_y4-rmatrx3[,m])^2+(rmatrx3[,NM]-rmatrx3[,m])^2 
}
pvalue2=matrix(nrow=(NM-1))
for (m in 1:(NM-1))
{
eq=t.test(MSPE2[,m],alternative="greater", confi.level=0.90)
pvalue2[m,]=eq$p.value
}

#############      Diebold and Mariano (1995) test                    ############
umatrx=apply(rmatrx3,2,function(x) v_y4-x)
u1=umatrx[,ncol(umatrx)]
u2=umatrx[,1:(ncol(umatrx)-1)]
dmpval=matrix(nrow=ncol(umatrx)-1)
for (i in 1:(ncol(umatrx)-1)){
dm=dm.test(u1,u2[,i],alternative="greater",h=1,power=1)
dmpval[i]=dm$p.value
}

#############      R2 statistics                                      ############
mse_matrx2=apply(rmatrx3,2,function(x) mean((v_y4-x)^2))
R2_s=matrix(nrow=(NM-1))
for (i in 1:(NM-1))
{
R2_s[i]=1-mse_matrx2[i]/mse_matrx2[NM]
}

#############      Utility Gains                                      ############
V=V2[TS:TE,]
mu2=apply(V,2,function(x) mean(x))
sigma_s=apply(V,2,function(x) var(x))
Vj2=mu2-0.5*g*sigma_s
U2=matrix(nrow=NM-1)
for (m in 1:(NM-1))
{
U2[m]=(Vj2[m]-Vj2[NM])*1200
}

f4=cbind(R2_s[1:28,]*100,dmpval[1:28,],pvalue2[1:28,],U2[1:28,])

f=cbind(f1,f2,f3,f4)
write.csv(f,file="table5new.csv")


##################################################################################
#############                                                         ############
#############      Fig 4 & 5: Cumulative Sqaured Predictor Errors     ############
#############                                                         ############
##################################################################################
cpe=matrix(nrow=OS,ncol=NM-1)
for (m in (1:(NM-1)))
{
cpe[,m]=cumsum((v_y2-rmatrx2[,NM])^2-(v_y2-rmatrx2[,m])^2)
}
cpe100=apply(cpe,2,function(x) x*100)
z=rep(0,OS)
zz=ts(z,frequency=12,start=c(1967,1))
date=seq(as.Date("1967-01-01"),by="month",along=zz)
cpe_data=ts(cpe100[,],frequency=12,start=c(1967,1))

#############      Figure 1 : Single-predictor forecasts              ############
uni_var=c("DP", "DY","EP","DE", "SVAR", "BM", "NTIS","TBL","LTY","LTR", "TMS", "DFY", "DFR", "INFL", "E10P")
par(mar=c(3,4,0.2,0.5))
par(mfrow=c(3,5))
for (i in 1:15)
{
plot(cpe_data[,i],type="l",ylab=uni_var[i],ylim=c(-4,2.5),xlab="")
lines(zz,lty="dashed")
abline(v=c(1990,12),lty=4,col="red")
axis(1,at=seq(date[1],date[2],along=date), label=(format(date,"%Y-%m")))
}

#############      Figure 2 : PLQC FQR FOLS and CSR Forecasts          ############
com_va=c("PLQC1","PLQC2","PLQC3", "PLQC4","FQR1","FQR2","FQR3","FQR4","FOLS1","FOLS2","CSR k=1","CSR k=2","CSR k=3")
par(mar=c(3,4,0.2,0.5))
par(mfrow=c(4,4))
nn=0
for (i in c(25:28,21:24,19:20,16:18))
{ 
nn=nn+1
plot(cpe_data[,i],type="l",ylab=com_va[nn],ylim=c(-1,3.5),xlab="",xlim=c(1967,2013))
lines(zz,lty="dashed")
abline(v=c(1990,12),lty=4,col="red")
axis(1,at=seq(date[1],date[2],along=date), label=(format(date,"%Y-%m")))
}

##################################################################################
#############                                                         ############
#############      Table 6  Construction : FOLS2, FQR2 and PLQC 2     ############
#############                                                         ############
##################################################################################
MSPE1=apply(rmatrx2[1:288,c(20,22,27)],2,function(x) mean((v_y2[1:288]-x)^2))
MSPE2=apply(rmatrx2[289:564,c(20,22,27)],2,function(x) mean((v_y2[289:564]-x)^2))
Dcp=cbind(MSPE1,MSPE2)
e2=(Dcp[2,]-Dcp[3,])
e1=(Dcp[1,]-Dcp[2,])
e=e1+e2
#############      % of MSPE errors Pre-90                            ############
e1[1]/e[1]
e2[1]/e[1]
#############      % of MSPE errors Post-90                           ############
e1[2]/e[2]
e2[2]/e[2]

save.image("Online Results Part 2.RData")

