%% Import data from csv files.
% Set up the file directory 
cd 'F:\classes\Dessertation\VaR\Density Forecast for lasso\modified figures\new rules\Excess return'

filename = 'tau30.csv';
delimiter = ',';
startRow = 2;
formatSpec = '%*q%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%[^\n\r]';
fileID = fopen(filename,'r');
dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'HeaderLines' ,startRow-1, 'ReturnOnError', false);
fclose(fileID);
tau30 = [dataArray{1:end-1}];
clearvars filename delimiter startRow formatSpec fileID dataArray ans;

filename = 'tau40.csv';
delimiter = ',';
startRow = 2;
formatSpec = '%*q%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%[^\n\r]';
fileID = fopen(filename,'r');
dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'HeaderLines' ,startRow-1, 'ReturnOnError', false);
fclose(fileID);
tau40 = [dataArray{1:end-1}];
clearvars filename delimiter startRow formatSpec fileID dataArray ans;

filename = 'tau50.csv';
delimiter = ',';
startRow = 2;
formatSpec = '%*q%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%[^\n\r]';
fileID = fopen(filename,'r');
dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'HeaderLines' ,startRow-1, 'ReturnOnError', false);
fclose(fileID);
tau50 = [dataArray{1:end-1}];
clearvars filename delimiter startRow formatSpec fileID dataArray ans;

filename = 'tau60.csv';
delimiter = ',';
startRow = 2;
formatSpec = '%*q%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%[^\n\r]';
fileID = fopen(filename,'r');
dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'HeaderLines' ,startRow-1, 'ReturnOnError', false);
fclose(fileID);
tau60 = [dataArray{1:end-1}];
clearvars filename delimiter startRow formatSpec fileID dataArray ans;

filename = 'tau70.csv';
delimiter = ',';
startRow = 2;
formatSpec = '%*q%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%[^\n\r]';
fileID = fopen(filename,'r');
dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'HeaderLines' ,startRow-1, 'ReturnOnError', false);
fclose(fileID);
tau70 = [dataArray{1:end-1}];
clearvars filename delimiter startRow formatSpec fileID dataArray ans;

%% The construction of Figure 5 
t1=datetime(1967,1,1);
t2=datetime(2013,12,1);
t=t1:calmonths(1):t2;
T=size(t,2);
Base=zeros(T,15);
for i=1:15
      Base(:,i)=i;
end

% Convert Datetime to Date numbers 
tt=datenum(t);

tau30(tau30==0)=nan;
tau40(tau40==0)=nan;
tau50(tau50==0)=nan;
tau60(tau60==0)=nan;
tau70(tau70==0)=nan;

  
figure;
subplot_tight(3,2,1,0.05);
plot(t,tau30,'r+');
hold on
plot(t,Base,'LineStyle',':','LineWidth',1.2,'color','b');
hold off
set(gca,'YTickLabel',{'DP','DY',	'EP',	'DE',	'SVAR',	'BM',	'NTIS',	'TBL',	'LTY','LTR'	,'TMS',	'DFY',	'DFR'	,'INFL',	'E10P'},'YTick',[1 2 3 4 5 6 7 8 9 10 11 12 13 14 15],'FontSize',14,'Xlim',[tt(1) tt(564)]);
datetick('x','mmmyy','keeplimits')
ylabel({'Predictors'},'fontsize',15);
title('\tau = 0.3','fontsize',15);
subplot_tight(3,2,2,0.05);
plot(t,tau50,'r+');
hold on
plot(t,Base,'LineStyle',':','LineWidth',1.2,'color','b');
hold off
set(gca,'YTickLabel',{'DP','DY',	'EP',	'DE',	'SVAR',	'BM',	'NTIS',	'TBL',	'LTY','LTR'	,'TMS',	'DFY',	'DFR'	,'INFL',	'E10P'},'YTick',[1 2 3 4 5 6 7 8 9 10 11 12 13 14 15],'FontSize',14,'Xlim',[tt(1) tt(564)]);
datetick('x','mmmyy','keeplimits')
ylabel({'Predictors'},'fontsize',15);
title('\tau = 0.4','fontsize',15);
subplot_tight(3,2,3,0.05);
plot(t,tau50,'r+');
hold on
plot(t,Base,'LineStyle',':','LineWidth',1.2,'color','b');
hold off
set(gca,'YTickLabel',{'DP','DY',	'EP',	'DE',	'SVAR',	'BM',	'NTIS',	'TBL',	'LTY','LTR'	,'TMS',	'DFY',	'DFR'	,'INFL',	'E10P'},'YTick',[1 2 3 4 5 6 7 8 9 10 11 12 13 14 15],'FontSize',14,'Xlim',[tt(1) tt(564)]);
datetick('x','mmmyy','keeplimits')
ylabel({'Predictors'},'fontsize',15);
title('\tau = 0.5','fontsize',15);
subplot_tight(3,2,4,0.05);
plot(t,tau60,'r+');
hold on
plot(t,Base,'LineStyle',':','LineWidth',1.2,'color','b');
hold off
set(gca,'YTickLabel',{'DP','DY',	'EP',	'DE',	'SVAR',	'BM',	'NTIS',	'TBL',	'LTY','LTR'	,'TMS',	'DFY',	'DFR'	,'INFL',	'E10P'},'YTick',[1 2 3 4 5 6 7 8 9 10 11 12 13 14 15],'FontSize',14,'Xlim',[tt(1) tt(564)]);
datetick('x','mmmyy','keeplimits')
ylabel({'Predictors'},'fontsize',15);
title('\tau = 0.6','fontsize',15);
subplot_tight(3,2,5,0.05);
plot(t,tau70,'r+');
hold on
plot(t,Base,'LineStyle',':','LineWidth',1.2,'color','b');
hold off
set(gca,'YTickLabel',{'DP','DY',	'EP',	'DE',	'SVAR',	'BM',	'NTIS',	'TBL',	'LTY','LTR'	,'TMS',	'DFY',	'DFR'	,'INFL',	'E10P'},'YTick',[1 2 3 4 5 6 7 8 9 10 11 12 13 14 15],'FontSize',14,'Xlim',[tt(1) tt(564)]);
datetick('x','mmmyy','keeplimits')
ylabel({'Predictors'},'fontsize',15);
title('\tau = 0.7','fontsize',15);
tightfig;




