% LICENSE FOR CODE:
% Copyright Federal Reserve Bank of New York and Federal Reserve Bank of Dallas.
% You may reproduce, use, modify, make derivative works of, and distribute this code in whole or in part 
% so long as you keep this notice in the documentation associated with any distributed works. 
% Neither the names of the Federal Reserve Bank of New York and Federal Reserve Bank of Dallas nor the names 
% of any of the authors may be used to endorse or promote works derived from this 
% code without prior written permission. Portions of the code attributed to third 
% parties are subject to applicable third party licenses and rights. By your 
% use of this code you accept this license and any applicable third party license.
% THIS CODE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT ANY WARRANTIES OR CONDITIONS 
% OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY WARRANTIES
% OR CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A 
% PARTICULAR PURPOSE, EXCEPT TO THE EXTENT THAT THESE DISCLAIMERS ARE HELD TO 
% BE LEGALLY INVALID. THE FEDERAL RESERVE BANK OF NEW YORK AND THE FEDERAL 
% RESERVE BANK OF DALLAS ARE NOT, UNDER ANY CIRCUMSTANCES, LIABLE TO YOU FOR
% DAMAGES OF ANY KIND ARISING OUT OF OR IN CONNECTION WITH USE OF OR INABILITY
% TO USE THE CODE, INCLUDING, BUT NOT LIMITED TO DIRECT, INDIRECT, INCIDENTAL,
% CONSEQUENTIAL, PUNITIVE, SPECIAL OR EXEMPLARY DAMAGES, WHETHER BASED ON BREACH
% OF CONTRACT, BREACH OF WARRANTY, TORT OR OTHER LEGAL OR EQUITABLE THEORY, EVEN
% IF THE FEDERAL RESERVE BANK OF NEW YORK OR THE FEDERAL RESERVE BANK OF DALLAS
% HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES OR LOSS AND REGARDLESS
% OF WHETHER SUCH DAMAGES OR LOSS IS FORESEEABLE.

function [xTransf] = transformData(x,transf)
%%% Transforms a given input series, base on a given transformation
%%% Note: Intended for weekly frequency data
%   Inputs: 
%     - x: a T x 1 matrix of raw data
%     - transf: a string with one of the following transformations
%         - 'd52l' : 52-week log change
%         - 'lin'  : No transformation
%         - 'pc52' : 52-week percent change
%         - 'pc'   : 1-week percent change      
%   Outputs: 
%     - xTranf: a T x 1 matrix of the transformed series

%%
% Makign x into a column vector
x = x(:);

% Which transformation should be made?
switch transf

    case 'd52l' % 52-week log change

        xTransf = (log(x) - log(lagmatrix(x, 52))) .* 100;

    case 'lin'  % No transformation

        xTransf = x;

    case 'pc52' % 52-week percent change

        xTransf = ((x - lagmatrix(x, 52)) ./ lagmatrix(x, 52)) .* 100;

    case 'pc'   % 1-week percent change

        xTransf = ((x - lagmatrix(x, 1)) ./ lagmatrix(x, 1)) .* 100;


    otherwise 
        error('Incorrect Transformation')

end

end

