
clear all
set more off

global path "."									/*path on your computer*/
use "$path\_datasets\TFP_china_tech"			/*path to the cleaned panel dataset 1998-2007*/

rename NewID id

  program tsset_boot
	sort id year
    bys id: gen first = year[_n]==year[_n-1]
    bys id year: gen second = sum(first)
	gen double id2 = 0.01*second + id
    format id2 %8.2f
    rename id idold
    rename id2 id
	drop first second idold
  end program

	bsample, cluster(id)
	tsset_boot

do "linear_2"
	
keep bk bl bm bu bv gamma1 gamma2 immediate1 immediate2 rho	
keep if _n == 1

