
*----------------------------------------
*** Model 2: GNR linear for HKMT and OECD

drop v
rename v4 u
rename v5 v

* Run OLS of s on constant, identify epsilon and beta_m
	
	cap drop s_hat
	cap drop epsilon
	qui su sm
	gen s_hat=r(mean) $if
	gen epsilon = s_hat - sm

	cap drop D_hat
	gen D_hat = exp(s_hat)

	cap drop e_epsilon
	gen e_epsilon=exp(epsilon)
	qui su e_epsilon, meanonly
	scalar E_epsilon = r(mean)

* Calculate partial derivative w.r.t inputs
	cap drop partial
	gen partial = D_hat/E_epsilon
	qui su partial $if, mean
	scalar bm = r(mean)

* Calculate integration
	cap drop i_D_hat
	gen i_D_hat = bm*m

* Caculate depdendent variable Y_greek hat for second-stage
	cap drop vg
	gen vg = yg - epsilon - i_D_hat

* Run second-stage
	tset id year	
	reg vg L.vg k l u v L.k L.l L.u L.v d_HKMT d_OECD
	matrix b=e(b)

	scalar rho = b[1,1]
	scalar bk = b[1,2]
	scalar bl = b[1,3]
	scalar bu = b[1,4]
	scalar bv = b[1,5]
	scalar gamma1 = b[1,10]
	scalar gamma2 = b[1,11]
	scalar bm = bm
	
di bk bl bm bu bv rho gamma1 gamma2

	gen bk = bk
	gen bl = bl
	gen bm = bm
	gen bu = bu
	gen bv = bv
	gen gamma1 = gamma1
	gen gamma2 = gamma2
	gen immediate1 = bu+gamma1
	gen immediate2 = bv+gamma2
	gen rho = rho	

















	