
/* This code is designed to estimate the baseline model in LLP(2022). The model
includes 3 inputs (captial, labor, material) and 1 state variable (v).
*/

* First-stage approximation includes 18 terms:
* k l m v kk ll mm kl km kv lm lv mv klm klv kmv lmv klmv 
	gen kk=k*k
	gen ll=l*l
	gen mm=m*m
	
	gen kl=k*l
	gen km=k*m
	gen kv=k*v
	
	gen lm=l*m
	gen lv=l*v
	
	gen mv=m*v
	
	gen klm=k*l*m
	gen klv=k*l*v
	gen kmv=k*m*v
	gen lmv=l*m*v
	
	gen klmv=k*l*m*v
	
*** First-stage using NLS ***
* Guess initial values from OLS log-share refression
	regress sm k l m v kk ll mm kl km kv lm lv mv klm klv kmv lmv klmv if sm~=. & l~=. & k~=. & m~=.
	matrix test = e(b)
	predict temp_c if sm~=. & l~=. & k~=. & m~=.
	replace temp_c = temp_c - _b[_cons]

* Correct constant term for initial values
	egen mtemp_c = min(temp_c)
	scalar ntemp_c=mtemp_c
	drop temp_c mtemp_c
	scalar ntemp_c=-ntemp_c + 0.1

* NLS with initial values from OLS
	#delimit;
	nl ( sm = ln({g0=ntemp_c} + {gk=_b[k]}*k + {gl=_b[l]}*l + {gm=_b[m]}*m + {gv=_b[v]}*v +
		{gkk=_b[kk]}*kk + {gll=_b[ll]}*ll + {gmm=_b[mm]}*mm + {gkl=_b[kl]}*kl + {gkm=_b[km]}*km +
		{gkv=_b[kv]}*kv + {glm=_b[lm]}*lm + {glv=_b[lv]}*lv + {gmv=_b[mv]}*mv +
		{gklm=_b[klm]}*klm + {gklv=_b[klv]}*klv + {gkmv=_b[kmv]}*kmv + {glmv=_b[lmv]}*lmv +
		{gklmv=_b[klmv]}*klmv)) if sm~=. & l~=. & k~=. & m~=., iter(100);
	#delimit cr

	gen test = e(converge)
	if test ~= 1 exit
	
* Predict values from NLS
	predict ielas if sm~=. & l~=. & k~=. & m~=.

* Adjust predicted value, obtain elasticity w.r.t material m
	predict eg if sm~=. & l~=. & k~=. & m~=., resid
	replace eg=-eg
	egen mexp_eg=mean(exp(eg))
	su mexp_eg						// more reliable if mean equal 1
	replace ielas = ielas-ln(mexp_eg)
	replace ielas = exp(ielas)

* Rename and save mean adjusted coefficients of estimation
	mat beta=e(b)
	svmat double beta
	ren beta1 g0
	ren beta2 gk
	ren beta3 gl
	ren beta4 gm
	ren beta5 gv
	ren beta6 gkk
	ren beta7 gll
	ren beta8 gmm
	ren beta9 gkl
	ren beta10 gkm
	ren beta11 gkv
	ren beta12 glm
	ren beta13 glv
	ren beta14 gmv
	ren beta15 gklm
	ren beta16 gklv
	ren beta17 gkmv
	ren beta18 glmv
	ren beta19 gklmv

* Adjust coefficients for measurement errors/random shocks
	foreach var of varlist g0-gklmv {
		egen s`var'=mean(`var')
		drop `var'
		ren s`var' `var'
		replace `var' = `var' / mexp_eg
	}	
	*clear matrix
	
	local poly k l m v kk ll mm kl km kv lm lv mv klm klv kmv lmv klmv // m mm km lm mv klm kmv lmv klmv 
	matrix Gamma=beta
	matrix cole Gamma = GNR
	matrix coln Gamma = _cons `poly'
	matrix list Gamma
	
	cap drop xb
	matrix score double xb = Gamma $if
	cap drop s_hat
	gen s_hat = ln(xb) $if
	
* Compute the integral
	gen integ_G_I = g0 + gk*k + gl*l + gv*v + gkk*kk + gll*ll + gkl*kl + gkv*kv + glv*lv + ///
					gklv*klv + (gm*m + gkm*km + glm*lm + gmv*mv + gklm*klm + gkmv*kmv + glmv*lmv + gklmv*klmv)/2 + ///
					gmm*mm/3
	replace integ_G_I=integ_G_I*m

* Construct script_Y
	gen vg = yg - eg - integ_G_I

* Generate lagged variables
* Approximate C(k,l,v) by 9 terms
* k l v kk ll kl kv lv klv
	tset id year

	gen vg_1=L.vg
	gen l_1=L.l
	gen k_1=L.k
	gen v_1=L.v
	gen kk_1=L.kk
	gen ll_1=L.ll
	gen kl_1=L.kl
	gen kv_1=L.kv
	gen lv_1=L.lv
	gen klv_1=L.klv

	gen k_l_1=k*l_1
	gen l_1v = l_1*v
	gen kl_1v = k*l_1*v
	
	gen vg_2=L2.vg
	gen l_2=L2.l
	gen k_2=L2.k
	gen v_2=L2.v
	gen kk_2=L2.kk
	gen ll_2=L2.ll
	gen kl_2=L2.kl
	gen kv_2=L2.kv
	gen lv_2=L2.lv
	gen klv_2=L2.klv
	
* Define GMM evaluator /*might be more efficient to do regressions on the Markov process*/
	cap program drop gmm_GNR1
	program gmm_GNR1
		version 14
		syntax varlist if, at(name) mylhs(varlist)
		quietly{
				tempvar C h omega
				matrix C_theta = `at'[1..1,1..9]
				matrix coln C_theta = k l v kk ll kl kv lv klv
				matrix score double `C' = C_theta `if'		
				matrix h_delta = `at'[1..1,10..12]
				gen `omega'=`mylhs'+`C'
				replace `varlist' = `mylhs' + `C' - h_delta[1,1] ///
								- h_delta[1,2]*L.`omega' - h_delta[1,3]*d `if'
		}
	end

* Set initial values using OLS estimation of script_Y on capital, labor, their squares and interaction term
	reg vg k l v kk ll kl kv lv klv vg_1 d
	matrix test2 = e(b)
	matrix test3 = J(1,12,0)
	matrix test3[1,1] = test2[1,"k"]
	matrix test3[1,2] = test2[1,"l"]
	matrix test3[1,3] = test2[1,"v"]
	matrix test3[1,4] = test2[1,"kk"]
	matrix test3[1,5] = test2[1,"ll"]
	matrix test3[1,6] = test2[1,"kl"]
	matrix test3[1,7] = test2[1,"kv"]
	matrix test3[1,8] = test2[1,"lv"]
	matrix test3[1,9] = test2[1,"klv"]
	matrix test3[1,10] = test2[1,"_cons"]
	matrix test3[1,11] = test2[1,"vg_1"]
	matrix test3[1,12] = test2[1,"d"]
	
	matrix list test3
	matrix drop test2
	
	*xtset id year
	local dv vg
	gmm gmm_GNR1 $if, nequations(1) parameters(k l v kk ll kl kv lv klv _cons rho gamma) ///
	instruments(k l v kk ll kl kv lv klv vg_1 d k_1 l_1 v_1 kk_1 ll_1 kl_1 kv_1 lv_1 klv_1) mylhs(`dv') nolog from(test3)
 	replace test = e(converged)
	if test ~= 1 exit
	
	matrix coef=e(b)
	svmat double coef
	
	*matrix list C_theta
	svmat double C_theta
	
	*matrix list h_delta
	svmat double h_delta
	
	scalar rho = h_delta[1,2]	
	scalar gamma = h_delta[1,3]
	*svmat double gamma
	
	cap drop C 
	cap drop omega 
	cap drop f_hat
	cap drop y_hat
	matrix score double C = C_theta $if
	gen omega = vg + C
	kdensity omega $if
	gen f_hat = yg - eg - omega
	gen y_hat = yg - eg
	
* Generate output elasticities of labor and capital inputs
* Note that partial f: k l m v kk ll mm kl km kv lm lv mv klm klv kmv lmv klmv 
* C(.): k l v kk ll kl kv lv klv
	gen kelas = gk*m + 2*gkk*km + gkl*lm + gkv*mv + gklv*lmv + gkm*mm/2 + gklm*lm*m/2 + gkmv*mv*m/2 + gklmv*lmv*m/2 ///
					- (C_theta[1,1] + 2*C_theta[1,4]*k + C_theta[1,6]*l + C_theta[1,7]*v + C_theta[1,9]*lv)
					
	gen lelas = gl*m + 2*gll*lm + gkl*km + glv*mv + gklv*kmv + glm*mm/2 + gklm*km*m/2 + glmv*mv*m/2 + gklmv*kmv*m/2 ///
					- (C_theta[1,2] + 2*C_theta[1,5]*l + C_theta[1,6]*k + C_theta[1,8]*v + C_theta[1,9]*kv)
					
	gen melas = ielas					

	gen velas = gv*m + gkv*km + glv*lm + gklv*klm + (gmv*mm + gkmv*km*m + glmv*lm*m + gklmv*klm*m)/2 ///
					- (C_theta[1,3] + C_theta[1,7]*k + C_theta[1,8]*l + C_theta[1,9]*kl)

* Generate elasticity w.r.t v (long-run effect) and v+d (short-run effect)
	gen lteffect = velas
	gen steffect = lteffect + gamma
	
* Other parameters
	gen gamma = gamma
	gen rho = rho
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	