
/*******************************
*** Testing and Decomposition***
*******************************/

global path "."										/*path on your computer*/
cd "$path"
	
use "$path\_datasets\TFP_china_tech_2.dta", clear  /*path to the estiamted data for extened model*/
	
* Compute counterfactual elasticities

*------------------------------------------	
* First step: generate counterfactual terms

	gen v0=0
	gen v1=1
	
	local linear k l m u v0
	local square kk ll mm
	local int_2					// second-order
	local int_3					// third-order (interactions only)
	local int_4					// fourth-order (interactions only)
	local nvar : word count `linear'
	forval i = 1/`nvar' {
		local t = `i'+1
		local x : word `i' of `linear'
			forval j = `t'/`nvar' {
				local r = `j'+1
				local y : word `j' of `linear'
				cap gen `x'`y' = `x'*`y'
				local int_2 `int_2' `x'`y'
					forval s = `r'/`nvar' {
						local w = `s'+1
						local z: word `s' of `linear'
						cap gen `x'`y'`z' = `x'*`y'*`z'
						local int_3 `int_3' `x'`y'`z'
							forval a = `w'/`nvar' {
								local b: word `a' of `linear'
								cap gen `x'`y'`z'`b' = `x'*`y'*`z'*`b'
								local int_4 `int_4' `x'`y'`z'`b'
					}
				}
		}
	}
	local poly1 `linear' `square' `int_2' `int_3' `int_4' klmuv0
	local nterm : word count `poly1'
	di "`poly1'"
	di `nterm'
	
	local linear k l m u v1
	local square kk ll mm
	local int_2					// second-order
	local int_3					// third-order (interactions only)
	local int_4					// fourth-order (interactions only)
	local nvar : word count `linear'
	forval i = 1/`nvar' {
		local t = `i'+1
		local x : word `i' of `linear'
			forval j = `t'/`nvar' {
				local r = `j'+1
				local y : word `j' of `linear'
				cap gen `x'`y' = `x'*`y'
				local int_2 `int_2' `x'`y'
					forval s = `r'/`nvar' {
						local w = `s'+1
						local z: word `s' of `linear'
						cap gen `x'`y'`z' = `x'*`y'*`z'
						local int_3 `int_3' `x'`y'`z'
							forval a = `w'/`nvar' {
								local b: word `a' of `linear'
								cap gen `x'`y'`z'`b' = `x'*`y'*`z'*`b'
								local int_4 `int_4' `x'`y'`z'`b'
					}
				}
		}
	}
	local poly2 `linear' `square' `int_2' `int_3' `int_4' klmuv1
	local nterm : word count `poly2'
	di "`poly2'"
	di `nterm'

*-------------------------------------------------
* Second step: compute counterfactual elasticities
* k l u v kk ll kl ku kv lu lv klu klv

	*--------
	* Labor
	cap drop lelas0 lelas1
	gen lelas0 = gl*m + 2*gll*lm + gkl*km + glu*mu + glv*mv0 + gklu*kmu + gklv*kmv0 + glm*mm/2 + gklm*km*m/2 + glmu*mu*m/2 + glmv*mv0*m/2 + gklmu*kmu*m/2 + gklmv*kmv0*m/2 ///
					- (cl + 2*cll*l + ckl*k + clu*u + clv*v0 + cklu*ku + cklv*kv0)

	gen lelas1 = gl*m + 2*gll*lm + gkl*km + glu*mu + glv*mv1 + gklu*kmu + gklv*kmv1 + glm*mm/2 + gklm*km*m/2 + glmu*mu*m/2 + glmv*mv1*m/2 + gklmu*kmu*m/2 + gklmv*kmv1*m/2 ///
					- (cl + 2*cll*l + ckl*k + clu*u + clv*v1 + cklu*ku + cklv*kv1)
					
	su lelas1, meanonly
	local meanl1 = r(mean)
	su lelas0, meanonly
	local meanl0 = r(mean)
	
	ttest lelas1==lelas0
	
	*--------------
	* Capital
	gen kelas0 = gk*m + 2*gkk*km + gkl*lm + gku*mu + gkv*mv0 + gklu*lmu + gklv*lmv0 + gkm*mm/2 + gklm*lm*m/2 + gkmu*mu*m/2 + gkmv*mv0*m/2 + gklmu*lmu*m/2 + gklmv*lmv0*m/2 ///
					- (ck + 2*ckk*k + ckl*l + cku*u + ckv*v0 + cklu*lu + cklv*lv0)
	
	gen kelas1 = gk*m + 2*gkk*km + gkl*lm + gku*mu + gkv*mv1 + gklu*lmu + gklv*lmv1 + gkm*mm/2 + gklm*lm*m/2 + gkmu*mu*m/2 + gkmv*mv1*m/2 + gklmu*lmu*m/2 + gklmv*lmv1*m/2 ///
					- (ck + 2*ckk*k + ckl*l + cku*u + ckv*v1 + cklu*lu + cklv*lv1)
	
	su kelas1, meanonly
	local meank1 = r(mean)
	su kelas0, meanonly
	local meank0 = r(mean)
	
	ttest kelas1==kelas0
	
	
	*---------------
	* Materials
	local poly  k l m u v kk ll mm kl km ku kv lm lu lv mu mv klm klu klv kmu kmv  lmu lmv klmu klmv
	local poly1 k l m u v1 kk ll mm kl km ku kv1 lm lu lv1 mu mv1 klm klu klv1 kmu kmv1 lmu lmv1 klmu klmv1
	local poly0 k l m u v0 kk ll mm kl km ku kv0 lm lu lv0 mu mv0 klm klu klv0 kmu kmv0 lmu lmv0 klmu klmv0
	local npoly: word count `poly'
	
	gen melas0 = g0
	forval i=1/`npoly' {
		local thiscoef	`: word `i' of `poly''
		local thisvar	`: word `i' of `poly0''
		replace melas0 = melas0 + g`thiscoef'*`thisvar'
	}
	
	gen melas1 = g0
	forval i=1/`npoly' {
		local thiscoef	`: word `i' of `poly''
		local thisvar	`: word `i' of `poly1''
		replace melas1 = melas1 + g`thiscoef'*`thisvar'
	}
	
	ttest melas1==melas0

	
	* Revenue return to scale
	gen rts1 = lelas1 + kelas1 + melas1
	gen rts0 = lelas0 + kelas0 + melas0
	
	* Markup
	gen markup1 = 1/rts1
	gen markup0 = 1/rts0
	
*------------------------------------
*** ttest & ksmirnov test results ***
*------------------------------------
	preserve
* Drop outlier elasticities before testing
	foreach var of varlist lelas1 lelas0 kelas1 kelas0 melas1 melas0{
		summarize `var', detail
		keep if inrange(`var', r(p1), r(p99))
	}
	
	gen lm1 = lelas1/melas1	
	gen lm0 = lelas0/melas0
	
	gen km1 = kelas1/melas1
	gen km0 = kelas0/melas0
	
	su rts1, d
	su rts0, d
	su markup1, d
	su markup0, d
	
	*----------
	* Paired t-test
	cap erase ttest.doc
	asdoc ttest lelas1==lelas0, save(ttest.doc)
	asdoc ttest kelas1==kelas0, append save(ttest.doc)
	asdoc ttest melas1==melas0, append save(ttest.doc)
	asdoc ttest rts1==rts0, append save(ttest.doc)
	asdoc ttest markup1==markup0, append save(ttest.doc)	
	
	cap erase ttest2.doc
	asdoc ttest lm1==lm0, save(ttest2.doc)
	asdoc ttest km1==km0, append save(ttest2.doc)	
	
	*----------
	* KS test
	ksmirnov lelas1=lelas0
	ksmirnov kelas1=kelas0
	ksmirnov melas1=melas0
	
	ksmirnov lm1=lm0
	ksmirnov km1=km0
	
