
global path "."					/*path on your computer*/
cd "$path"

grstyle clear
set scheme s2mono
grstyle init
grstyle set plain, horizontal noextend grid
	
*------------------------------------------------------------------------------
*** Graph employment share of foreign-owned firms by industry
* "High-tech" includes: 35 (general-purpose machinery), 36 (special-purpose machinery),
* 37 (transport equipment), 39 (electrical machinery), 40 (electronics), 41 (precision instruments)
	global Tech = "(cic_2_digit==35 | cic_2_digit==36" ///  
			+"| cic_2_digit==37 | cic_2_digit==39 | cic_2_digit==40" ///
			+"| cic_2_digit==41)"

* HKMT versus OECD
use "$path\_datasets\TFP_china.dta", clear
	keep if $Tech
	by year, sort: egen L_t = total(L)
	by year Ownership, sort: egen L_to = total(L)
	gen EmpShare_to = L_to/L_t
	replace EmpShare_to = EmpShare_to*100
	tab year Ownership, summarize(EmpShare_to) means
	collapse (mean) EmpShare_to, by(year Ownership)
	xtset Ownership year
	xtline EmpShare_to if Ownership>=4, overlay ytitle(Employment Share) tline(2002) ylabel(, angle(horizontal)) ///
			legend(order(1 "HKMT" 2 "OECD"))
graph export "$path\output\graph\ForeignInvestment0_Tech.png", replace
	
	drop if Ownership <4
	reshape wide EmpShare_to, i(year) j(Ownership)
	graph bar (asis) EmpShare_to4 EmpShare_to5  , over(year) bargap(10) ytitle(Employment share (%)) ///
	ylabel(, angle(horizontal)) legend(order(1 "HKMT" 2 "OECD")) //
graph export "$path\output\graph\ForeignInvestment1_Tech.png", replace
