//////////////////////////////////////////////////////////
// Part A : creating the sample and relevant variables//
////////////////////////////////////////////////////////

keep if mom_age>=18+match_duration
generate girl=1 if sex==1
replace girl=0 if girl==.
drop if mom_age==999
drop if dad_age==999
drop if mom_edu==.
drop if dad_edu==.
drop if birthweight==0
drop if birthweight==.
generate birthweightgrams=birthweight*1000

**generating the indicator for low birthweight
generate lowbirthweight=1 if birthweightgrams<=2500
replace lowbirthweight=0 if lowbirthweight==.
**or the below if you use the other dataset to study selection which has unemployment rates the *year before conception
drop if birthweight==.
drop if sex==.
drop if mom_edu==.
drop if dad_edu==.
drop if mom_totalbirth==.
drop if mom_totalbirth==99
drop if location==.
drop if match_duration==.
drop if status==9
generate momcollegeplus=1 if mom_edu==4
replace momcollegeplus=0 if momcollegeplus==.
*Dad collegeplus
generate dadcollegeplus=1 if dad_edu==4
replace dadcollegeplus=0 if dadcollegeplus==.
*age
generate mom35over=1 if mom_age>=35
replace mom35over=0 if mom35over==.
generate dad35over=1 if dad_age>=35
replace dad35over=0 if dad35over==.

**dropping location_original26
drop if  location_original==26
generate devunemp19mbbr=devunemp19mbb*100
generate avunemp19mbbr=avunemp19mbb*100
drop devunemp19mbb avunemp19mbb
rename devunemp19mbbr devunemp19mbb
rename avunemp19mbbr avunemp19mbb

**generating location dummies
quietly tab location_original,gen(locationoriginaldum)

///////////////////////////
// Part B : Regressions   //
///////////////////////////

** These regressions generate Panel A, Panel B and Panel C of Table 3. The program below need to 
** be used after running the program called "generating the dummy variable"

**regressions 
drop if birth_year==1997
drop if birth_year>1998
drop if birth_month>=9

generate jan=1 if birth_month==1
replace jan=0 if jan==.

generate feb=1 if birth_month==2
replace feb=0 if feb==.

generate mar=1 if birth_month==3
replace mar=0 if mar==.

generate april=1 if birth_month==4
replace april=0 if april==.

generate may=1 if birth_month==5
replace may=0 if may==.

generate june=1 if birth_month==6
replace june=0 if june==.

generate july=1 if birth_month==7
replace july=0 if july==.

generate august=1 if birth_month==8
replace august=0 if august==.
**sex ratio all
xi: reg girl  jan feb mar april may june july august  avunemp19mbb devunemp19mbb  i.location_original , noconstant cluster(location_original)

**now by Parity
*PARITY  1
xi: reg girl  jan feb mar april may june july august  avunemp19mbb devunemp19mbb  i.location_original if no_siblingsalive==1, noconstant cluster(location_original)

**PARITY 2
**sex ratio
xi: reg girl  i.birth_year  jan feb mar april may june july august     avunemp19mbb devunemp19mbb  i.location_original if no_siblingsalive==2, noconstant cluster(location_original)

**parity 3 or higher
**sex ratio
xi: reg girl    jan feb mar april may june july august    avunemp19mbb devunemp19mbb  i.location_original if no_siblingsalive>=3, noconstant cluster(location_original)


**98 9 months 2 periods
generate pe1=1 if birth_month<5
replace pe1=0 if pe1==.
generate pe2=1 if birth_month>=5
replace pe2=0 if pe2==.
generate devp1= devunemp19mbb*pe1
generate devp2= devunemp19mbb*pe2
**All parities
**sex ratio
xi: reg girl    jan feb mar april may june july august     avunemp19mbb devp1 devp2   i.location_original , noconstant cluster(location_original)


**parity 1
**sex ratio
xi: reg girl    jan feb mar april may june july august     avunemp19mbb devp1 devp2   i.location_original if no_siblingsalive==1, noconstant cluster(location_original)
**PARITY 2
**sex ratio
xi: reg girl  i.birth_year  jan feb mar april may june july august     avunemp19mbb devp1 devp2   i.location_original if no_siblingsalive==2, noconstant  cluster(location_original)


**parity 3 or higher
**sex ratio
xi: reg girl    jan feb mar april may june july august    avunemp19mbb devp1 devp2   i.location_original if no_siblingsalive>=3, noconstant cluster(location_original)

**mom college or more
**all parities 
xi: reg girl    jan feb mar april may june july august     avunemp19mbb devp1 devp2   i.location_original if momcollegeplus==1, noconstant cluster(location_original)

**PARITY 1
xi: reg girl    jan feb mar april may june july august     avunemp19mbb devp1 devp2   i.location_original if no_siblingsalive==1 & momcollegeplus==1, noconstant cluster(location_original)
**PARITY 2
**sex ratio
xi: reg girl  i.birth_year  jan feb mar april may june july august     avunemp19mbb devp1 devp2   i.location_original if no_siblingsalive==2 & momcollegeplus==1, noconstant cluster(location_original)


**parity 3 or higher
**sex ratio
xi: reg girl    jan feb mar april may june july august    avunemp19mbb devp1 devp2   i.location_original if no_siblingsalive>=3 & momcollegeplus==1, noconstant cluster(location_original)


**MOM High School 
**all parities 
xi: reg girl    jan feb mar april may june july august     avunemp19mbb devp1 devp2   i.location_original if mom_edu==3, noconstant cluster(location_original)

**PARITY 1
xi: reg girl    jan feb mar april may june july august     avunemp19mbb devp1 devp2   i.location_original if no_siblingsalive==1 & mom_edu==3, noconstant cluster(location_original)
**PARITY 2
**sex ratio
xi: reg girl  i.birth_year  jan feb mar april may june july august     avunemp19mbb devp1 devp2   i.location_original if no_siblingsalive==2 & mom_edu==3, noconstant cluster(location_original)


**parity 3 or higher
**sex ratio
xi: reg girl    jan feb mar april may june july august    avunemp19mbb devp1 devp2   i.location_original if no_siblingsalive>=3 & mom_edu==3, noconstant cluster(location_original)

**Mom less than high school
**all parities 
xi: reg girl    jan feb mar april may june july august     avunemp19mbb devp1 devp2   i.location_original if mom_edu<3, noconstant cluster(location_original)

**PARITY 1
xi: reg girl    jan feb mar april may june july august     avunemp19mbb devp1 devp2   i.location_original if no_siblingsalive==1 & mom_edu<3, noconstant cluster(location_original)
**PARITY 2
**sex ratio
xi: reg girl  i.birth_year  jan feb mar april may june july august     avunemp19mbb devp1 devp2   i.location_original if no_siblingsalive==2 & mom_edu<3, noconstant cluster(location_original)


**parity 3 or higher
**sex ratio
xi: reg girl    jan feb mar april may june july august    avunemp19mbb devp1 devp2   i.location_original if no_siblingsalive>=3 & mom_edu<3, noconstant cluster(location_original)


** Regressions that give results in Panel B and C of Table 4
** NB the program below needs to be run after the "generating the dummy variable" program

**LOW BW
drop if birth_year==1997
drop if birth_year>1998
drop if birth_month>=9
generate jan=1 if birth_month==1
replace jan=0 if jan==.

generate feb=1 if birth_month==2
replace feb=0 if feb==.

generate mar=1 if birth_month==3
replace mar=0 if mar==.

generate april=1 if birth_month==4
replace april=0 if april==.

generate may=1 if birth_month==5
replace may=0 if may==.

generate june=1 if birth_month==6
replace june=0 if june==.

generate july=1 if birth_month==7
replace july=0 if july==.

generate august=1 if birth_month==8
replace august=0 if august==.
generate febint=feb*girl
generate marint=mar*girl
generate aprilint=april*girl
generate mayint=may*girl
generate juneint=june*girl
generate julyint=july*girl
generate augustint=august*girl

**outcomes surprised group first no het by ed
generate  avunempint= avunemp19mbb*girl
generate devunempint= devunemp19mbb*girl
generate mom35overint=mom35over*girl
generate dad35overint=dad35over*girl
generate momcollegeplusint=momcollegeplus*girl
generate dadcollegeplusint=dadcollegeplus*girl
**
**EVERYONE
**bw
xi: reg lowbirthweight    jan feb mar april may june july august  febint marint aprilint mayint juneint julyint augustint  avunemp19mbb devunemp19mbb  avunempint devunempint  i.location_original*girl  , noconstant cluster(location_original)

*Parity 1
**bw
xi: reg lowbirthweight    jan feb mar april may june july august  febint marint aprilint mayint juneint julyint augustint   avunemp19mbb devunemp19mbb  avunempint devunempint  i.location_original*girl  if no_siblingsalive==1, noconstant  cluster(location_original)

**PARITY 2

xi: reg lowbirthweight   jan feb mar april may june july august  febint marint aprilint mayint juneint julyint augustint   avunemp19mbb devunemp19mbb   avunempint devunempint i.location_original*girl  if no_siblingsalive==2, noconstant  cluster(location_original)

**parity 3 or higher

xi: reg lowbirthweight    jan feb mar april may june july august  febint marint aprilint mayint juneint julyint augustint  avunemp19mbb devunemp19mbb  avunempint devunempint  i.location_original*girl  if no_siblingsalive>=3, noconstant  cluster(location_original)

**Average BW
**ALL
xi: reg birthweightgrams    jan feb mar april may june july august  febint marint aprilint mayint juneint julyint augustint   avunemp19mbb devunemp19mbb  avunempint devunempint  i.location_original*girl  , noconstant  cluster(location_original)

**Parity 1
xi: reg birthweightgrams    jan feb mar april may june july august  febint marint aprilint mayint juneint julyint augustint  avunemp19mbb devunemp19mbb  avunempint devunempint  i.location_original*girl  if no_siblingsalive==1, noconstant  cluster(location_original)

**PARITY 2
xi: reg birthweightgrams   jan feb mar april may june july august  febint marint aprilint mayint juneint julyint augustint   avunemp19mbb devunemp19mbb   avunempint devunempint i.location_original*girl  if no_siblingsalive==2, noconstant  cluster(location_original)

**parity 3 or higher
xi: reg birthweightgrams    jan feb mar april may june july august  febint marint aprilint mayint juneint julyint augustint  avunemp19mbb devunemp19mbb  avunempint devunempint  i.location_original*girl  if no_siblingsalive>=3, noconstant  cluster(location_original)

