get.psi.dr <- function(Y, D, X, stype){
	
	n <- nrow(Y)
	k <- ncol(X)

	if (stype == 1 | stype ==2){
	pi_hat<-fitted(glm(D~X, family=binomial("logit")))
	}
	if (stype == 3 | stype ==4){
	pi_hat<-fitted(glm(D~X[,1:(k/2)], family=binomial("logit")))
	}
	Ytreated <- Y[D==1]
	Xtreated <- X[D==1,]
	Yuntreated <- Y[D==0]
	Xuntreated <- X[D==0,]


	if (stype == 1 | stype ==3){
		miu1_hat<-cbind(1,X)%*%as.matrix(lm(Ytreated~Xtreated)$coef)
		miu0_hat<-cbind(1,X)%*%as.matrix(lm(Yuntreated~Xuntreated)$coef)
}
	if (stype == 2 | stype ==4){
		miu1_hat<-cbind(1,X[,1:(k/2)])%*%as.matrix(lm(Ytreated~Xtreated[,1:(k/2)])$coef)
		miu0_hat<-cbind(1,X[,1:(k/2)])%*%as.matrix(lm(Yuntreated~Xuntreated[,1:(k/2)])$coef)
}

	
	psi1<-D*Y/pi_hat-(D-pi_hat)*miu1_hat/pi_hat
	psi0<-(1-D)*Y/(1-pi_hat)+(D-pi_hat)*miu0_hat/(1-pi_hat)

	psi1-psi0

	
}

get.psi.ra <- function(Y, D, X){

	Ytreated<-Y[D==1]
	Xtreated<-X[D==1,]
	Yuntreated<-Y[D==0]
	Xuntreated<-X[D==0,]

	miu1_hat<-cbind(1,X)%*%as.matrix(lm(Ytreated~Xtreated)$coef)
	miu0_hat<-cbind(1,X)%*%as.matrix(lm(Yuntreated~Xuntreated)$coef)

	miu1_hat - miu0_hat
	
}

get.psi.ipw <- function(Y, D, X){
	
	pi_hat<-fitted(glm(D~X, family=binomial("logit")))

	psi1 <- D*Y/pi_hat
	psi0 <- (1-D)*Y/(1-pi_hat)
	psi1-psi0

}