rm(list=ls(all=T))
gc()
gc()

library("locpol")    #locPolSmootherC() 
library("KernSmooth") #dpill(),

options(width =160)
setwd("/Users/okuiryo/project/drcate/replication_files")

sink(file="results.txt", split =T)

source("gdp.R")
source("getpsi.R")
source("critical_value.R")


robustdpill <- function(x, y) { 
	tryCatch(dpill(x,y), 
		warning = function(w) {NaN},
			error = function(e){NaN})
			}


R<-5000
N<-c(500,2000)

vK <- c(10,30)

  ### Gaussian Kernel
  ker<-gaussK
  rk<-computeRK(ker)
  lambda<- 1- (1/(4*sqrt(pi)))/rk
  

for(k in vK){
  
for(n in N){

for(stype in c(1,2,3,4)){
# stype 
# 1 both correct
# 2 regressin incorrect
# 3 propensity incorrect
# 4 both incorrect

if (stype ==1){
	print("True Propensity Score Model, True Regression Model")
} else if (stype ==2){
	print("True Propensity Score Model, False Regression Model")
} else if (stype == 3){
	print("False Propensity Score Model, True Regression Model")
} else if (stype == 4){
	print("False Propensity Score Model, False Regression Model")
}


  xx1 <- c(-1,-0.5,0,0.5,1)
  CATE<- xx1/sqrt(k) + 10
  b <- 1
  a <- -1
  xtest<-seq(a,b, by=0.01)
  nbin <- length(xtest)
  g<- xtest/sqrt(k) + 10 

  alpha<-c(0.01,0.05,0.1)
  bandorder <- n^(-2/7)
  	
  sigmasq_hat_I<-matrix(0,ncol=nbin,nrow=R)
  s_hat_I<-matrix(0,ncol=nbin,nrow=R)
  sg_hat_I<-matrix(0,ncol=nbin,nrow=R)
  ghat_dr<-matrix(0,ncol=nbin,nrow=R)
	ghat_ipw <-matrix(0,ncol=nbin,nrow=R)
	ghat_ra <-matrix(0,ncol=nbin,nrow=R)
  MM_I<-matrix(0,ncol=nbin,nrow=R)
  MMGumbel_I<-matrix(0,ncol=nbin,nrow=R)
  critical<-matrix(0,ncol=3,nrow=R)
  criticalGumbel<-matrix(0,ncol=3,nrow=R)
  PP<-matrix(0,ncol=3,nrow=R)
  PPGumbel<-matrix(0,ncol=3,nrow=R)
  
  for(r in 1:R)
  {  
  
	m.data <- get.data(n,k) 
	Y <- m.data[,1]   
	D <- m.data[,2]   
	X <- m.data[,3:(k+2)]  
	x1 <- m.data[,3] 

  Ytreated<-Y[D==1]
  Xtreated<-X[D==1,]
  Yuntreated<-Y[D==0]
  Xuntreated<-X[D==0,]
  
  s_X<-sd(x1)
 
  ######
	## IPW estimate
	#####
	if (stype == 1 | stype ==2){
psi_ipw <- get.psi.ipw(Y,D,X)
}
	if (stype == 3 | stype ==4){
psi_ipw <- get.psi.ipw(Y,D,X[,1:(k/2)])
}


###  Ruppert,Sheather and Wand (1995)
  h_ipw <-robustdpill(x=x1, y=psi_ipw)*n^(1/5)*bandorder
  if (h_ipw == "NaN") {h_ipw <- 0.01}
  ghat_ipw[r,]<-locPolSmootherC(x=x1,y=psi_ipw,xeval=seq(a, b, by=0.01),bw=h_ipw,deg=1,kernel=ker)$beta0


  ######
	## RA estimate
	#####

	if (stype == 1 | stype ==3){
psi_ra <- get.psi.ra(Y,D,X)
}
	if (stype == 2 | stype ==4){
psi_ra <- get.psi.ra(Y,D,as.matrix(X[,1:(k/2)]))
}

###  Ruppert,Sheather and Wand (1995)
  h_ra <-robustdpill(x=x1, y=psi_ra)*n^(1/5)*bandorder
  if (h_ra == "NaN") {h_ra <- 0.01}
  ghat_ra[r,]<-locPolSmootherC(x=x1,y=psi_ra,xeval=seq(a,b,by=0.01),bw=h_ra,deg=1,kernel=ker)$beta0



  #######
	## DR estimate
	######
 psi_dr <- get.psi.dr(Y,D,X, stype)

  ###  Ruppert,Sheather and Wand (1995)
  h_dr <-robustdpill(x=x1, y=psi_dr)*n^(1/5)*bandorder
  if (h_dr == "NaN") {h_dr <- 0.01}

  ghat_dr[r,]<-locPolSmootherC(x=x1,y=psi_dr,xeval=seq(a,b,by=0.01),bw=h_dr,deg=1,kernel=ker)$beta0
  
  # standard error
  fX_hat_I<-numeric(nbin)
  for(i in 1:nbin)
  {fX_hat_I[i]<-mean(ker((x1-xtest[i])/h_dr))/h_dr
   
   sigmasq_hat_I[r,i]<-mean((psi_dr-ghat_dr[r,i])^2*ker((x1-xtest[i])/h_dr))/fX_hat_I[i]/h_dr
   sigmasq_hat_I[r,i]<- sigmasq_hat_I[r,i] *n / (n-3*k-3) 
   
   s_hat_I[r,i]<-sqrt(rk*sigmasq_hat_I[r,i]/fX_hat_I[i])
  }
  

  for(i in 1:3)
  {
    
   critical[r,i]<- crit.unif(a,b,h_dr, lambda, alpha[i])
   criticalGumbel[r,i]<- crit.Gumbel(a,b,h_dr, lambda, alpha[i])

    sg_hat_I[r,]<-s_hat_I[r,]/sqrt(n*h_dr)
    MM_I[r,]<-(g>=(ghat_dr[r,]-critical[r,i]*sg_hat_I[r,]))&(g<=(ghat_dr[r,]+critical[r,i]*sg_hat_I[r,]))
    PP[r,i]<-ifelse(sum(MM_I[r,])==nbin,1,0)
   
   MMGumbel_I[r,]<-(g>=(ghat_dr[r,]-criticalGumbel[r,i]*sg_hat_I[r,]))&(g<=(ghat_dr[r,]+criticalGumbel[r,i]*sg_hat_I[r,]))
   PPGumbel[r,i]<-ifelse(sum(MMGumbel_I[r,])==nbin,1,0)
  }
  
  }
  
  ###################################
  cat("k=",k,"\n")
  cat("Sample Size: n=",n,"\n")
      
    T_dr<-(ghat_dr[,c(1,(0.25*(nbin-1)+1),(0.5*(nbin-1)+1),(0.75*(nbin-1)+1),nbin)]-matrix(CATE,R,5,byrow=T))
    T_ipw <- (ghat_ipw[,c(1,(0.25*(nbin-1)+1),(0.5*(nbin-1)+1),(0.75*(nbin-1)+1),nbin)]-matrix(CATE,R,5,byrow=T))
    T_ra <- (ghat_ra[,c(1,(0.25*(nbin-1)+1),(0.5*(nbin-1)+1),(0.75*(nbin-1)+1),nbin)]-matrix(CATE,R,5,byrow=T))
	sg_hat<-sg_hat_I[,c(1,(0.25*(nbin-1)+1),(0.5*(nbin-1)+1),(0.75*(nbin-1)+1),nbin)]

    Bias<-apply(T_dr,2,mean) 
      
    se<-apply(T_dr,2,sd)   
    Ese<-apply(sg_hat,2,mean)  
    
    RMse<-sqrt(apply(T_dr^2,2,mean) )

    
    Biasipw<-apply(T_ipw,2,mean) 
    seipw<-apply(T_ipw,2,sd)   
    RMseipw<-sqrt(apply(T_ipw^2,2,mean))

    Biasra<-apply(T_ra,2,mean) 
    sera<-apply(T_ra,2,sd)   
    RMsera<-sqrt(apply(T_ra^2,2,mean) )


      MeanPP<-apply(PP,2,mean)
      MeanPPGumbel<-apply(PPGumbel,2,mean)
      Meancrit<-apply(critical,2,mean)
      Sdcrit<-apply(critical,2,sd)
    
    BIAS<-sprintf("%.3f",Bias)
    SD<-sprintf("%.3f",se)
    ASE<-sprintf("%.3f",Ese)
    RMSE<-sprintf("%.3f",RMse)

    BIASipw<-sprintf("%.3f",Biasipw)
    SDipw<-sprintf("%.3f",seipw)
    RMSEipw<-sprintf("%.3f",RMseipw)

    BIASra<-sprintf("%.3f",Biasra)
    SDra<-sprintf("%.3f",sera)
    RMSEra<-sprintf("%.3f",RMsera)

    col2<-cbind(BIAS,SD,ASE,RMSE, BIASipw,SDipw, RMSEipw, BIASra,SDra,RMSEra)

    MPP<-sprintf("%.3f",MeanPP)
    Mcri<-sprintf("%.3f",Meancrit)
    Sdcri<-sprintf("%.3f",Sdcrit)
    MPPGumbel<-sprintf("%.3f",MeanPPGumbel)
    col4<-rbind(cbind(MPP,Mcri,Sdcri,MPPGumbel))
    
    col1<-rbind(-1,-0.5,0,0.5,1)
    col3<-rbind("99%","95%","90%")
    
	if (exists("result_est")) {
		result_est <- rbind(result_est, cbind(col1,col2))
		} else {
			result_est <- cbind(col1,col2) 
			}
			
	if (exists("result_ci")) {
		result_ci <- rbind(result_ci, cbind(col3,col4))
		} else {
			result_ci <- cbind(col3, col4) 
			}

	    print(cbind(col1,col2),quote=F)
    print(cbind(col3,col4),quote=F)
    
  
}

write.csv(result_est, file="result_est.csv", quote = FALSE, row.names = FALSE, append = TRUE)
write.csv(result_ci, file="result_ci.csv", quote = FALSE, row.names = FALSE, append = TRUE)

}

}

sink()