function sim=TransitionMatrix9h(ut0)

load DataH_GMMmainBS
load DataH_BS;
load DataH_varerror_BS

gamma=estimates_survey(1)

for i=1:ng
 d_tau_2002(i,1:2)=[NaN SS{i}(1,2)];
 if ut0{i}(1,2)==2002;    
 d_tau_2002(i,1:2)=[ut0{i}(1,3) SS{i}(1,2)];
 end
end

% Data for initial values by projection
% PROJECTION

% DATA generating year by year
DATA2000 = SI(:,1:11);
DATA2001 = SI(:,12:22);
% DATA generating X, Y
DATA2000_Y=DATA2000(:,3);
DATA2001_Y=DATA2001(:,3);

% FIRST INITIAL CONDITION
% DATA
D_DATA2001_Y=DATA2001_Y-DATA2000_Y;
XX1=[DATA2001(:,2), D_DATA2001_Y, DATA2001(:,3:11), DATA2000(:,3:11)];
X1=XX1;
res0forres1=X1(:,1); % to match res0 and res1 later /hhid

Y1=X1(:,2);
X1(:,1:3)=[];
X1(:,9)=X1(:,8).*X1(:,8); %drop y_2000 and generate age^2
X1(:,18)=X1(:,17).*X1(:,17); %generate age^2

N1=length(X1);
X1(:,19)=ones(N1,1);
K1=size(X1,2);

XXX1=X1;
YYY1=Y1;

CXY1=[Y1 X1];

Y1(any(isnan(CXY1),2),:) = [];
%res0forres1(any(isnan(CXY1),2),:) = [];
X1(any(isnan(CXY1),2),:) = [];
N1=length(X1);   


% OLS regression
beta1=inv(X1'*X1)*X1'*Y1;
res0=Y1-X1*beta1;
std1=diag(((res0'*res0)./(N1-K1))*inv(X1'*X1));

v_psi0=var(res0);
v_zeta0=var(res0)-2*var_me2;

res00=YYY1-XXX1*beta1;


% SECOND INITIAL CONDITION
XX2=[DATA2001(:,2), DATA2001_Y, DATA2001(:,3:11), DATA2000(:,3:11)];
X2=XX2;
Y2=X2(:,3);
res1forres0=X2(:,1); % to match res0 and res1 later /hhid
X2(:,1:3)=[];

X2(:,9)=X2(:,8).*X2(:,8); %drop y_2000 and generate age^2
X2(:,18)=X2(:,17).*X2(:,17); %generate age^2
N2=length(X2);
X2(:,19)=ones(N2,1);
K2=size(X2,2);

YYY2=Y2;
XXX2=X2;

CXY2=[Y2 X2];
Y2(any(isnan(CXY2),2),:) = [];
%res1forres0(any(isnan(CXY2),2),:) = [];
X2(any(isnan(CXY2),2),:) = [];
N2=length(X2);

% OLS regression
beta2=inv(X2'*X2)*X2'*Y2;
res1=Y2-X2*beta2;
std2=diag(((res1'*res1)./(N2-K2))*inv(X2'*X2));

v_psi1=var(res1);
ubound=v_psi1-var_me2;

res11=YYY2-XXX2*beta2;

ERT012=[res00 res0forres1 res11 res1forres0 d_tau_2002]; 
tau_2_1=[res00 d_tau_2002(:,1)];
tau_2_1(any(isnan(tau_2_1),2),:)=[];
cov0=cov(tau_2_1);
E_zeta0_derr =(1+2*gamma)*var_me2+cov0(1,2);

tau_2_1=[res11 d_tau_2002(:,1)];
tau_2_1(any(isnan(tau_2_1),2),:)=[];
cov1=cov(tau_2_1);
E_zeta1_derr =(1+gamma)*var_me2+cov1(1,2);

res=[res00 res11];
res(any(isnan(res),2),:)=[];
C_res=cov(res);
C_zeta0_zeta1=C_res(1,2)-var_me2;

 
% CHECK POSITIVE SEMIDEFINITE
COVMU=[v_zeta0       C_zeta0_zeta1   E_zeta0_derr       0                 0                0                0                 0;
       C_zeta0_zeta1 ubound          E_zeta1_derr       0                 0                0                0                 0;
       E_zeta0_derr  E_zeta1_derr    var_u+2*var_equ    (-1)*var_equ      0                0                0                 0;
       0             0               (-1)*var_equ       var_u+2*var_equ  (-1)*var_equ      0                0                 0;  
       0             0               0                  (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ      0                 0;
       0             0               0                  0                (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ       0;
       0             0               0                  0                 0               (-1)*var_equ      var_u+2*var_equ   (-1)*var_equ;
       0             0               0                  0                 0                0               (-1)*var_equ       var_u+2*var_equ];
du = eig(COVMU) 
 
 
% Positive semidefinite
for x1= 0.0100:0.0001:ubound
 
COVML=[v_zeta0       C_zeta0_zeta1   E_zeta0_derr       0                 0                0                0                 0;
       C_zeta0_zeta1 x1              E_zeta1_derr       0                 0                0                0                 0;
       E_zeta0_derr  E_zeta1_derr    var_u+2*var_equ    (-1)*var_equ      0                0                0                 0;
       0             0               (-1)*var_equ       var_u+2*var_equ  (-1)*var_equ      0                0                 0;  
       0             0               0                  (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ      0                 0;
       0             0               0                  0                (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ       0;
       0             0               0                  0                 0               (-1)*var_equ      var_u+2*var_equ   (-1)*var_equ;
       0             0               0                  0                 0                0               (-1)*var_equ       var_u+2*var_equ];
 
dl = eig(COVML); 
 
if min(dl)>0
    break
end
   
end
 
x1
[V, D]= eig(COVML) 
 
% check whether the 7*7 positive definite matrix
COVML77=[v_zeta0         E_zeta0_derr       0                 0                0                0                 0;
         E_zeta0_derr    var_u+2*var_equ    (-1)*var_equ      0                0                0                 0;
         0               (-1)*var_equ       var_u+2*var_equ  (-1)*var_equ      0                0                 0;  
         0               0                  (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ      0                 0;
         0               0                  0                (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ       0;
         0               0                  0                 0               (-1)*var_equ      var_u+2*var_equ   (-1)*var_equ;
         0               0                  0                 0                0               (-1)*var_equ       var_u+2*var_equ];
dl77 = eig(COVML77)
 
% SIMULATE ERRORS FROM NORMAL DISTRIBUTION
mu=[0 0 0 0 0 0 0 0 ];
mu77=[0 0 0 0 0 0 0 ];
error_u = mvnrnd(mu,COVMU,ng);
error_l = mvnrnd(mu,COVML,ng);
error_l77 = mvnrnd(mu77,COVML77,ng);
 
zeta1=NaN(ng,1);
zeta1=(1/(V(2,1))) * (-1) *(V(1,1)*error_l77(:,1)+V(3,1)*error_l77(:,2)+V(4,1)*error_l77(:,3)+V(5,1)*error_l77(:,4)+V(6,1)*error_l77(:,5)+V(7,1)*error_l77(:,6)+V(8,1)*error_l77(:,7));
error_l=[error_l77(:,1) zeta1 error_l77(:,2:7)];
 
% SIMULATE CONSUMPTION for UPPER BOUND 
u_sim_d_ln_at_cons_2001_2000=XXX1*beta1+error_u(:,1);
u_sim_ln_at_cons_2001=XXX2*beta2+error_u(:,2);
u_sim_ln_at_cons_2002=u_sim_ln_at_cons_2001+[u_sim_d_ln_at_cons_2001_2000 (DATA2002_X(:,2:7)-DATA2001_X(:,2:7))]*estimates_survey+error_u(:,3);
u_sim_ln_at_cons_2003=u_sim_ln_at_cons_2002+[(u_sim_ln_at_cons_2002-u_sim_ln_at_cons_2001) (DATA2003_X(:,2:7)-DATA2002_X(:,2:7))]*estimates_survey+error_u(:,4);
u_sim_ln_at_cons_2004=u_sim_ln_at_cons_2003+[(u_sim_ln_at_cons_2003-u_sim_ln_at_cons_2002) (DATA2004_X(:,2:7)-DATA2003_X(:,2:7))]*estimates_survey+error_u(:,5);
u_sim_ln_at_cons_2005=u_sim_ln_at_cons_2004+[(u_sim_ln_at_cons_2004-u_sim_ln_at_cons_2003) (DATA2005_X(:,2:7)-DATA2004_X(:,2:7))]*estimates_survey+error_u(:,6);
u_sim_ln_at_cons_2006=u_sim_ln_at_cons_2005+[(u_sim_ln_at_cons_2005-u_sim_ln_at_cons_2004) (DATA2006_X(:,2:7)-DATA2005_X(:,2:7))]*estimates_survey+error_u(:,7);
u_sim_ln_at_cons_2007=u_sim_ln_at_cons_2006+[(u_sim_ln_at_cons_2006-u_sim_ln_at_cons_2005) (DATA2007_X(:,2:7)-DATA2006_X(:,2:7))]*estimates_survey+error_u(:,8);
    
% SIMULATE CONSUMPTION for CONSTRAINED LOWER BOUND
l_sim_d_ln_at_cons_2001_2000=XXX1*beta1+error_l(:,1);
l_sim_ln_at_cons_2001=XXX2*beta2+error_l(:,2);
l_sim_ln_at_cons_2002=l_sim_ln_at_cons_2001+[l_sim_d_ln_at_cons_2001_2000 (DATA2002_X(:,2:7)-DATA2001_X(:,2:7))]*estimates_survey+error_l(:,3);
l_sim_ln_at_cons_2003=l_sim_ln_at_cons_2002+[(l_sim_ln_at_cons_2002-l_sim_ln_at_cons_2001) (DATA2003_X(:,2:7)-DATA2002_X(:,2:7))]*estimates_survey+error_l(:,4);
l_sim_ln_at_cons_2004=l_sim_ln_at_cons_2003+[(l_sim_ln_at_cons_2003-l_sim_ln_at_cons_2002) (DATA2004_X(:,2:7)-DATA2003_X(:,2:7))]*estimates_survey+error_l(:,5);
l_sim_ln_at_cons_2005=l_sim_ln_at_cons_2004+[(l_sim_ln_at_cons_2004-l_sim_ln_at_cons_2003) (DATA2005_X(:,2:7)-DATA2004_X(:,2:7))]*estimates_survey+error_l(:,6);
l_sim_ln_at_cons_2006=l_sim_ln_at_cons_2005+[(l_sim_ln_at_cons_2005-l_sim_ln_at_cons_2004) (DATA2006_X(:,2:7)-DATA2005_X(:,2:7))]*estimates_survey+error_l(:,7);
l_sim_ln_at_cons_2007=l_sim_ln_at_cons_2006+[(l_sim_ln_at_cons_2006-l_sim_ln_at_cons_2005) (DATA2007_X(:,2:7)-DATA2006_X(:,2:7))]*estimates_survey+error_l(:,8);

U_SIM=[u_sim_ln_at_cons_2002 u_sim_ln_at_cons_2003 u_sim_ln_at_cons_2004 u_sim_ln_at_cons_2005 u_sim_ln_at_cons_2006 u_sim_ln_at_cons_2007];
L_SIM=[l_sim_ln_at_cons_2002 l_sim_ln_at_cons_2003 l_sim_ln_at_cons_2004 l_sim_ln_at_cons_2005 l_sim_ln_at_cons_2006 l_sim_ln_at_cons_2007];
 
sim=[d_tau_2002(:,2) ones(ng,1) DATA2002_Y DATA2003_Y DATA2004_Y DATA2005_Y DATA2006_Y DATA2007_Y U_SIM L_SIM];

save('SIM_HDATABS.mat');
 
return
 


