% Bootstrapping Std for Homoskedasticity Examination Results

clear
clc

format short;

display('Bootstrapping Standard Error for Homoskedasticity Examination Results')

randn('state',sum(100*clock));
rand('state',sum(100*clock));  %initialize random number generator

load DataH_ReadyPTM; 
clearvars -except ng

B=1000; % # of repetitions
    
%s = RandStream('mt19937ar','Seed',0);
%RandStream.setGlobalStream(s)

R=rand(2*B,ng);

rep=0;psd=0;count=0;
while rep<B;
    rep=rep+1;
    count=count+1;
    
    load DataH_ReadyPTM;   
    rep
    
    W0=W;
    SS0=SS;
    SI0=SI;
    k1=zeros(ng,1);
    
    for i=1:ng
        j=round(R(rep+psd,i)*(ng-1))+1;
        W{i}=W0{j};
        SS{i}=SS0{j};
        SI(i,:)=SI0(j,:);
        k1(i)=j;

    
    
    DATA2001_X(i,:)=W{i}(3,3:9);
    DATA2002_X(i,:)=W{i}(4,3:9);
    DATA2003_X(i,:)=W{i}(5,3:9);
    DATA2004_X(i,:)=W{i}(6,3:9);
    DATA2005_X(i,:)=W{i}(7,3:9);
    DATA2006_X(i,:)=W{i}(8,3:9);
    DATA2007_X(i,:)=W{i}(9,3:9);
    
    DATA2002_Y(i,:)=W{i}(4,1);
    DATA2003_Y(i,:)=W{i}(5,1);
    DATA2004_Y(i,:)=W{i}(6,1);
    DATA2005_Y(i,:)=W{i}(7,1);
    DATA2006_Y(i,:)=W{i}(8,1);
    DATA2007_Y(i,:)=W{i}(9,1);
    
    end
    save DataH_BS;
    
%Two step GMM estimation
[ng, I1, I2, DXY0, estimates_survey, VarDelta, delta0]=TransitionMatrix9f;
save('DataH_GMMmainBS')

%Calculating tau_i
for i=1:ng
    ut0{i}=DXY0{i}(:,1)-DXY0{i}(:,2)*estimates_survey(1);
    ut0{i}(1)=ut0{i}(1)-delta0(2);
    ut0{i}(2)=ut0{i}(2)-delta0(3);
    ut0{i}(3)=ut0{i}(3)-delta0(4);
    ut0{i}(4)=ut0{i}(4)-delta0(5);
    ut0{i}(5)=ut0{i}(5)-delta0(6);
    ut0{i}(6)=ut0{i}(6)-delta0(7);
    
    % DXY00: (1)Revised HHID (2)year (3)ut0 
    DXY00{i}=[DXY0{i}(:,10) DXY0{i}(:,9) ut0{i}];
    DXY00{i}(1,4)= NaN(1,1);
    DXY00{i}(2,4)= DXY00{i}(1,3);
    DXY00{i}(3,4)= DXY00{i}(2,3);
    DXY00{i}(4,4)= DXY00{i}(3,3);
    DXY00{i}(5,4)= DXY00{i}(4,3);
    DXY00{i}(6,4)= DXY00{i}(5,3);
    
    DXY00{i}(1,5)= NaN(1,1);
    DXY00{i}(2,5)= NaN(1,1);
    DXY00{i}(3,5)= DXY00{i}(2,4);
    DXY00{i}(4,5)= DXY00{i}(3,4);
    DXY00{i}(5,5)= DXY00{i}(4,4);
    DXY00{i}(6,5)= DXY00{i}(5,4); 
    
    DXY00{i}(1,6)= NaN(1,1);
    DXY00{i}(2,6)= NaN(1,1);
    DXY00{i}(3,6)= NaN(1,1);
    DXY00{i}(4,6)= DXY00{i}(3,5);
    DXY00{i}(5,6)= DXY00{i}(4,5);
    DXY00{i}(6,6)= DXY00{i}(5,5);   
    d_tau{i}=DXY00{i};
end

save('DataH_tau_BS', 'd_tau')

[var_equ, var_me2, var_u, ut0]=TransitionMatrix9g;
save('DataH_varerror_BS', 'var_equ', 'var_me2', 'var_u')

if var_equ<0 |  var_me2<0 |  var_u<0
    rep=rep-1;
    rep
    clearvars -except ng B R TABLE4B  TABLE5B psd rep count
    psd=psd+1;
    continue
end

[sim]=TransitionMatrix9h(ut0);

a1=5.659266125;

% INDICATE IN POVERTY
pov_sim=[];
pov_sim(:,1)=sim(:,1);

NAN_BM=sum(isnan(sim));

%under the poverty=0
for i=1:ng
    for j=3:20
        if sim(i,j)<a1
        pov_sim(i,j)=0;
        else
        pov_sim(i,j)=1;
        end
        if isnan(sim(i,j))==1
        pov_sim(i,j)=NaN;  
        end
    end
end

% MATCH SURVEY AND S.DATA
for i=1:ng
    for j=3:8
    if isnan(pov_sim(i,j))+isnan(pov_sim(i,j+6))>0
        pov_sim(i,j)=NaN; 
        pov_sim(i,j+6)=NaN;
        pov_sim(i,j+12)=NaN;
        pov_sim(i,j+18)=NaN;
    end
    end
end

NAN_M=sum(isnan(pov_sim));

% TABLE - 2*2
% CALCULATION TRANSITION MATRIX
[PS, CS, cs]=TransitionMatrix4(2002,2007,1, pov_sim, ng);
[PU, CU, cu]=TransitionMatrix4(2002,2007,2, pov_sim, ng); 
[PL, CL, cl]=TransitionMatrix4(2002,2007,3, pov_sim, ng);  

TABLE4B(:,:, rep)=[100*PS(1,1) 100*PS(1,2);
       100*PU(1,1) 100*PU(1,2);
       100*PL(1,1) 100*PL(1,2);
       100*PS(2,1) 100*PS(2,2);
       100*PU(2,1) 100*PU(2,2);
       100*PL(2,1) 100*PL(2,2);]

%TABLE - 5*5
for t=1:3
r{t}=quantile(sim(:,3+6*(t-1)), [.20 .40 .60 .80])';
end

quintile_sim=[];
quintile_sim(:,1:2)=sim(:,1:2);
for t=1:3
for i=1:ng
    for j=3:8
        if sim(i,j+6*(t-1))<r{1,t}(1)
        quintile_sim(i,j+6*(t-1))=1;
        elseif sim(i,j+6*(t-1))<r{1,t}(2);
        quintile_sim(i,j+6*(t-1))=2;
        elseif sim(i,j+6*(t-1))<r{1,t}(3);
        quintile_sim(i,j+6*(t-1))=3;
        elseif sim(i,j+6*(t-1))<r{1,t}(4);
        quintile_sim(i,j+6*(t-1))=4;
        elseif sim(i,j+6*(t-1))>=r{1,t}(4)
        quintile_sim(i,j+6*(t-1))=5;  
        else 
        quintile_sim(i,j+6*(t-1))=NaN;
        end
    end
end
end

for i=1:ng
    for j=3:8
    if isnan(quintile_sim(i,j))+isnan(quintile_sim(i,j+6))>0
        quintile_sim(i,j)=NaN; 
        quintile_sim(i,j+6)=NaN;
        quintile_sim(i,j+12)=NaN;
    end
    end
end

% CALCULATION TRANSITION MATRIX
[PSQ,CSQ,csq]=TransitionMatrix5(2002,2007,1, quintile_sim, ng);
[PUQ,CUQ,cuq]=TransitionMatrix5(2002,2007,2, quintile_sim, ng);
[PLQ,CLQ,clq]=TransitionMatrix5(2002,2007,3, quintile_sim, ng);  

TABLE5B(:,:, rep)=[PSQ(1,1:5);  PUQ(1,1:5); PLQ(1,1:5); 
                   PSQ(2,1:5);  PUQ(2,1:5); PLQ(2,1:5); 
                   PSQ(3,1:5);  PUQ(3,1:5); PLQ(3,1:5); 
                   PSQ(4,1:5);  PUQ(4,1:5); PLQ(4,1:5); 
                   PSQ(5,1:5);  PUQ(5,1:5); PLQ(5,1:5);];
               
clearvars -except ng B R TABLE4B  TABLE5B psd rep count

end

MTABLE4B=mean(TABLE4B,3)
MTABLE5B=mean(TABLE5B,3)

DTABLE4B=zeros(size(MTABLE4B));   
DTABLE5B=zeros(size(MTABLE5B));   

for rep=1:B;
    
DTABLE4B=DTABLE4B+(squeeze(TABLE4B(:,:, rep))-MTABLE4B).*(squeeze(TABLE4B(:,:, rep))-MTABLE4B);
DTABLE5B=DTABLE5B+(squeeze(TABLE5B(:,:, rep))-MTABLE5B).*(squeeze(TABLE5B(:,:, rep))-MTABLE5B);
    
end

STABLE4B=sqrt((1/(B-1))*DTABLE4B)
STABLE5B=sqrt((1/(B-1))*DTABLE5B)


