function [EMP]=TransitionMatrix3b(errorM)
% This is to estimate the empirical inverse cdf for Pearson Distribution

%Empirical Marginal Distribution
var_s=errorM(1,1);
skew_s=errorM(1,2);
eK_s=errorM(1,3);

var_0=errorM(2,1);
skew_0=errorM(2,2);
eK_0=errorM(2,3);

var_u=errorM(3,1);
skew_u=errorM(3,2);
eK_u=errorM(3,3);

var_l=errorM(4,1);
skew_l=errorM(4,2);
eK_l=errorM(4,3);

% 50000 to avoid approximation error of empirical inverse cdf
error_0= pearsrnd(0,var_0^(1/2),skew_0,eK_0+3,50000,1);
error_u=pearsrnd(0,var_u^(1/2),skew_u,eK_u+3,50000,1); 
error_l=pearsrnd(0,var_l^(1/2),skew_l,eK_l+3,50000,1); 
error= pearsrnd(0,var_s.^(1/2),skew_s,eK_s+3,50000,1); 

%Simulation from Empirical Distribution
EMP= [error_0 error_u error_l error];

return



