clear
clc

display('Bootstrapping Standard Error')

display('Bootstrapping Repetition counting')
load Data_ReadyPTM; 
clearvars -except ng

B=1000; % # of repetitions
var_errors=zeros(B,6);

%stream = RandStream.getGlobalStream;
%savedState = stream.State;
    
R=rand(B,ng);

for rep=1:B;
    
    load Data_ReadyPTM;   
    rep
    
    W0=W;
    SS0=SS;
    SI0=SI;
    k1=zeros(ng,1);
    
    for i=1:ng
        j=round(R(rep,i)*(ng-1))+1;
        W{i}=W0{j};
        SS{i}=SS0{j};
        SI(i,:)=SI0(j,:);
        k1(i)=j;
    end
 
% Two-step GMM estimation    
% calculate the size of Z
LagBegin=3; % first internal IV - t-3 
sgiv=1+2+3+4+5+6; % internal IV t-3 and t-4 :21
sei=2*(T-LagBegin); % t-2 and t-3 lags *6 years external IVs: 12
sex=(Kex-5)*(T-LagBegin); % # of exogenous variable, which is reduced (dummy correction) 
sZ=sgiv+sex+sei; %size of Z:  6K+6+21+12=45 with K=1, and 1 constant each year
sW=Kex+1; %size of W: 8

% initiate matrices
obs=0;
ANINV0=zeros(sZ,sZ);
WZ=zeros(sW,sZ);
ZW=zeros(sZ,sW);
Zy=zeros(sZ,1);

s1=0;

% to construct Z instrument matrix
 for i=1:ng
   % first differencing (but keep time dummies as levels)
   for t=1:6
   W_star0{i}(t,1:sW+1)=[W{i}(t+3,1:3)-W{i}(t+2,1:3) W{i}(t+3, 4:sW+1)]; % consumption and hhsize first differencing
   end
      
   % to control sample size for l_is_head
   % to control sample size for ln_l3_at_cons (preserving t-3 consumption)
   for t=1:6
   W_star0{i}(t,sW+2:sW+3)=[W{i}(t+3,12) W{i}(t,1)];    
   end

   % GMM-Style instrumental variable matrix Z
   % exogenous variables (differenced) and external IVs (not differenced)
   % without dummy variables (but a constant term included)
   Z{i}(:,:)=zeros(6,sZ);   % initiate matrix
   Z{i}(1,1:1+1+1+2)   = [1 W{i}(1,1)                                                   W_star0{i}(1, 3) W{i}(4, 10:11)];
   Z{i}(2,6:6+2+1+2)   = [1 W{i}(1,1) W{i}(2,1)                                         W_star0{i}(2, 3) W{i}(5, 10:11)];
   Z{i}(3,12:12+3+1+2) = [1 W{i}(1,1) W{i}(2,1) W{i}(3,1)                               W_star0{i}(3, 3) W{i}(6, 10:11)];
   Z{i}(4,19:19+4+1+2) = [1 W{i}(1,1) W{i}(2,1) W{i}(3,1) W{i}(4,1)                     W_star0{i}(4, 3) W{i}(7, 10:11)];
   Z{i}(5,27:27+5+1+2) = [1 W{i}(1,1) W{i}(2,1) W{i}(3,1) W{i}(4,1) W{i}(5,1)           W_star0{i}(5, 3) W{i}(8, 10:11)];
   Z{i}(6,36:36+6+1+2) = [1 W{i}(1,1) W{i}(2,1) W{i}(3,1) W{i}(4,1) W{i}(5,1) W{i}(6,1) W_star0{i}(6, 3) W{i}(9, 10:11)];
      

   %to keep observations with NaN for consumption at t-4 and earlier
   if  isnan(W{i}(1,1))==1
       Z{i}(2,7)=0;
       Z{i}(3,13)=0;
       Z{i}(4,20)=0;
       Z{i}(5,28)=0;
       Z{i}(6,37)=0;
   end
   if isnan(W{i}(2,1))==1
       Z{i}(3,14)=0;
       Z{i}(4,21)=0;
       Z{i}(5,29)=0;
       Z{i}(6,38)=0;
   end
   if isnan(W{i}(3,1))==1
       Z{i}(4,22)=0;
       Z{i}(5,30)=0;
       Z{i}(6,39)=0; 
   end
   if isnan(W{i}(4,1))==1
       Z{i}(5,31)=0;
       Z{i}(6,40)=0; 
   end
   if isnan(W{i}(5,1))==1
       Z{i}(6,41)=0; 
   end

   
   DXY0{i}=W_star0{i}(:,1:9);
   DXY0{i}(1,10)=2002;
   DXY0{i}(2,10)=2003;
   DXY0{i}(3,10)=2004;
   DXY0{i}(4,10)=2005;
   DXY0{i}(5,10)=2006;
   DXY0{i}(6,10)=2007;
   DXY0{i}(1,11)=i;
   DXY0{i}(2,11)=i;
   DXY0{i}(3,11)=i;
   DXY0{i}(4,11)=i;
   DXY0{i}(5,11)=i;
   DXY0{i}(6,11)=i;
   
   I1{i}=W_star0{i};
   I2{i}=Z{i};
   
   % sample size control, delete NaN 
   k2=0; 
   for t=1:6
        if sum(isnan(W_star0{i}(t-k2,:)))>0 || sum(isnan(Z{i}(t-k2,:)))>0  
        W_star0{i}(t-k2,:)=[];
        Z{i}(t-k2,:)=[];
        SS{i}(t-k2,:)=[];
        k2=k2+1;  
       end
   end
   

   % dependent and independent variables
   W_star{i}=W_star0{i}(:,2:9);
   y_star{i}=W_star0{i}(:,1);
    
   % calculating # of observations (this is not # of groups)
   s=size(W_star0{i},1);
   obs=obs+s;
      
   % Weight Matrix for one step estimator
   H0{i}=eye(6,6);
      
   % for unbalanced panel      
   for j=1:6-s
   H0{i}(:,6-j+1)=[];
   H0{i}(6-j+1,:)=[];
   end   
   
   AN00{i}=Z{i}'*H0{i}*Z{i}; 
   ANINV0=(ANINV0+AN00{i});
   WZ0{i}=W_star{i}'*Z{i};
   WZ=(WZ+WZ0{i});
   ZW0{i}=Z{i}'*W_star{i};
   ZW=(ZW+ZW0{i});
   Zy0{i}=Z{i}'*y_star{i};
   Zy=(Zy+Zy0{i});
 end
     
 ANINV0=ANINV0/ng;
 ev1=eig(ANINV0);
 if min(ev1)<=0
     disp('Warning: One-step Covariance matrix of moment conditions is singular')
 end
 AN0=inv(ANINV0); 
  
 % one-step estimator
 delta1=(inv(WZ*AN0*ZW))*(WZ*AN0*Zy);
 ev11=eig(WZ*AN0*ZW);
 if min(ev11)<=0
     disp('Warning: Matrix is singular')
 end
 
 ANINV=zeros(sZ,sZ);
 
 for i=1:ng
  % residuals from the first step GMM   
  r{i}=y_star{i}-W_star{i}*delta1;
  % weight matrix for two step estimator
  H1{i}= (r{i})*(r{i})';
  AN1{i}=Z{i}'*H1{i}*Z{i}; 
  ANINV=(ANINV+AN1{i});
 end
  
 ANINV=ANINV/ng; 
 ev2=eig(ANINV);
 if min(ev2)<=0
     disp('Warning: Two-step Covariance matrix of moment conditions is singular')
 end
 AN=inv(ANINV);
   
 % two-step estimator
 delta=(inv(WZ*AN*ZW))*(WZ*AN*Zy);
 delta0=delta;
 ev22=eig(WZ*AN*ZW);
 if min(ev22)<=0
     disp('Warning: Matrix is singular')
 end 
 
 % two-step estimator standard errors (before transformation)
 VarDelta=ng*diag((inv(WZ*AN*ZW)));
 sqroot=(1/2)*ones(size(VarDelta,1),1);
 StdDelta=VarDelta.^sqroot;
 
 % Hansen J statistics
 rZ=zeros(1,sZ);
 Zr=zeros(sZ,1);
 
 for i=1:ng
    rZ0{i}=r{i}'*Z{i};
    rZ=rZ+rZ0{i};
    Zr0{i}=Z{i}'*r{i};
    Zr=Zr+Zr0{i};
 end
  
 HJ=(1/ng)*rZ*AN*Zr;
 NI=size(AN,2);
 p_chiHJ=1-chi2cdf(HJ,NI-8);
   
% original parameterization for time dummies
A=blkdiag(eye(2,2),tril(ones(6,6)));
delta_c=A*delta;
delta=delta_c;
% two-step estimator standard errors (after transformation)
VarDelta_c=A*((inv(WZ*AN*ZW)))*A';
VarDelta=ng*diag(VarDelta_c);
sqroot=(1/2)*ones(size(VarDelta,1),1);
StdDelta=VarDelta.^sqroot;

estimates_survey=delta;

[delta StdDelta];
[obs ng HJ NI NI-8 p_chiHJ]; 
gamma=estimates_survey(1);
obs1=obs;

% G hat
G=[ 2   2*((gamma)^2+gamma+1) 1;
   -1   (-1)*((gamma)^2+2*gamma+1) 0;
    0   gamma 0];

for i=1:ng
    ut0{i}=DXY0{i}(:,1)-DXY0{i}(:,2:3)*estimates_survey(1:2);
    ut0{i}(1)=ut0{i}(1)-delta0(3);
    ut0{i}(2)=ut0{i}(2)-delta0(4);
    ut0{i}(3)=ut0{i}(3)-delta0(5);
    ut0{i}(4)=ut0{i}(4)-delta0(6);
    ut0{i}(5)=ut0{i}(5)-delta0(7);
    ut0{i}(6)=ut0{i}(6)-delta0(8);
    % DXY00: (1)Revised HHID (2)year (3)ut0 
    DXY00{i}=[DXY0{i}(:,11) DXY0{i}(:,10) ut0{i}];
    DXY00{i}(1,4)= NaN(1,1);
    DXY00{i}(2,4)= DXY00{i}(1,3);
    DXY00{i}(3,4)= DXY00{i}(2,3);
    DXY00{i}(4,4)= DXY00{i}(3,3);
    DXY00{i}(5,4)= DXY00{i}(4,3);
    DXY00{i}(6,4)= DXY00{i}(5,3);
    DXY00{i}(1,5)= NaN(1,1);
    DXY00{i}(2,5)= NaN(1,1);
    DXY00{i}(3,5)= DXY00{i}(2,4);
    DXY00{i}(4,5)= DXY00{i}(3,4);
    DXY00{i}(5,5)= DXY00{i}(4,4);
    DXY00{i}(6,5)= DXY00{i}(5,4);   
    
    ut0{i}=DXY00{i};
          
    E{i}=[I1{i} I2{i}];
    
    k1=7; 
    for t=1:6
       if sum(isnan(E{i}(k1-t,:)))>0   
       ut0{i}(k1-t,:)=[];
       end
    end  
end
 

obs=0;
for i=1:ng
     swi=size(ut0{i},1);
     d_tau_i(obs+1:obs+swi,:)=ut0{i}(:,:);
     obs=size(d_tau_i,1);
end
obs;
 
ut=d_tau_i(:,3);
ut_1=d_tau_i(:,4);
ut_2=d_tau_i(:,5);    
 
% a hat / var a hat
ut_ut=ut.*ut;
ut_ut_1=ut.*ut_1;
ut_ut_2=ut.*ut_2;
 

w0=nanmean(ut_ut,1);
w1=nanmean(ut_ut_1,1);
w2=nanmean(ut_ut_2,1);

a=[w0;w1;w2];
 
% b hat
b_hat=inv(G)*a;
sq_b_hat=b_hat.^(1/2);
 
var_equ=b_hat(1,1);
var_me2=b_hat(2,1);
var_u=b_hat(3,1);

var_errors(rep,:)=[rep gamma var_equ var_me2 var_u obs];
clearvars -except var_errors B R savedState;
end  

%(1)rep (2)gamma (3)var_equ (4)var_me2 (5)var_u obs
var_errors;
load Data_varerror

Vm=mean(var_errors(:,3:5))
Vdev=(var_errors(:,3:5)-ones(B,1)*Vm)';
VmO=[var_equ, var_me2, var_u];
VdevO=(var_errors(:,3:5)-ones(B,1)*VmO)';

Vs=zeros(3,3);
VsO=zeros(3,3);

for i=1:B
Vs=Vs+Vdev(:,i)*Vdev(:,i)';
VsO=VsO+VdevO(:,i)*VdevO(:,i)';
end

Vs=(1/(B-1))*Vs;
SE=[ var_equ, var_me2, var_u;
     Vs(1,1).^(1/2), Vs(2,2).^(1/2), Vs(3,3).^(1/2)
 var_equ./(Vs(1,1).^(1/2)) var_me2./(Vs(2,2).^(1/2)) var_u./(Vs(3,3).^(1/2))]
  
VsO=(1/(B-1))*VsO;
SEO=[ var_equ, var_me2, var_u;
     VsO(1,1).^(1/2) VsO(2,2).^(1/2) VsO(3,3).^(1/2)
     var_equ./(VsO(1,1).^(1/2)) var_me2./(VsO(2,2).^(1/2)) var_u./(VsO(3,3).^(1/2))]
  
save('EV_BSresult_1000')

        