% Orthogonality test for income satisfaction variable

function [STAT, DF]=TransitionMatrix1f

display('TransitionMatrix1f**********************') 

[ALL]=TransitionMatrix1z;
J=ALL(1);
L=ALL(2)-8;

disp('Consumption Dynamics');
disp('Internal (3...)') ;
disp('expenditure t-3 and earlier');

format short g

load Data_ReadyPTM;

% W{i}: (1)Y (2)LAG Y (3)hsize 
% (4)d02 (5)d03 (6)d04 (7)d05 (8)d06 (9)d07 
% (10)l2_is_head (11)l3_is_head  
% (12)l_is_head 

% calculate the size of Z
LagBegin=3; % first internal IV - t-3 
sgiv=1+2+3+4+5+6; % internal IV t-3 and t-4 :21
sei=0  % NO external IVs
sex=(Kex-5)*(T-LagBegin); % # of exogenous variable is reduced (dummy correction) 
sZ=sgiv+sex+sei; %size of Z:  6K+21+6=33 with K=1, and 1 constant each year
sW=Kex+1; %size of W

% initiate matrices
obs=0;
ANINV0=zeros(sZ,sZ);
WZ=zeros(sW,sZ);
ZW=zeros(sZ,sW);
Zy=zeros(sZ,1);

s1=0;

% to construct Z instrument matrix
 for i=1:ng
   % first differencing (but keep time dummies as levels)
   for t=1:6
   W_star0{i}(t,1:sW+1)=[W{i}(t+3,1:3)-W{i}(t+2,1:3) W{i}(t+3, 4:sW+1)]; % consumption and hhsize first differencing
   end
    
   % to control sample size for l_is_head & l2_is_head l3_is_head
   % to control sample size for ln_l3_at_cons (preserving t-3 consumption)
   for t=1:6
   W_star0{i}(t,sW+2:sW+5)=[W{i}(t+3,10) W{i}(t+3,11) W{i}(t+3,12) W{i}(t,1)];  
   %W_star0{i}(t,sW+2:sW+3)=[W{i}(t+3,12) W{i}(t,1)];    
   end
   
   

   % GMM-Style instrumental variable matrix Z
   % exogenous variables (differenced) and external IVs (not differenced)
   % without dummy variables (but a constant term included)
   Z{i}(:,:)=zeros(6,sZ);   % initiate matrix
   Z{i}(1,1:1+1+1)   = [1 W{i}(1,1)                                                   W_star0{i}(1, 3) ];
   Z{i}(2,4:4+2+1)   = [1 W{i}(1,1) W{i}(2,1)                                         W_star0{i}(2, 3) ];
   Z{i}(3,8:8+3+1)   = [1 W{i}(1,1) W{i}(2,1) W{i}(3,1)                               W_star0{i}(3, 3) ];
   Z{i}(4,13:13+4+1) = [1 W{i}(1,1) W{i}(2,1) W{i}(3,1) W{i}(4,1)                     W_star0{i}(4, 3) ];
   Z{i}(5,19:19+5+1) = [1 W{i}(1,1) W{i}(2,1) W{i}(3,1) W{i}(4,1) W{i}(5,1)           W_star0{i}(5, 3) ];
   Z{i}(6,26:26+6+1) = [1 W{i}(1,1) W{i}(2,1) W{i}(3,1) W{i}(4,1) W{i}(5,1) W{i}(6,1) W_star0{i}(6, 3) ];
      

   %to keep observations with NaN for consumption at t-4 and earlier
   if  isnan(W{i}(1,1))==1
       Z{i}(2,5)=0;
       Z{i}(3,9)=0;
       Z{i}(4,14)=0;
       Z{i}(5,20)=0;
       Z{i}(6,27)=0;
   end
   if isnan(W{i}(2,1))==1
       Z{i}(3,10)=0;
       Z{i}(4,15)=0;
       Z{i}(5,21)=0;
       Z{i}(6,28)=0;
   end
   if isnan(W{i}(3,1))==1
       Z{i}(4,16)=0;
       Z{i}(5,22)=0;
       Z{i}(6,29)=0; 
   end
   if isnan(W{i}(4,1))==1
       Z{i}(5,23)=0;
       Z{i}(6,30)=0; 
   end
   if isnan(W{i}(5,1))==1
       Z{i}(6,31)=0; 
   end
  
   
   DXY0{i}=W_star0{i}(:,1:9);
   DXY0{i}(1,10)=2002;
   DXY0{i}(2,10)=2003;
   DXY0{i}(3,10)=2004;
   DXY0{i}(4,10)=2005;
   DXY0{i}(5,10)=2006;
   DXY0{i}(6,10)=2007;
   DXY0{i}(1,11)=i;
   DXY0{i}(2,11)=i;
   DXY0{i}(3,11)=i;
   DXY0{i}(4,11)=i;
   DXY0{i}(5,11)=i;
   DXY0{i}(6,11)=i;
   
   I1{i}=W_star0{i};
   I2{i}=Z{i};
   
   % sample size control, delete NaN 
   k2=0; 
   for t=1:6
        if sum(isnan(W_star0{i}(t-k2,:)))>0 || sum(isnan(Z{i}(t-k2,:)))>0  
        W_star0{i}(t-k2,:)=[];
        Z{i}(t-k2,:)=[];
        SS{i}(t-k2,:)=[];
        k2=k2+1;  
       end
   end
   

   % dependent and independent variables
   W_star{i}=W_star0{i}(:,2:9);
   y_star{i}=W_star0{i}(:,1);
    
   % calculating # of observations (this is not # of groups)
   s=size(W_star0{i},1);
   obs=obs+s;
      
   % Weight Matrix for one step estimator
   H0{i}=eye(6,6);
      
   % for unbalanced panel      
   for j=1:6-s
   H0{i}(:,6-j+1)=[];
   H0{i}(6-j+1,:)=[];
   end   
   
   AN00{i}=Z{i}'*H0{i}*Z{i}; 
   ANINV0=(ANINV0+AN00{i});
   WZ0{i}=W_star{i}'*Z{i};
   WZ=(WZ+WZ0{i});
   ZW0{i}=Z{i}'*W_star{i};
   ZW=(ZW+ZW0{i});
   Zy0{i}=Z{i}'*y_star{i};
   Zy=(Zy+Zy0{i});
 end
  
 ANINV0=ANINV0/ng;
 ev1=eig(ANINV0);
 if min(ev1)<=0
     disp('Warning: One-step Covariance matrix of moment conditions is singular')
 end
 AN0=inv(ANINV0); 
  
 % one-step estimator
 delta1=(inv(WZ*AN0*ZW))*(WZ*AN0*Zy);
 ev11=eig(WZ*AN0*ZW);
 if min(ev11)<=0
     disp('Warning: Matrix is singular')
 end
 
 ANINV=zeros(sZ,sZ);
 
 for i=1:ng
  % residuals from the first step GMM   
  r{i}=y_star{i}-W_star{i}*delta1;
  % weight matrix for two step estimator
  H1{i}= (r{i})*(r{i})';
  AN1{i}=Z{i}'*H1{i}*Z{i}; 
  ANINV=(ANINV+AN1{i});
 end
  
 ANINV=ANINV/ng; 
 ev2=eig(ANINV);
 if min(ev2)<=0
     disp('Warning: Two-step Covariance matrix of moment conditions is singular')
 end
 AN=inv(ANINV);
   
 % two-step estimator
 delta=(inv(WZ*AN*ZW))*(WZ*AN*Zy);
 ev22=eig(WZ*AN*ZW);
 if min(ev22)<=0
     disp('Warning: Matrix is singular')
 end 
 
 % two-step estimator standard errors (before transformation)
 VarDelta=ng*diag((inv(WZ*AN*ZW)));
 sqroot=(1/2)*ones(size(VarDelta,1),1);
 StdDelta=VarDelta.^sqroot;
 
 % Hansen J statistics
 rZ=zeros(1,sZ);
 Zr=zeros(sZ,1);
 
 for i=1:ng
    rZ0{i}=r{i}'*Z{i};
    rZ=rZ+rZ0{i};
    Zr0{i}=Z{i}'*r{i};
    Zr=Zr+Zr0{i};
 end
  
 HJ=(1/ng)*rZ*AN*Zr;
 NI=size(AN,2);
 p_chiHJ=1-chi2cdf(HJ,NI-8);
   
% original parameterization for time dummies
A=blkdiag(eye(2,2),tril(ones(6,6)));
delta_c=A*delta;
delta=delta_c;
% two-step estimator standard errors (after transformation)
VarDelta_c=A*((inv(WZ*AN*ZW)))*A';
VarDelta=ng*diag(VarDelta_c);
sqroot=(1/2)*ones(size(VarDelta,1),1);
StdDelta=VarDelta.^sqroot;

estimates_survey=delta;
[delta StdDelta];
[obs ng HJ NI NI-8 p_chiHJ] ;

J1=HJ;
L1=NI-8;

STAT=J-J1
DF=L-L1

p_chi=1-chi2cdf(STAT,DF)

return
