%Serial Correlation Tests

function [coef_tau2, se_tau2, t_tau2]=TransitionMatrix1e

clc
clear

display('TransitionMatrix1e**********************') 
load Data_GMMmain; 
load Data_ReadyPTM;
load Data_tau;

% W{i}: (1)Y (2)LAG Y (3)hsize 
% (4)d02 (5)d03 (6)d04 (7)d05 (8)d06 (9)d07 
% (10)l2_is_head (11)l3_is_head  
% (12)l_is_head

% tau_it-2 added
T=T-2;
Kex=Kex+1-2;

% calculate the size of Z
LagBegin=3; % first internal IV - t-3 
sgiv=3+4+5+6; % internal IV t-3 and t-4 :18
sei=2*(T-LagBegin); % t-2 and t-3 lags *4 years external IVs: 8
sex=(Kex-3)*(T-LagBegin); % 12, # of exogenous variable is reduced (dummy correction) 
sZ=sgiv+sex+sei; %size of Z:  4K+4+18+8+4=38 with K=1, and 1 constant each year
sW=Kex+1; %size of W: 7

% initiate matrices
obs=0;
ANINV0=zeros(sZ,sZ);
WZ=zeros(sW,sZ);
ZW=zeros(sZ,sW);
Zy=zeros(sZ,1);

s1=0;


% to construct Z instrument matrix
 for i=1:ng
  
   % first differencing (but keep time dummies as levels)
   for t=1:4
   W_star0{i}(t,1:sW+1)=[W{i}(t+5,1:3)-W{i}(t+4,1:3) W{i}(t+5, 6:9) d_tau{i}(t+2,5)]; % consumption and hhsize first differencing
   end
      
   % to control sample size for l_is_head
   % to control sample size for ln_l3_at_cons (preserving t-3 consumption)
   for t=1:4
   W_star0{i}(t,sW+2:sW+3)=[W{i}(t+5,12) W{i}(t+2,1)];    
   end

   % GMM-Style instrumental variable matrix Z
   % exogenous variables (differenced) and external IVs (not differenced)
   % without dummy variables (but a constant term included)
   Z{i}(:,:)=zeros(4,sZ);   % initiate matrix
   Z{i}(1,1:1+3+1+2+1)   = [1 W{i}(1,1) W{i}(2,1) W{i}(3,1)                               W_star0{i}(1, 3) W{i}(6, 10:11) d_tau{i}(3,5)];
   Z{i}(2,9:9+4+1+2+1)   = [1 W{i}(1,1) W{i}(2,1) W{i}(3,1) W{i}(4,1)                     W_star0{i}(2, 3) W{i}(7, 10:11) d_tau{i}(4,5)];
   Z{i}(3,18:18+5+1+2+1) = [1 W{i}(1,1) W{i}(2,1) W{i}(3,1) W{i}(4,1) W{i}(5,1)           W_star0{i}(3, 3) W{i}(8, 10:11) d_tau{i}(5,5)];
   Z{i}(4,28:28+6+1+2+1) = [1 W{i}(1,1) W{i}(2,1) W{i}(3,1) W{i}(4,1) W{i}(5,1) W{i}(6,1) W_star0{i}(4, 3) W{i}(9, 10:11) d_tau{i}(6,5)];
      

   %to keep observations with NaN for consumption at t-4 and earlier
    if isnan(W{i}(1,1))==1
       Z{i}(1,2)=0; 
       Z{i}(2,10)=0;
       Z{i}(3,19)=0;
       Z{i}(4,29)=0;
   end
   if isnan(W{i}(2,1))==1
       Z{i}(1,3)=0;
       Z{i}(2,11)=0;
       Z{i}(3,20)=0;
       Z{i}(4,30)=0;
   end
   if isnan(W{i}(3,1))==1
       Z{i}(2,12)=0;
       Z{i}(3,21)=0;
       Z{i}(4,31)=0;
   end
   if isnan(W{i}(4,1))==1
       Z{i}(3,22)=0;
       Z{i}(4,32)=0; 
   end
   if isnan(W{i}(5,1))==1
       Z{i}(4,33)=0; 
   end
   
   DXY0{i}=W_star0{i}(:,1:9);
   DXY0{i}(1,10)=2004;
   DXY0{i}(2,10)=2005;
   DXY0{i}(3,10)=2006;
   DXY0{i}(4,10)=2007;
   DXY0{i}(1,11)=i;
   DXY0{i}(2,11)=i;
   DXY0{i}(3,11)=i;
   DXY0{i}(4,11)=i;
   
   I1{i}=W_star0{i};
   I2{i}=Z{i};
   
   % sample size control, delete NaN 
   k2=0; 
   for t=1:4
        if sum(isnan(W_star0{i}(t-k2,:)))>0 || sum(isnan(Z{i}(t-k2,:)))>0  
        W_star0{i}(t-k2,:)=[];
        Z{i}(t-k2,:)=[];
        SS{i}(t-k2,:)=[];
        k2=k2+1;  
       end
   end
 
 end
 
 W_star0(cellfun(@isempty, W_star0)) = [];
 Z(cellfun(@isempty, Z)) = [];
 SS(cellfun(@isempty, SS)) = [];
 
 ng_m=size(W_star0,2)
  
for i=1:ng_m
   % dependent and independent variables
   W_star{i}=W_star0{i}(:,2:8);
   y_star{i}=W_star0{i}(:,1);
    
   % calculating # of observations (this is not # of groups)
   s=size(W_star0{i},1);
   obs=obs+s;
      
   % Weight Matrix for one step estimator
   H0{i}=eye(4,4);
      
   % for unbalanced panel      
   for j=1:4-s
   H0{i}(:,4-j+1)=[];
   H0{i}(4-j+1,:)=[];
   end   
   
   AN00{i}=Z{i}'*H0{i}*Z{i}; 
   ANINV0=(ANINV0+AN00{i});
   WZ0{i}=W_star{i}'*Z{i};
   WZ=(WZ+WZ0{i});
   ZW0{i}=Z{i}'*W_star{i};
   ZW=(ZW+ZW0{i});
   Zy0{i}=Z{i}'*y_star{i};
   Zy=(Zy+Zy0{i});
 end
  
 ANINV0=ANINV0/ng_m;
 ev1=eig(ANINV0);
 if min(ev1)<=0
     disp('Warning: One-step Covariance matrix of moment conditions is singular')
 end
 AN0=inv(ANINV0); 
  
 % one-step estimator
 delta1=(inv(WZ*AN0*ZW))*(WZ*AN0*Zy);
 ev11=eig(WZ*AN0*ZW);
 if min(ev11)<=0
     disp('Warning: Matrix is singular')
 end
 
 ANINV=zeros(sZ,sZ);
 
 for i=1:ng_m
  % residuals from the first step GMM   
  r{i}=y_star{i}-W_star{i}*delta1;
  % weight matrix for two step estimator
  H1{i}= (r{i})*(r{i})';
  AN1{i}=Z{i}'*H1{i}*Z{i}; 
  ANINV=(ANINV+AN1{i});
 end
  
 ANINV=ANINV/ng_m; 
 ev2=eig(ANINV);
 if min(ev2)<=0
     disp('Warning: Two-step Covariance matrix of moment conditions is singular')
 end
 AN=inv(ANINV);
   
 % two-step estimator
 delta=(inv(WZ*AN*ZW))*(WZ*AN*Zy);
 ev22=eig(WZ*AN*ZW);
 if min(ev22)<=0
     disp('Warning: Matrix is singular')
 end 
 
 % two-step estimator standard errors (before transformation)
 VarDelta=ng_m*diag((inv(WZ*AN*ZW)));
 sqroot=(1/2)*ones(size(VarDelta,1),1);
 StdDelta=VarDelta.^sqroot;
 
 % Hansen J statistics
 rZ=zeros(1,sZ);
 Zr=zeros(sZ,1);
 
 for i=1:ng_m
    rZ0{i}=r{i}'*Z{i};
    rZ=rZ+rZ0{i};
    Zr0{i}=Z{i}'*r{i};
    Zr=Zr+Zr0{i};
 end
  
 HJ=(1/ng_m)*rZ*AN*Zr;
 NI=size(AN,2);
 p_chiHJ=1-chi2cdf(HJ,NI-8);
   
% original parameterization for time dummies
A=blkdiag(eye(2,2),tril(ones(4,4)),ones(1,1));
delta_c=A*delta;
delta=delta_c;
% two-step estimator standard errors (after transformation)
VarDelta_c=A*((inv(WZ*AN*ZW)))*A';
VarDelta=ng_m*diag(VarDelta_c);
sqroot=(1/2)*ones(size(VarDelta,1),1);
StdDelta=VarDelta.^sqroot;

estimates_survey=delta;
t=delta./StdDelta;
obs
[delta StdDelta t];

coef_tau2=delta(7,1);
se_tau2=StdDelta(7,1);
t_tau2=t(7,1);

return