clear 
clc

Zimportfile('Data_sfddm.txt');
missing_sfddm=data(:,2);
clearvars -except missing_sfddm
save('Data_sfddm')

clear
clc

Zimportfile('DataH_sfddm.txt');
missing_sfddm=data(:,2);
clearvars -except missing_sfddm
save('DataH_sfddm')

clear
clc

format short g
%load Data_1999_2007.mat;
Zimportfile('Data_1999_2007.txt');
%  (1) 'sample98' (2) 'hhid'         (3) 'year'           (4) 'hsize'          (5) 'm65'
%  (6) 'f55'      (7) 'seoul'        (8) 'hage'           (9) 'hsex'           (10) 'nonspouse'
%  (11) 'hedu'    (12) 'l_is_head'   (13) 'd07'           (14) 'd06'           (15) 'd05'
%  (16) 'd04'     (17) 'd03'         (18) 'd02'           (19) 'd01'           (20) 'd00' 
%  (21) 'd99'     (22) 'ln_at_cons'  (23) 'ln_l_at_cons'  (24) 'ln_l2_at_cons' (25) 'ln_l3_at_cons'
%  (26) 'ln_l4_at_cons'              (27) 'l2_is_head'    (28) 'l3_is_head'    (29) 'missing'

yearV=data(:,3);
hhid=data(:,2);
ln_at_cons=data(:,22);
ln_l_at_cons=data(:,23);
hsize=data(:,4);
d02=data(:,18);
d03 =data(:,17);
d04=data(:,16); 
d05=data(:,15); 
d06=data(:,14);
d07=data(:,13); 
l2_is_head=data(:,27); 
l3_is_head=data(:,28); 
l_is_head=data(:,12); 
m65=data(:,5); 
f55=data(:,6); 
hsex=data(:,9); 
hedu=data(:,11); 
seoul=data(:,7); 
nonspouse=data(:,10); 
hage=data(:,8);

clearvars -except yearV hhid ln_at_cons ln_l_at_cons hsize d02 d03 d04 d05 d06 d07 l2_is_head l3_is_head l_is_head m65 f55 hsex hedu seoul nonspouse hage; 

save('Data_1999_2007')

% data
% [(1)year (2)hhid (3)ln_at_cons (4)ln_l_at_cons (5)hsize 
% (6)d02 (7)d03 (8)d04 (9)d05 (10)d06 (11)d07
% (12)l2_is_head (13)l3_is_head (14)l_is_head
% (15)m65 (16)f55 (17)hsex (18)hedu (19)seoul (20)nonspouse (21)hage ]

data=[yearV hhid ln_at_cons ln_l_at_cons hsize d02 d03 d04 d05 d06 d07 l2_is_head l3_is_head l_is_head m65 f55 hsex hedu seoul nonspouse hage]; 
data(isinf(data)) = NaN(1);
data=sortrows(data, 2);
DATA=sortrows(data, 1);

% DATA generating year by year
DATA1999 = DATA(1:5000,:);
DATA2000 = DATA(5001:10000,:);
DATA2001 = DATA(10001:15000,:);
DATA2002 = DATA(15001:20000,:);
DATA2003 = DATA(20001:25000,:);
DATA2004 = DATA(25001:30000,:);
DATA2005 = DATA(30001:35000,:);
DATA2006 = DATA(35001:40000,:);
DATA2007 = DATA(40001:45000,:);

% DATA generating X, Y, LAG OF Y
DATA1999_Y=DATA1999(:,3);
DATA2000_Y=DATA2000(:,3);
DATA2001_Y=DATA2001(:,3);
DATA2002_Y=DATA2002(:,3);
DATA2003_Y=DATA2003(:,3);
DATA2004_Y=DATA2004(:,3);
DATA2005_Y=DATA2005(:,3);
DATA2006_Y=DATA2006(:,3);
DATA2007_Y=DATA2007(:,3);

DATA1999_LAGY=DATA1999(:,4);
DATA2000_LAGY=DATA2000(:,4);
DATA2001_LAGY=DATA2001(:,4);
DATA2002_LAGY=DATA2002(:,4);
DATA2003_LAGY=DATA2003(:,4);
DATA2004_LAGY=DATA2004(:,4);
DATA2005_LAGY=DATA2005(:,4);
DATA2006_LAGY=DATA2006(:,4);
DATA2007_LAGY=DATA2007(:,4);

% X: (1)hsize (2)d02 (3)d03 (4)d04 (5)d05 (6)d06 (7)d07
DATA1999_X=DATA1999(:,5:11);
DATA2000_X=DATA2000(:,5:11);
DATA2001_X=DATA2001(:,5:11);
DATA2002_X=DATA2002(:,5:11);
DATA2003_X=DATA2003(:,5:11);
DATA2004_X=DATA2004(:,5:11);
DATA2005_X=DATA2005(:,5:11);
DATA2006_X=DATA2006(:,5:11);
DATA2007_X=DATA2007(:,5:11);

Kex=size(DATA2007_X,2);

% EXIV: (1)l2_is_head (2)l3_is_head 
DATA1999_EXIV=[DATA1999(:,12) DATA1999(:,13)];
DATA2000_EXIV=[DATA2000(:,12) DATA2000(:,13)];
DATA2001_EXIV=[DATA2001(:,12) DATA2001(:,13)];
DATA2002_EXIV=[DATA2002(:,12) DATA2002(:,13)];
DATA2003_EXIV=[DATA2003(:,12) DATA2003(:,13)];
DATA2004_EXIV=[DATA2004(:,12) DATA2004(:,13)];
DATA2005_EXIV=[DATA2005(:,12) DATA2005(:,13)];
DATA2006_EXIV=[DATA2006(:,12) DATA2006(:,13)];
DATA2007_EXIV=[DATA2007(:,12) DATA2007(:,13)];

% sfddm - zero:analyzed
load Data_sfddm.mat
% CHECK THE MISSING SAMPLE SIZE!
MHHID=ones(5000,1);
k1=1;
for j1=1:5000
    if missing_sfddm(k1)==j1;
    MHHID(j1,1)=0;
    k1=k1+1;
    else 
        k1=k1;
    end
end


% YX: (1)Y (2)LAG Y (3)hsize 
% (4)d02 (5)d03 (6)d04 (7)d05 (8)d04 (9)d05 (10)MHHID
% (11)l2_is_head (12)l3_is_head (13)l_is_head 
DATA1999_YX=[DATA1999_Y DATA1999_LAGY DATA1999_X MHHID DATA1999_EXIV DATA1999(:,14)];
DATA2000_YX=[DATA2000_Y DATA2000_LAGY DATA2000_X MHHID DATA2000_EXIV DATA2000(:,14)];
DATA2001_YX=[DATA2001_Y DATA2001_LAGY DATA2001_X MHHID DATA2001_EXIV DATA2001(:,14)];
DATA2002_YX=[DATA2002_Y DATA2002_LAGY DATA2002_X MHHID DATA2002_EXIV DATA2002(:,14)];
DATA2003_YX=[DATA2003_Y DATA2003_LAGY DATA2003_X MHHID DATA2003_EXIV DATA2003(:,14)];
DATA2004_YX=[DATA2004_Y DATA2004_LAGY DATA2004_X MHHID DATA2004_EXIV DATA2004(:,14)];
DATA2005_YX=[DATA2005_Y DATA2005_LAGY DATA2005_X MHHID DATA2005_EXIV DATA2005(:,14)];
DATA2006_YX=[DATA2006_Y DATA2006_LAGY DATA2006_X MHHID DATA2006_EXIV DATA2006(:,14)];
DATA2007_YX=[DATA2007_Y DATA2007_LAGY DATA2007_X MHHID DATA2007_EXIV DATA2007(:,14)];

DATA1999_YX(any(DATA1999_YX(:,10)==1,2), :)=[];
DATA2000_YX(any(DATA2000_YX(:,10)==1,2), :)=[];
DATA2001_YX(any(DATA2001_YX(:,10)==1,2), :)=[];
DATA2002_YX(any(DATA2002_YX(:,10)==1,2), :)=[];
DATA2003_YX(any(DATA2003_YX(:,10)==1,2), :)=[];
DATA2004_YX(any(DATA2004_YX(:,10)==1,2), :)=[];
DATA2005_YX(any(DATA2005_YX(:,10)==1,2), :)=[];
DATA2006_YX(any(DATA2006_YX(:,10)==1,2), :)=[];
DATA2007_YX(any(DATA2007_YX(:,10)==1,2), :)=[];

DATA1999_YX(:,10)=[];
DATA2000_YX(:,10)=[];
DATA2001_YX(:,10)=[];
DATA2002_YX(:,10)=[];
DATA2003_YX(:,10)=[];
DATA2004_YX(:,10)=[];
DATA2005_YX(:,10)=[];
DATA2006_YX(:,10)=[];
DATA2007_YX(:,10)=[];

YX(:,:,1)=DATA1999_YX;
YX(:,:,2)=DATA2000_YX;
YX(:,:,3)=DATA2001_YX;
YX(:,:,4)=DATA2002_YX;
YX(:,:,5)=DATA2003_YX;
YX(:,:,6)=DATA2004_YX;
YX(:,:,7)=DATA2005_YX;
YX(:,:,8)=DATA2006_YX;
YX(:,:,9)=DATA2007_YX;

A1=[size(YX,1) size(YX,2) size(YX,3)];
ng=A1(1,1); % number of groups
T=A1(1,3); % total years (including IVs)

% clearvars -except YX A EXIV MHHID

% W{i}: (1)Y (2)LAG Y (3)hsize 
% (4)d02 (5)d03 (6)d04 (7)d05 (8)d06 (9)d07 
% (10)l2_is_head (11)l3_is_head  
% (12)l_is_head 

for i=1:ng
   W{i}(:,:)=squeeze(YX(i,:,:))';
end


% For Summary Statistics 
% SS: (1)year (2)hhid (3)ln_at_cons (4)hsize (5)m65 (6)f55 (7)hsex (8)hedu 
%     (9)seoul (10)nonspouse (11)hage (12)MHHID
DATA_S1999=[DATA(1:5000,1:3) DATA(1:5000,5) DATA(1:5000,15:21)                 MHHID];
DATA_S2000=[DATA(5001:10000,1:3) DATA(5001:10000,5) DATA(5001:10000,15:21)     MHHID];
DATA_S2001=[DATA(10001:15000,1:3) DATA(10001:15000,5) DATA(10001:15000,15:21)  MHHID];
DATA_S2002=[DATA(15001:20000,1:3) DATA(15001:20000,5) DATA(15001:20000,15:21)  MHHID];
DATA_S2003=[DATA(20001:25000,1:3) DATA(20001:25000,5) DATA(20001:25000,15:21)  MHHID];
DATA_S2004=[DATA(25001:30000,1:3) DATA(25001:30000,5) DATA(25001:30000,15:21)  MHHID];
DATA_S2005=[DATA(30001:35000,1:3) DATA(30001:35000,5) DATA(30001:35000,15:21)  MHHID];
DATA_S2006=[DATA(35001:40000,1:3) DATA(35001:40000,5) DATA(35001:40000,15:21)  MHHID];
DATA_S2007=[DATA(40001:45000,1:3) DATA(40001:45000,5) DATA(40001:45000,15:21)  MHHID];

DATA_S1999(any(DATA_S1999(:,12)==1,2), :)=[];
DATA_S2000(any(DATA_S2000(:,12)==1,2), :)=[];
DATA_S2001(any(DATA_S2001(:,12)==1,2), :)=[];
DATA_S2002(any(DATA_S2002(:,12)==1,2), :)=[];
DATA_S2003(any(DATA_S2003(:,12)==1,2), :)=[];
DATA_S2004(any(DATA_S2004(:,12)==1,2), :)=[];
DATA_S2005(any(DATA_S2005(:,12)==1,2), :)=[];
DATA_S2006(any(DATA_S2006(:,12)==1,2), :)=[];
DATA_S2007(any(DATA_S2007(:,12)==1,2), :)=[];

S(:,:,1)=DATA_S2002;
S(:,:,2)=DATA_S2003;
S(:,:,3)=DATA_S2004;
S(:,:,4)=DATA_S2005;
S(:,:,5)=DATA_S2006;
S(:,:,6)=DATA_S2007;

SI=[DATA_S2000 DATA_S2001];
SI(:,24)=[];
SI(:,12)=[];


for i=1:ng
   SS{i}(:,:)=squeeze(S(i,:,:))';
end

clearvars -except W T Kex ng SS SI
save 'Data_ReadyPTM.mat' 





