clear all
set mem 1g
set matsize 11000

//////////////////////////////////////////////////////////////////////
// bootstrapping - 100 times for s.e.
// test 1 (baseline - exact matching with bootstrapping): psmatch2  //
// test 2 (rosenbaum bounds): rbounds                               //
//////////////////////////////////////////////////////////////////////

// grooms
	clear all
	forvalues i = 1(1)100{
	use datamen.dta, clear //datamen.dta: data including grooms
	
	// create weight
	gen one = 1
	sort mentype data1     //data1 = 1 if a groom is from the online dating , 0 otherwise
	by mentype data1: egen count = total(one)
	gen count_MMtmp = count
	replace count_MMtmp = 0 if data1==0
	gen count_poptmp = count
	replace count_poptmp = 0 if data1==1	
	sort mentype
	by mentype: egen count_MM = max(count_MMtmp)
	by mentype: egen count_pop = max(count_poptmp)
	egen total_MM = sum(data1)
	egen total_pop = sum(data)	
	gen pw_MM = count_MM/total_MM
	gen pw_popinv = total_pop/count_pop 
	gen pw = pw_MM*pw_popinv
	replace pw = 1 if data1==1
	
	replace same_agegroup = same_agegroup/ (1-p_m)
	replace same_edu   = same_edu/(1-p_m) 
	replace same_div   = same_div/(1-p_m) 
	replace same_loca  = same_loca/(1-p_m) 
	replace same_HT    = same_HT/(1-p_m) 
		
	// create a one-to-one matched dataset
	gen r = uniform() 
	sort mentype data1 r
	by mentype data1 : egen sq = seq()
	keep if sq<=count_MM
		
	quietly psmatch2 data1, pscore(pscore0) outcome(same_edu) common noreplacement	// generate the same results
	gen delta_edu = same_edu - _same_edu if _support==1
	rbounds delta_edu, gamma(1 (0.01) 2.0)            
	
	quietly psmatch2 data1, pscore(pscore0) outcome(same_agegroup) common noreplacement	
	gen delta_agegroup = same_agegroup - _same_agegroup if _support==1
	rbounds delta_agegroup, gamma(1 (0.01) 3.5)            
	
	quietly psmatch2 data1, pscore(pscore0) outcome(same_div) common noreplacement	
	gen delta_div = same_div - _same_div if _support==1
	rbounds delta_div, gamma(1 (0.01) 5.0)            

	quietly psmatch2 data1, pscore(pscore0) outcome(same_loca) common noreplacement	
	gen delta_loca = same_loca - _same_loca if _support==1
	rbounds delta_loca, gamma(1 (0.01) 1.7)            
	}
	
//brides
	clear all
	forvalues i = 1(1)100{
	use datawomen.dta, clear //datamen.dta: data including grooms

	//create weights
	gen one = 1
	sort womentype data1
	by womentype data1: egen count = total(one)
	gen count_MMtmp = count
	replace count_MMtmp = 0 if data1==0
	gen count_poptmp = count
	replace count_poptmp = 0 if data1==1
	sort womentype
	by womentype: egen count_MM = max(count_MMtmp)
	by womentype: egen count_pop = max(count_poptmp)
	gen agediff = age_m - age_w	
	egen total_MM = sum(data1)
	egen total_pop = sum(data)
	gen pw_MM = count_MM/total_MM
	gen pw_popinv = total_pop/count_pop 
	gen pw = pw_MM*pw_popinv
	replace pw = 1 if data1==1
	
	replace same_agegroup = same_agegroup/ (1-p_w)
	replace same_edu   = same_edu/(1-p_w) 
	replace same_div   = same_div/(1-p_w) 
	replace same_loca  = same_loca/(1-p_w) 
	replace same_HT    = same_HT/(1-p_w) 
			
	gen r = uniform() 
	sort womentype data1 r
	by womentype data1 : egen sq = seq()
	keep if sq<=count_MM

	quietly psmatch2 data1, pscore(pscore0) outcome(same_edu) common noreplacement	
	gen delta_edu = same_edu - _same_edu if _support==1
	rbounds delta_edu, gamma(1 (0.01) 2.5)            
		
	quietly psmatch2 data1, pscore(pscore0) outcome(same_agegroup) common noreplacement	
	gen delta_agegroup = same_agegroup - _same_agegroup if _support==1
	rbounds delta_agegroup, gamma(1 (0.01) 3.8)            
	
	quietly psmatch2 data1, pscore(pscore0) outcome(same_div) common noreplacement	
	gen delta_div = same_div - _same_div if _support==1
	rbounds delta_div, gamma(1 (0.1) 6.0)            

	quietly psmatch2 data1, pscore(pscore0) outcome(same_loca) common noreplacement	
	gen delta_loca = same_loca - _same_loca if _support==1
	rbounds delta_loca, gamma(1 (0.01) 2.5)            

	quietly psmatch2 data1, pscore(pscore0) outcome(same_HT) common noreplacement	
	gen delta_HT = same_HT - _same_HT if _support==1
	rbounds delta_HT, gamma(1 (0.01) 2.5)            
	}

//////////////////////////////////////////////////////////////
//  census imputed: detailed education and industry
//////////////////////////////////////////////////////////////
// groom
	clear all
	forvalues i = 1(1)100{
	use datamen_bs`i'.dta, clear // dataset with the info of imputed education and industry
	keep if div_m==0 & div_w==0
	egen mentype1 = group(age_m loca_m HT_m edu_m2 ind_m2 year)
	sort mentype1
	by mentype1: egen dum_datanew = max(data)
	by mentype1: egen dum_data1new = max(data1)
	keep if mentype1!=.

	keep if dum_datanew==1 & dum_data1new==1
	gen one = 1
	gen same_ind = 0
	replace same_ind = 1 if ind_m2==ind_w2

	sort mentype1 data1
	by mentype1 data1: egen count = total(one)
	gen count_MMtmp = count
	replace count_MMtmp = 0 if data1==0
	gen count_poptmp = count
	replace count_poptmp = 0 if data1==1
	
	sort mentype1
	by mentype1: egen count_MM = max(count_MMtmp)
	by mentype1: egen count_pop = max(count_poptmp)
	drop agediff
	gen agediff = age_m - age_w
		
	egen total_MM = sum(data1)
	egen total_pop = sum(data)
	gen pw_MM = count_MM/total_MM
	gen pw_popinv = total_pop/count_pop 
	gen pw = pw_MM*pw_popinv
	replace pw = 1 if data1==1
	
	replace same_edu   = same_edu/(1-p_m) 
	replace same_div   = same_div/(1-p_m) 
	replace same_loca  = same_loca/(1-p_m) 
	replace same_HT    = same_HT/(1-p_m) 
	replace same_agegroup = same_agegroup/ (1-p_m)
	replace same_edu2   = same_edu2/(1-p_m) 
	replace same_ind2   = same_ind2/(1-p_m) 
	
	gen r = uniform() 
	sort mentype1 data1 r
	by mentype1 data1 : egen sq = seq()
	keep if sq<=count_MM
		
	quietly psmatch2 data1, pscore(pscore0) outcome(same_edu) common noreplacement	
	gen delta_edu = same_edu - _same_edu if _support==1
	rbounds delta_edu, gamma(1 (0.01) 3)              

	quietly psmatch2 data1, pscore(pscore0) outcome(same_agegroup) common noreplacement	
	gen delta_agegroup = same_agegroup - _same_agegroup if _support==1
	rbounds delta_agegroup, gamma(1 (0.01) 3)            

	quietly psmatch2 data1, pscore(pscore0) outcome(same_loca) common noreplacement	
	gen delta_loca = same_loca - _same_loca if _support==1
	rbounds delta_loca, gamma(1 (0.01) 3)  
	
	quietly psmatch2 data1, pscore(pscore0) outcome(same_edu2) common noreplacement	
	gen delta_edu2 = same_edu2 - _same_edu2 if _support==1
	rbounds delta_edu2, gamma(1 (0.01) 3)            
	}

// brides
	clear all
	forvalues i = 1(1)100{
	use datawomen_bs`i'.dta, clear // dataset with the info of imputed education and industry
	keep if ind_m2!=. & ind_w2!=.
	keep if div_m==0 & div_w==0
	egen womentype1 = group(age_w div_w loca_w HT_w edu_w2 year ind_w2)
	keep if womentype1!=.
	
	sort womentype1
	by womentype1: egen dum_datanew = max(data)
	by womentype1: egen dum_data1new = max(data1)
	keep if dum_datanew==1 & dum_data1new==1
	
	drop same_agegroup
	gen same_agegroup = 0
	replace same_agegroup = 1 if agediff<=2.52+3.42 & agediff>=2.52- 3.42

	gen one = 1
	sort womentype1
	by womentype1: egen count = sum(data1)
	by womentype1: egen count1 = sum(one)
	gen p_w = count/count1
	
	replace same_edu   = same_edu/(1-p_w) 
	replace same_div   = same_div/(1-p_w) 
	replace same_loca  = same_loca/(1-p_w) 
	replace same_HT    = same_HT/(1-p_w) 
	replace same_agegroup = same_agegroup/ (1-p_w)
	replace same_edu2   = same_edu2/(1-p_w) 
	replace same_ind2   = same_ind2/(1-p_w) 
	
	gen r = uniform() 
	sort womentype1 data1 r
	by womentype1 data1 : egen sq = seq()
	keep if sq<=count

		
	psmatch2 data1, pscore(pscore0) outcome(same_agegroup) common noreplacement	
	gen delta_agegroup = same_agegroup - _same_agegroup if _support==1
	rbounds delta_agegroup, gamma(1 (0.01) 3)            

	psmatch2 data1, pscore(pscore0) outcome(same_loca) common noreplacement	
	gen delta_loca = same_loca - _same_loca if _support==1
	rbounds delta_loca, gamma(1 (0.01) 3)            
	
	psmatch2 data1, pscore(pscore0) outcome(same_HT) common noreplacement	
	gen delta_HT = same_HT - _same_HT if _support==1
	rbounds delta_HT, gamma(1 (0.01) 2)            

	psmatch2 data1, pscore(pscore0) outcome(same_edu2) common noreplacement	
	gen delta_edu2 = same_edu2 - _same_edu2 if _support==1
	rbounds delta_edu2, gamma(1 (0.01) 3)            
  
  	psmatch2 data1, pscore(pscore0) outcome(same_ind2) common noreplacement	
	gen delta_ind2 = same_ind2 - _same_ind2 if _support==1
	rbounds delta_ind2, gamma(1 (0.01) 3)            
	}
	

