#######################################################################################
##   MPI routines   for Laroque-Salanie,                           #####################
##           Identifying the Response of Fertility to Financial Incentives #############
##          (Journal of Applied Econometrics)                      #####################
##################   THIS IS AN R PROGRAM RUN UNDER MPI            #####################
##################    IT REQUIRES PACKAGES RMPI AND SNOW           #####################
########################################################################################


########################################################################################
####        MANY OF THE ROUTINES BELOW COMPUTE BOTH A VECTOR         ###################
####          AND ITS DERIVATIVES IF GR IS TRUE                      ###################
####         THEY RETURN A LIST*VECTOR,DERIVATIVES)                 ###################
########################################################################################


########################################################################################
##############       LABOR SUPPLY FOR GIVEN FERTILITY                          #########
###                 argument (R_1F-R_0F-DLS_F)/tauls_F                         #########
########################################################################################


########################################################################################
######     COMPUTE DLS for given F=f                   #################################
########################################################################################

dlsf <- function(x,agd,xdc,xd1,r00,r01,nobs,f,gr) {
  debugfn <- (debug & F)
  dspl <- fsplval(agdls,x[1:5],agd,T)
  dlsc <- dspl[[1]]+xdc %*% x[6:15]
  dls1 <- xd1 %*% x[16:21]
  dval <- as.numeric(dlsc+dls1*f)
  dder <- 0
  if (gr) {
    dder <- matrix(0,nobs,npls)
    dder[,1:5] <- dspl[[2]]
    dder[,6:15] <- xdc
    dder[,16:21] <- xd1*f
    if (debugfn) {
      cat("Done dlsf gradient for f=",f,"\n")
    }
  }
  list(dval,dder)
}

########################################################################################
######     COMPUTE TAULS for given F=f                   ###############################
########################################################################################

taulsf <- function(x,agd,xtc,xt1,nobs,f,gr) {
  debugfn <- (debug & F)
  tauspl <- fsplval(agdls,x[22:26],agd,T)
  taulsc <- tauspl[[1]]+xtc %*% x[27:29]
  tauls1 <- xt1 %*% x[30:32]
  tauval <- as.numeric(taulsc +tauls1*f)
  tauder <- 0
  if (gr) {
    tauder <- matrix(0,nobs,npls)
    tauder[,22:26] <- tauspl[[2]]
    tauder[,27:29] <- xtc
    tauder[,30:32] <- xt1*f
    if (debugfn) {
      cat("Done taulsf gradient for f=",f,"\n")
    }
  }
  list(tauval,tauder)
}


########################################################################################
######     COMPUTE XTHLS=(dr-dls)/tauls                #################################
########################################################################################

xthls <- function(tauls,dls,dr,gr)  {
  debugfn <- (debug & F & gr)  
  dlsval <- dls[[1]]
  tauval <- tauls[[1]]
  x <- (dr-dlsval)/tauval
  dx <- 0
  if (gr) {
    dlsder <- dls[[2]]
    tauder <- tauls[[2]]
    if (debugfn) {
      cat("In xthls gradient\n")
      cat("dlsder:\n")
      print(str(dlsder))
      cat("tauval:\n")
      print(str(tauval))
      cat("tauder:\n")      
      print(str(tauder))
      cat("x:\n")      
      print(str(x))      
    }
    dx <- -(dlsder/tauval)-(tauder*(x/tauval))
    if (debugfn) {
      cat("Done xthls gradient\n")
    }
  }
  list(x,dx)
}


########################################################################################
##############                              FERTILITY                          #########
########################################################################################


########################################################################################
## compute argument of fertility logit,       ##########################################
##  and its gradient wrt V0 and V1,           ##########################################
##  and its gradient wrt the parameters if gr is TRUE  #################################
########################################################################################

## each  argument will be of the form 
###         (splvd+X_a theta_a)*a+(splv0+X_b theta_b)*b+(splvc+X_c theta_c)
## hence we will use the routine argfert that computes this value
##       and its derivatives in a, b, and the th's
  

argfert <- function(splvd,splv0,splvc,dsplvd,dsplv0,dsplvc,Xa,tha,Xb,thb,Xc,thc,a,b,gr) {
  debugfn <- (debug & F)    
  if (NROW(tha) > 1) {
    Xatha <-  Xa %*% tha
  }
  if (NROW(thb) > 1) {
    Xbthb <-  Xb %*% thb
  }
  if (NROW(thc) > 1) {
    Xcthc <-  Xc %*% thc
  }
  if (NROW(tha) == 1) {
    Xatha <-  Xa*tha
  }
  if (NROW(thb) == 1) {
    Xbthb <-  Xb*thb
  }
  if (NROW(thc) == 1) {
    Xcthc <-  Xc*thc
  }
  dxfa <- splvd+Xatha
  dxfb <- splv0+Xbthb
  xf <- dxfa*a+dxfb*b+(splvc+Xcthc)

  dxftha <- 0
  dxfthb <- 0
  dxfthc <- 0
  dxfthsd <- 0
  dxfths0 <- 0
  dxfthsc <- 0      
  if (gr) {
    dxftha <- Xa*a
    dxfthb <- Xb*b
    dxfthc <- Xc
    dxfthsd <- dsplvd*a
    dxfths0 <- dsplv0*b
    dxfthsc <- dsplvc    
    if (debugfn) {
      cat("Done argfert gradient\n")
    }
  }
  ## we return
  list(xf,dxfa,dxfb,dxftha,dxfthb,dxfthc,dxfthsd,dxfths0,dxfthsc)
}


xthfert <- function(x,v0,v1,datafert,gr) {
  debugfn <- (debug & F)
  nobs <- NROW(datafert)
  a <- as.numeric(v1[[1]]-v0[[1]])         ## a is V_1-V_0 
  b <- as.numeric(v0[[1]])                 ## b is V_0


  agd <- datafert[,1]
  dipsup <- datafert[,2]
  notmarr <- datafert[,3]
  agdnm <- datafert[,4]
  agds <- datafert[,5]
  resgen <- datafert[,6]
  zag1 <- datafert[,7]
  zag2 <- datafert[,8]
  zag3 <- datafert[,9]
  zag4 <- datafert[,10]
  zag5 <- datafert[,11]
  zag6 <- datafert[,12]
  ssmf <- datafert[,13]
  ssfm <- datafert[,14]
  f7to10 <- datafert[,15]
  parity1 <- datafert[,16]
  parity2 <- datafert[,17]
  parity3 <- datafert[,18]

  ## unwrap the splines and their derivatives
  splvd1 <- datafert[,19]
  splv01 <- datafert[,20]
  splvc1 <- datafert[,21]
  dsplvd1 <- datafert[,22:24]
  dsplv01 <- datafert[,25:27]
  dsplvc1 <- datafert[,28:30]
  splvd2 <- datafert[,31]
  splv02 <- datafert[,32]
  splvc2 <- datafert[,33]
  dsplvd2 <- datafert[,34:36]
  dsplv02 <- datafert[,37:39]
  dsplvc2 <- datafert[,40:42]
  splvd3 <- datafert[,43]
  splv03 <- datafert[,44]
  splvc3 <- datafert[,45]
  dsplvd3 <- datafert[,46:48]
  dsplv03 <- datafert[,49:51]
  dsplvc3 <- datafert[,52:54]

  splssmf <- datafert[,55]
  dsplssmf <- datafert[,56:58]
  splssfm <- datafert[,59]
  dsplssfm <- datafert[,60:62]

## parity 1
  Xa1 <- dipsup
  tha1 <- x[10]
  Xb1 <- dipsup
  thb1 <- x[11]
  Xc1 <- cbind(notmarr,dipsup,agdnm,agds,resgen)
  thc1 <- x[c(46:49,71)]
  
  arg1 <- argfert(splvd1,splv01,splvc1,dsplvd1,dsplv01,dsplvc1,Xa1,tha1,Xb1,thb1,Xc1,thc1,a,b,gr)
  xf1 <- arg1[[1]]
  dxf1a <- arg1[[2]]
  dxf1b <- arg1[[3]]
  dxf1tha <- arg1[[4]]
  dxf1thb <- arg1[[5]]
  dxf1thc <- arg1[[6]]
  dxf1thsd <- arg1[[7]]
  dxf1ths0 <- arg1[[8]]
  dxf1thsc <- arg1[[9]]      

  dxf1th <- matrix(0,nobs,npfert)  
  if (gr) {
    ## derivatives wrt coefficients of splines
    dxf1th[,1:3] <- dxf1thsd
    dxf1th[,4:6] <- dxf1ths0
    dxf1th[,7:9] <- dxf1thsc
    ## derivatives wrt other parameters
    dxf1th[,10] <- as.numeric(dxf1tha)
    dxf1th[,11] <- as.numeric(dxf1thb)
    dxf1th[,c(46:49,71)] <- dxf1thc
  }


  ## now parity 2
  Xa2 <- cbind(zag1,zag2,zag3,dipsup)
  tha2 <- x[21:24]
  Xb2 <- Xa2
  thb2 <- x[25:28]
  Xc2 <- cbind(notmarr,dipsup,agdnm,agds,zag1,zag2,zag3,zag4,zag5,zag6,resgen)
  thc2 <- x[c(50:59,72)]
  
  arg2 <- argfert(splvd2,splv02,splvc2,dsplvd2,dsplv02,dsplvc2,Xa2,tha2,Xb2,thb2,Xc2,thc2,a,b,gr)
  xf2 <- arg2[[1]]
  dxf2a <- arg2[[2]]
  dxf2b <- arg2[[3]]
  dxf2tha <- arg2[[4]]
  dxf2thb <- arg2[[5]]
  dxf2thc <- arg2[[6]]  
  dxf2thsd <- arg2[[7]]
  dxf2ths0 <- arg2[[8]]
  dxf2thsc <- arg2[[9]]      

  dxf2th <- matrix(0,nobs,npfert)  
  if (gr) {
    ## derivatives wrt coefficients of splines
    dxf2th[,12:14] <- dxf2thsd
    dxf2th[,15:17] <- dxf2ths0
    dxf2th[,18:20] <- dxf2thsc
    ## derivatives wrt other parameters
    dxf2th[,21:24] <- dxf2tha
    dxf2th[,25:28] <- dxf2thb
    dxf2th[,c(50:59,72)] <- dxf2thc
  }


  ## parity 3
  Xa3 <- cbind(zag1,zag2,zag3,dipsup)
  tha3 <- x[38:41]
  Xb3 <- Xa3
  thb3 <- x[42:45]
  Xc3 <- cbind(notmarr,dipsup,agdnm,agds,
               zag1,zag2,zag3,zag4,zag5,zag6,f7to10,resgen)
  thc3 <- x[c(60:70,73)]
  
  arg3 <- argfert(splvd3,splv03,splvc3,dsplvd3,dsplv03,dsplvc3,
                  Xa3,tha3,Xb3,thb3,Xc3,thc3,a,b,gr)
  xf3 <- arg3[[1]]
  ## for parity 3 we add the gender*age instruments
  xf3 <- xf3+splssmf*ssmf+splssfm*ssfm
  dxf3a <- arg3[[2]]
  dxf3b <- arg3[[3]]
  dxf3tha <- arg3[[4]]
  dxf3thb <- arg3[[5]]
  dxf3thc <- arg3[[6]]
  dxf3thsd <- arg3[[7]]
  dxf3ths0 <- arg3[[8]]
  dxf3thsc <- arg3[[9]]      

  dxf3th <- matrix(0,nobs,npfert)  
  if (gr) {
    ## derivatives wrt coefficients of splines
    dxf3th[,29:31] <- dxf3thsd
    dxf3th[,32:34] <- dxf3ths0
    dxf3th[,35:37] <- dxf3thsc
    ## derivatives wrt other parameters
    dxf3th[,38:41] <- dxf3tha
    dxf3th[,42:45] <- dxf3thb
    dxf3th[,c(60:70,73)] <- dxf3thc
    dxf3th[,74:76] <- dsplssmf*ssmf
    dxf3th[,77:79] <- dsplssfm*ssfm
  }
  
  xf <- xf1*parity1+xf2*parity2+xf3*parity3
  
  ## reconstruct derivatives wrt (V_0,V_1,th)
  dxf1 <- cbind(dxf1b-dxf1a,dxf1a,dxf1th)
  dxf2 <- cbind(dxf2b-dxf2a,dxf2a,dxf2th)
  dxf3 <- cbind(dxf3b-dxf3a,dxf3a,dxf3th)

  dxf <- dxf1*parity1+dxf2*parity2+dxf3*parity3

  if (debugfn) {
    cat("dxf:\n")
    print(str(dxf))
  }
  ## we return
  list(xf,dxf)
}

#########################################################
## probability of fertility     #########################
#########################################################

pfert <- function(x,v0,v1,datafert,gr) {
  debugfn <- (debug & T & gr)
  xp <- xthfert(x,v0,v1,datafert,gr)
  xpval <- as.numeric(xp[[1]])
  xpder <- as.matrix(xp[[2]])  
  p <- pnorm(xpval)
  dp <- 0
  if (gr) {
    dp <- xpder*dnorm(xpval)
    dpls <- v0[[2]]*dp[,1]+v1[[2]]*dp[,2]
    dpfert <- dp[,3:(npfert+2)]
    dp <- cbind(dpls,dpfert)
  }
  if (debugfn) {
    cat("Done pfert\n")
  }
  list(p,dp) 
}

#############################################################################################
## function J computes (XTHFERT-u) for V0(u), V1(u)     #####################################
##       and its derivative wrt u,                      #####################################
##  and its derivative wrt the  parameters if gr=TRUE   #####################################
#############################################################################################

jfunc <- function(u,x,xthlse0,tauls0,r00,xthlse1,tauls1,r01,
	parity1,parity2,parity3,datafert,gr) {
  debugfn <- (debug & F & gr)  
  if (debugfn) {
    cat("entering jfunc, gr=",gr,"\n")
  }
  ## correlations depend on parities
  bigc0 <- x[npfert-5]*parity1+x[npfert-3]*parity2+x[npfert-1]*parity3
  bigc1 <- x[npfert-4]*parity1+x[npfert-2]*parity2+x[npfert]*parity3
  ## new xthls, with the translation due to the correlation
  xthls0val <- xthlse0[[1]]-bigc0*u
  xthls1val <- xthlse1[[1]]-bigc1*u
  xthls0 <- list(xthls0val,xthlse0[[2]])
  xthls1 <- list(xthls1val,xthlse1[[2]])
  tauls0val <- tauls0[[1]]
  tauls1val <- tauls1[[1]]
  ## the normalized Emax's are
  v0 <-  bigv(xthls0,tauls0,r00,gr)
  v1 <-  bigv(xthls1,tauls1,r01,gr)
  ## the probas of working are
  pls0 <- pnorm(xthls0val)
  pls1 <- pnorm(xthls1val)
  if (debugfn) {
    cat("jfunc, gr=",gr,": before xp\n")
  }
  ## argument of fertility
  xp <- xthfert(x,v0,v1,datafert,gr)
  if (debugfn) {
    cat("jfunc, gr=",gr,": after xp\n")
  }
  ## its derivatives in v0 and v1
  dxpv0 <- xp[[2]][,1]
  dxpv1 <- xp[[2]][,2]
  ## value of J
  valj <- xp[[1]]-u
  ## derivative wrt parameters
  derp <- 0
  if (gr) {
    v0d <- v0[[2]]
    v1d <- v1[[2]]
    ## of labor supply
    derpls <- v0d*dxpv0+v1d*dxpv1
    if (debugfn) {
      cat("Did derpls\n")
    }
    ## of fertility
    derpf <- xp[[2]][,(3:(npfert+2))]
    if (debugfn) {
      cat("Did derpf\n")
    }
    ##  for bigc0 and bigc1
    dbigc0 <- -dxpv0*pls0*tauls0val*u
    derpf[,(npfert-5)] <- dbigc0*parity1
    derpf[,(npfert-3)] <- dbigc0*parity2
    derpf[,(npfert-1)] <- dbigc0*parity3
    dbigc1 <- -dxpv1*pls1*tauls1val*u
    derpf[,(npfert-4)] <- dbigc1*parity1
    derpf[,(npfert-2)] <- dbigc1*parity2
    derpf[,npfert] <- dbigc1*parity3
    ## combine
    derp <- cbind(derpls,derpf)
    if (debugfn) {
      cat("Did derp\n")
      print(str(derp))
    }    
  }
  ## we return
  list(valj,derp,xthls0,xthls1)
}



##########################################################################
## Compute the four probabilities P00, P01, P10 and P11  #################
## and their gradients wrt the parameters if gr is TRUE  #################
##########################################################################

fourprobs <- function(dataMPI,x,gr) {
  debugfn <- (debug & T & gr)

  xls <- x[1:npls]
  xfert <- x[(npls+1):nparams]
  
  xdc <- dataMPI[,1:10]
  xd1 <- dataMPI[,11:16]
  xtc <- dataMPI[,17:19]
  xt1 <- dataMPI[,20:22]

  datafert <- dataMPI[,c(23:40,65:108)]

  agd <- dataMPI[,23]
  parity1 <- dataMPI[,38]
  parity2 <- dataMPI[,39]
  parity3 <- dataMPI[,40]
  r00 <- dataMPI[,41]
  r01 <- dataMPI[,42]
  r10e <- dataMPI[,43]
  r11e <- dataMPI[,44]
  r10 <- dataMPI[,45:54]
  r11 <- dataMPI[,55:64]

  ourweight <- dataMPI[,109]

  nobs <- NROW(dataMPI)

  p00sim <- numeric(nobs)
  p01sim <- numeric(nobs)
  p10 <- numeric(nobs)
  p11 <- numeric(nobs)
  dp00 <- matrix(0,nobs,nparams)
  dp01 <- matrix(0,nobs,nparams)
  dp10 <- matrix(0,nobs,nparams)
  dp11 <- matrix(0,nobs,nparams)
  
  if (debugfn) {
    cat("In fourprobs with gr=",gr,"\n")
    cat("nparams=",nparams,"\n")
  }
  
  ## labor supply components
  tauls0 <- taulsf(xls,agd,xtc,xt1,nobs,0,gr)
  tauls1 <- taulsf(xls,agd,xtc,xt1,nobs,1,gr)
  dls0 <- dlsf(xls,agd,xdc,xd1,r00,r01,nobs,0,gr)
  dls1 <- dlsf(xls,agd,xdc,xd1,r00,r01,nobs,1,gr)

  
  ## argument of labor supply for employees
  xthlse0 <- xthls(tauls0,dls0,r10e-r00,gr)
  xthlse1 <- xthls(tauls1,dls1,r11e-r01,gr)
  xthlse0val <- xthlse0[[1]]
  xthlse1val <- xthlse1[[1]]

	
  for (iu in 1:m) {
    jcalc <- jfunc(epsbar[iu],xfert,xthlse0,tauls0,r00,xthlse1,tauls1,
		r01,parity1,parity2,parity3,datafert,gr)
    jval <- jcalc[[1]]
    tpos <- testpos(jval)
    tposval <- as.numeric(tpos[[1]])
    xthls0 <- jcalc[[3]]
    xthls1 <- jcalc[[4]]
    xthls0val <- as.numeric(xthls0[[1]])
    xthls1val <- as.numeric(xthls1[[1]])
    plse0 <- pnorm(xthls0val)
    plse1 <- pnorm(xthls1val)

    p11 <- p11+tposval*plse1
    p10 <- p10+(1-tposval)*plse0
    p00sim <- p00sim+(1-tposval)*(1-plse0)
    p01sim <- p01sim+tposval*(1-plse1)
    if (gr) {
      tposder <- as.numeric(tpos[[2]])
      jderp <- as.matrix(jcalc[[2]])
      xthls1der <- as.matrix(xthls1[[2]])
      dp11 <- dp11+jderp*(plse1*tposder) 
      dp11[,1:npls] <- dp11[,1:npls]+
		xthls1der*(dnorm(xthls1val)*tposval)
      dp11[,(nparams-4)] <- dp11[,(nparams-4)]-
		tposval*dnorm(xthls1val)*parity1*epsbar[iu]
      dp11[,(nparams-2)] <- dp11[,(nparams-2)]-
		tposval*dnorm(xthls1val)*parity2*epsbar[iu]
      dp11[,nparams] <- dp11[,nparams]-
		tposval*dnorm(xthls1val)*parity3*epsbar[iu]
      dp10 <- dp10-jderp*(plse0*tposder)
      dp10[,1:npls] <- dp10[,1:npls]+
			xthls0[[2]]*(dnorm(xthls0val)*(1-tposval))
      dp10[,(nparams-5)] <- dp10[,(nparams-5)]-
			(1-tposval)*dnorm(xthls0val)*parity1*epsbar[iu]
      dp10[,(nparams-3)] <- dp10[,(nparams-3)]-
			(1-tposval)*dnorm(xthls0val)*parity2*epsbar[iu]
      dp10[,(nparams-1)] <- dp10[,(nparams-1)]-
			(1-tposval)*dnorm(xthls0val)*parity3*epsbar[iu]
    }
  }
  
  p00sim <- p00sim/m
  p01sim <- p01sim/m
  p11 <- p11/m
  p10 <- p10/m
  dp11 <- dp11/m
  dp10 <- dp10/m

  if (debugfn) {
    cat("Done employees\n")
  }

  ## for non-employees
  cter00 <- numeric(nobs)
  cter01 <- numeric(nobs)
  cter10 <- numeric(nobs)
  cter11 <- numeric(nobs)
  dcter00 <- matrix(0,nobs,nparams)
  dcter01 <- matrix(0,nobs,nparams)

  for (isim in 1:10) {
    xthlsn0 <- xthls(tauls0,dls0,r10[,isim]-r00,gr)
    xthlsn1 <- xthls(tauls1,dls1,r11[,isim]-r01,gr)
    for (iu in 1:m) {
      jcalc <- jfunc(epsbar[iu],xfert,xthlsn0,tauls0,r00,
		xthlsn1,tauls1,r01,parity1,parity2,parity3,datafert,gr)
      jval <- jcalc[[1]]
      tpos <- testpos(jval)
      tposval <- as.numeric(tpos[[1]])
      xthls0 <- jcalc[[3]]
      xthls1 <- jcalc[[4]]
      xthls0val <- as.numeric(xthls0[[1]])            
      xthls1val <- as.numeric(xthls1[[1]])            
      plsn0 <- pnorm(xthls0val)
      plsn1 <- pnorm(xthls1val)
      cter00 <- cter00+(1-tposval)*(1-plsn0)
      cter01 <- cter01+tposval*(1-plsn1)
      cter10 <- cter10+(1-tposval)*plsn0
      cter11 <- cter11+tposval*plsn1
      if (gr) {
        tposder <- as.numeric(tpos[[2]])
        jderp <- as.matrix(jcalc[[2]])
        xthls0der <- as.matrix(xthlsn0[[2]])
        xthls1der <- as.matrix(xthlsn1[[2]])
        dcter00 <- dcter00-jderp*((1-plsn0)*tposder)
        dcter00[,1:npls] <- dcter00[,1:npls]-xthls0der*(dnorm(xthls0val)*(1-tposval))
        dcter00[,(nparams-5)] <- dcter00[,(nparams-5)]+
			(1-tposval)*dnorm(xthls0val)*parity1*epsbar[iu]
        dcter00[,(nparams-3)] <- dcter00[,(nparams-3)]+
			(1-tposval)*dnorm(xthls0val)*parity2*epsbar[iu]
        dcter00[,(nparams-1)] <- dcter00[,(nparams-1)]+
			(1-tposval)*dnorm(xthls0val)*parity3*epsbar[iu]
        dcter01 <- dcter01+jderp*((1-plsn1)*tposder)
        dcter01[,1:npls] <- dcter01[,1:npls]-
			xthls1der*(dnorm(xthls1val)*tposval)
        dcter01[,(nparams-4)] <- dcter01[,(nparams-4)]+
			tposval*dnorm(xthls1val)*parity1*epsbar[iu]
        dcter01[,(nparams-2)] <- dcter01[,(nparams-2)]+
			tposval*dnorm(xthls1val)*parity2*epsbar[iu]
        dcter01[,nparams] <- dcter01[,nparams]+
			tposval*dnorm(xthls1val)*parity3*epsbar[iu]
			}
		}
	}
			
  cter01 <- cter01/m
  cter00 <- cter00/m
  cter11 <- cter11/m
  cter10 <- cter10/m
  dcter01 <- dcter01/m
  dcter00 <- dcter00/m
  
  prmin <- 1-10*ourweight  ## proba below min wage
  ## for these guys L=0; v0=r00 and v1=r01,
  ##  F=1 iff a1*r01+a0*r00+c+dS > c1
  ## argument of fertility
  v00 <- list(r00,matrix(0,nobs,npls))
  v01 <- list(r01,matrix(0,nobs,npls))
  cat("Before pfert\n")
  pfmin <- pfert(xfert,v00,v01,datafert,gr)
    cat(" after pfert\n")
  pfminval <- pfmin[[1]]
  p00 <- ourweight*cter00+prmin*(1-pfminval)
  p01 <- ourweight*cter01+prmin*pfminval


  ## p11sim, p10sim have nothing under min wage for non-employees
  p11sim <- cter11*ourweight
  p10sim <- cter10*ourweight
  
  if (gr) {
    pfminder <- as.matrix(pfmin[[2]])
    dp00 <- dcter00*ourweight-pfminder*prmin
    dp01 <- dcter01*ourweight+pfminder*prmin
  }

  if (debugfn) {
    cat("Done non-employees\n")
  }
  
  fpres <- cbind(p00,p01,p10,p11,p00sim,p01sim,p10sim,p11sim,dp00,dp01,dp10,dp11)

  ## we return
  fpres
}

###########################################################################
####  auxiliary routine, preparing allocation across processes          ###
###########################################################################

completeData <- function(x,data0) {
  xfert <- x[(npls+1):nparams]
  ## we need to compute the splines first

  fsplvald1 <- fsplval(agdsplp1,xfert[1:3],agd,T)
  fsplval01 <- fsplval(agdsplp1,xfert[4:6],agd,T)
  fsplvalc1 <- fsplval(agdsplp1,xfert[7:9],agd,T)

  splvd1 <- fsplvald1[[1]]
  splv01 <- fsplval01[[1]]
  splvc1 <- fsplvalc1[[1]]

  dsplvd1mpi <- fsplvald1[[2]]
  dsplv01mpi <- fsplval01[[2]]
  dsplvc1mpi <- fsplvalc1[[2]]

  fsplvald2 <- fsplval(agdsplp2,xfert[12:14],agd,T)
  fsplval02 <- fsplval(agdsplp2,xfert[15:17],agd,T)
  fsplvalc2 <- fsplval(agdsplp2,xfert[18:20],agd,T)

  splvd2 <- fsplvald2[[1]]
  splv02 <- fsplval02[[1]]
  splvc2 <- fsplvalc2[[1]]

  dsplvd2mpi <- fsplvald2[[2]]
  dsplv02mpi <- fsplval02[[2]]
  dsplvc2mpi <- fsplvalc2[[2]]
  
  fsplvald3 <- fsplval(agdsplp3,xfert[29:31],agd,T)
  fsplval03 <- fsplval(agdsplp3,xfert[32:34],agd,T)
  fsplvalc3 <- fsplval(agdsplp3,xfert[35:37],agd,T)

  splvd3 <- fsplvald3[[1]]
  splv03 <- fsplval03[[1]]
  splvc3 <- fsplvalc3[[1]]

  dsplvd3mpi <- fsplvald3[[2]]
  dsplv03mpi <- fsplval03[[2]]
  dsplvc3mpi <- fsplvalc3[[2]]
  
  fsplssmf <- fsplval(agdss,xfert[74:76],agd,T)
  fsplssfm <- fsplval(agdss,xfert[77:79],agd,T)

  splssmf <- fsplssmf[[1]]
  splssfm <- fsplssfm[[1]]

  dsplssmfmpi <- fsplssmf[[2]]
  dsplssfmmpi <- fsplssfm[[2]]

  ## we return a larger matrix
  cbind(data0,splvd1,splv01,splvc1,dsplvd1mpi,
	dsplv01mpi,dsplvc1mpi,
                  splvd2,splv02,splvc2,dsplvd2mpi,dsplv02mpi,dsplvc2mpi,
                  splvd3,splv03,splvc3,dsplvd3mpi,dsplv03mpi,dsplvc3mpi,
		splssmf,dsplssmfmpi,splssfm,dsplssfmmpi,ourweight)
}  


###################################################################
## Compute the four probas                   ######################
## and the gradients of the four observed probas if gr is TRUE ####
##   this routine only allocates the sample on the processes ######
##     and combines the results              ######################
###################################################################

fourprobspara <- function(x,ee,gr) {
  debugfn <- (debug & T)
  if (debugfn) {  
    cat("in fourprobspara, gr=",gr,"\n")
  }
  dataMPI <- completeData(x,dataMPI0)

  ## split sample over processors  roughly equally
  latafp <- vector("list",nprocs)
  dsplit <- clusterSplit(cl,seq(nobs))
  for (i in 1:nprocs) { 
    latafp[[i]] <- dataMPI[dsplit[[i]], ]
  }

  ## calculate on each subsample
  vallist <- clusterApply(cl, latafp, fourprobs, x, gr)

  ## combine subsample results
  fpres <- vallist[[1]]
  for (i in 2:nprocs) {
    fpres <- rbind(fpres,vallist[[i]])
  }

  
  p00 <- fpres[,1]
  p01 <- fpres[,2]
  p10 <- fpres[,3]
  p11 <- fpres[,4]
  p00sim <- p00*(1-ee)+fpres[,5]*ee
  p01sim <- p01*(1-ee)+fpres[,6]*ee
  p10sim <- p10*ee+fpres[,7]*(1-ee)
  p11sim <- p11*ee+fpres[,8]*(1-ee)
  probs <- list(p00,p01,p10,p11,p00sim,p01sim,p10sim,p11sim)
  dp00 <- fpres[,(8+(1:nparams))]
  dp01 <- fpres[,(8+nparams+(1:nparams))]
  dp10 <- fpres[,(8+2*nparams+(1:nparams))]
  dp11 <- fpres[,(8+3*nparams+(1:nparams))]
  dprobs <- list(dp00,dp01,dp10,dp11)

  ## we return
  list(probs,dprobs)
}



## keeps only the probability of fertility,
## and its gradienits if gr is TRUE
qfuncpara <- function(x,ee,gr) {
  debugfn <- (debug & T)
  ## need to compute splines first
  dataMPI <- completeData(x,dataMPI0)

  ## split sample over processors  roughly equally
  latafp <- vector("list",nprocs)
  dsplit <- clusterSplit(cl,seq(nobs))
  for (i in 1:nprocs) { 
    latafp[[i]] <- dataMPI[dsplit[[i]], ]
  }

  ## calculate on each subsample
  vallist <- clusterApply(cl, latafp, fourprobs, x, gr)

  ## combine subsample results
  fpres <- vallist[[1]]
  for (i in 2:nprocs) {
    fpres <- rbind(fpres,vallist[[i]])
  }

  ## probability of fertility and derivative
  p01 <- fpres[,2]
  p11 <- fpres[,4]
  p01sim <- p01*(1-ee)+fpres[,6]*ee
  p11sim <- p11*ee+fpres[,8]*(1-ee)
  pf <- p01sim+p11sim
  dp01 <- fpres[,(8+nparams+(1:nparams))]
  dp11 <- fpres[,(8+3*nparams+(1:nparams))]
  dpf <- dp01*(1-ee)+dp11*ee

  ## we return
  list(pf,dpf)
}

########################################################################################
####################    log-likelihood #################################################
########################################################################################

## value of log(L),  and its gradient if gr is TRUE
llder <- function(x,gr) {
  debugfn <- (debug & T)
  prander <-  fourprobspara(x,ee,gr)
  probs <- prander[[1]]
  p00 <- probs[[1]]
  p01 <-  probs[[2]]
  p10 <-  probs[[3]]
  p11 <-  probs[[4]]
  pl <-  p00*(1-fert)*(1-ee)+p01*fert*(1-ee)+
          p10*(1-fert)*ee+p11*fert*ee
  if (gr) {
    dprobs <- prander[[2]]
    dp00 <- matrix(0,nobs,nparams)
    dp01 <- matrix(0,nobs,nparams)
    dp10 <- matrix(0,nobs,nparams)
    dp11 <- matrix(0,nobs,nparams)
    dp00[,(1:nparams)] <-  dprobs[[1]]
    dp01[,(1:nparams)] <-  dprobs[[2]]
    dp10[,(1:nparams)] <-  dprobs[[3]]
    dp11[,(1:nparams)] <-  dprobs[[4]]
    dpl <- dp00*((1-fert)*(1-ee))+
      dp01*(fert*(1-ee))+
        dp10*((1-fert)*ee)+
          dp11*(fert*ee)
  }
  blpl <- log(pl)
  loglik <-  -sum(blpl)
  dloglik <- 0
  if (gr) {
    dloglik <- -dpl/pl
  }
  list(loglik,dloglik)
}


## the value of log(L) only
loglikfun <- function(x) {
  llder(x,F)[[1]]
}


## the gradient of log(L) only
llgrad <- function(x) {
  dobs <- llder(x,T)[[2]]
  ## we return
  colSums(dobs)
}



########################################################################################
## simulated probabilities,  labor supply and fertility ################################
########################################################################################

plsfertsimpara <- function(x,ee) {
  resus <- fourprobspara(x,ee,F)
  probs <- resus[[1]]
  p00sim <-  probs[[5]]
  p01sim <-  probs[[6]]
  p10sim <-  probs[[7]]
  p11sim <-  probs[[8]]

  ## we return
  vps <- matrix(0,NROW(p11sim),8)
  dimnames(vps) <- list(NULL,
                        c("P(L=0,F=0)", "P(L=0,F=1)",
                          "P(L=1,F=0)",
                          "P(L=1,F=1)","P(L=1)","P(F=1)","P(L=1|F=0)","P(L=1|F=1)"))
  vps[,1] <- p00sim
  vps[,2] <- p01sim
  vps[,3] <- p10sim
  vps[,4] <- p11sim
  vps[,5] <- p10sim+p11sim
  vps[,6] <- p01sim+p11sim
  vps[,7] <- p10sim/(p10sim+p00sim)
  vps[,8] <- p11sim/(p11sim+p01sim)
  vps
}

