########################################################################################
##         Auxiliary routines for Laroque-Salanie,                 #####################
##           Identifying the Response of Fertility to Financial Incentives #############
##          (Journal of Applied Econometrics)                      #####################
##################   THIS IS AN R PROGRAM                          #####################
########################################################################################

library(numDeriv)

## check gradient gradanal of scalar function lfun at pinit
checkgradscal <- function(lfun,gradanal,pinit,epsg=0.0001) {

  dlanal <- gradanal(pinit)

## using numDeriv
  dlnum <- grad(lfun,pinit)

  cat("Checking gradient: \n")

  nparams <- NROW(pinit)

  for(i in 1:nparams) {
    cat("i  <-  ", i, ": num <-  ", dlnum[i],
        ", anal  <-  ", dlanal[i], "\n")
  }
  list(dlnum,dlanal)
}

## given the values basevals, at basepts,
## evaluate spline at ptvals, 
## also returns the  derivative
##   of the interpolated values
##   wrt to the basevals
##   if gr is TRUE


fsplval <- function(basepts,basevals,ptvals,gr,epsg=0.0001) {
  nbv <- NROW(basevals)
  nobs <- NROW(ptvals)
  spl <- splinefun(basepts,basevals,
                   method = "natural")
  splval <- spl(ptvals)
  dspl <- 0
  if (gr) {
    dxp <- (1+abs(basevals))*epsg
    dspl <- matrix(0,nobs,nbv)
    for (i in 1:nbv) {
      xp <- basevals
      xp[i] <- basevals[i]+dxp[i]
      splp <- splinefun(basepts,xp,
                        method = "natural")
      splpv <- splp(ptvals)
      dspl[,i] <- (splpv-splval)/dxp[i]
    }
  }
  list(splval,dspl)
}



## print nl line(s) with stars and then possibly a string and a line of stars

pstarline <- function(nl=1,str='') {
  cat("\n")
  for (i in 1:nl) {
    cat("     ********************************************* \n")
  }
  if (str != '') {
    cat(str)
    pstarline()
  }
  cat("\n")
}


## integrated kernel Heaviside
testpos <- function(x,h=0.05) {
    tval <- 1/(1+exp(-x/h))
    tder <- tval*(1-tval)/h
    list(tval,tder)
}



## the Emax(x-n,0) function for n=N(0,1) 
bigh <- function(x,gr) {
    xv <- x[[1]]
    h <- xv*pnorm(xv)+dnorm(xv)
    dh <- 0
    if (gr) {
        dh <- pnorm(xv)
    }
    list(h,dh)
}

## bigv is tau*bigh(x)+r

bigv <- function(x,tau,r,gr) {
    bh <- bigh(x,gr)
    tauval <- tau[[1]]
    hval <- bh[[1]]
    v <- hval*tauval+r
    dv <- 0
    if (gr) {
        dx <- x[[2]]
        tauder <- tau[[2]]
        hder <- bh[[2]]
        dv <- dx*(hder*tauval)+tauder*hval
    }
    list(v,dv)
}



########################################################################
#####  the following three routines manage the interface with Snow   ###
########################################################################




## start Snow on K nodes
startsnow <- function(K) {
  cl <- makeMPIcluster(K)
  print(clusterInfo(cl,c("nodename","machine")))
  cl
}


## get information on each computing node
clusterInfo <- function(cl,...) {
  info <- function(...) Sys.info()[...]
  infoList <- clusterCall(cl, info,...)
  do.call("rbind", infoList)
}

## tell nodes about variable  or function name

informNodes <- function(cl,v) {
  clusterExport(cl,deparse(substitute(v)))
}

