
********************************************************************************
/*	 
	 Revisiting Gender Identity and Relative Income within Households –
	A cautionary tale on the potential pitfalls of density estimators.

		Daniel Kuehnle, Michael Oberfichtner, Kerstin Ostermann
						 Last update: March 2021
								
					 Dofile for the German analyses
					 - generates panels of Figure 3
						
*******************************************************************************/

cap log close
log using $log\4_Figure3.txt, text replace

set scheme s2mono

clear all
use $data\2_merge.dta


********************************************************************************
*Analysis preparation
********************************************************************************

gen all = 1

* generate variables that are filled in loop
gen share = .
lab var share "Share earned by the wife"
gen relfemshare=  .
lab var relfemshare "Share of couples"

*x-axis
global fs "fem_share"

* Make snapshot of data
snapshot erase _all
snapshot save, label(before_loop)

* Groups
global groups west NoEqInc_West east NoEqInc_East 

foreach group in $groups {

snapshot restore 1
* Insert sample restriction here
quietly keep if `group' == 1
disp r(N_drop) "  couples dropped due to group"

local size = 0.001
local bp = 0.500001
local bp100k = `bp'*1000000
local n_bins = 1 / `size'

//Shares
quietly count if inrange($fs,0,1) // couples with 0 and 1 are set to . earlier
local __N = r(N)

quietly foreach num of numlist 1/`n_bins' {
	replace share = `num' / `n_bins' - 0.5 * `size' in `num'
	count if $fs > (`num' - 1) * `size' & $fs <= `num' * `size'
	replace relfemshare = r(N) / `__N' in `num'
}

//DCdensity default
cap drop Xj Yj r0 fhat se_fhat
DCdensityRR $fs,  breakpoint(`bp') generate(Xj Yj r0 fhat se_fhat) 

//rddensity 
cap drop RD*
cap drop zoom
rddensity $fs , c(`bp') plot plot_range(0 1) plot_n(500 500) ///
            genvars(RD) plot_grid(es)  ///
	graph_options(xtitle("Share earned by the wife") ///
	ytitle("Density") legend(off) ///
	graphregion(col(white)icol(white)) ///
	plotregion(col(white)icol(white)))

*store relevant information
sum relfemshare if share>=0.45 & share<=0.55
	local scaling = r(max)/r(mean) + 0.15 
	local up_share = `scaling' * r(mean)
sum RD_f if RD_grid>=0.45  & RD_grid <0.55
	local up_dens = `scaling' * r(mean)

*Panel A to D 
twoway (line RD_f RD_grid if RD_group == 0 & RD_grid>=0.45, yaxis(1) lcolor(black) lpattern(solid))  ///
            (line RD_f RD_grid if RD_group == 1 & RD_grid<=0.55, yaxis(1) lcolor(black) lpattern(solid))  ///
		(line fhat r0 if r0<=`bp' & r0>=0.45, lcolor(black) lpattern(dash))  ///
			(line fhat r0 if r0>`bp' & r0<=0.55, lcolor(black) lpattern(dash)) ///
		(scatter relfemshare share if share>=0.45 & share<=0.55,  yaxis(2) msymbol(circle_hollow) mcolor(black)) ///
            , xline(`bp') ytitle("Density") xtitle("Share earned by the wife") /// 
			yscale(range(0  `up_dens') axis(1)) yscale(range(0  `up_share') axis(2)) ///
			ylabel(#7, axis(1))	ylabel(#7, axis(2)) ///
			xscale(range(0.45 (0.02) 0.55)) xlabel(0.46 (0.02) 0.54) /// 
            legend(off) ///
            graphregion(col(white)icol(white)) ///
            plotregion(col(white)icol(white))
graph export "$log\4_Figure3_panels_IEB_`group'.png", replace as(png)
				
}
			
log close 
			