
********************************************************************************
/*	 
	 Revisiting Gender Identity and Relative Income within Households –
	A cautionary tale on the potential pitfalls of density estimators.

		Daniel Kuehnle, Michael Oberfichtner, Kerstin Ostermann
						 Last update: March 2021
								
					 Dofile for the German analyses
						- preparation file
						
*******************************************************************************/

cap log close
log using $log\2_merge.txt, text replace

// Merge couple IDs to IEB 
* Load IEB
use "$orig\a014118_ieb_konten.dta"

* keep spells which contain June 30 2008
keep if ieb_beg_orig < date("30/06/08","DM20Y") & ieb_end_orig > date("30/06/08","DM20Y")

* keep observations from couples
merge m:1 prs_id using $data\1_paar_ids.dta
sort pair_id _merge
by pair_id: gen m1 = _merge[1]
keep if m1 == 3
drop m1


* keep couples with employment spell
sort pair_id ieb_quellverf_id
by pair_id: keep if ieb_quellverf_id[_N]==1


* keep individuals with one spell
bysort prs_id: gen m1=_N
sort pair_id m1
by pair_id: keep if m1[_N]==1
drop m1

by pair_id: gen m1=_N
tab m1
drop m1

* Check sex distribution within couple
sort pair_id sex_id
by pair_id: gen sex1=sex_id[1]
by pair_id: gen sex2=sex_id[2]
tab sex1 sex2
drop if sex1==sex2
drop sex1 sex2


* sum wage spells and parallel wage 
bysort prs_id: egen labor_income = total(ieb_tag_entg) //are identical in our sample


* keep couples working either both in East or both in West Germany
tab ow_knz_num
sort pair_id ow_knz_num
by pair_id: keep if ow_knz_num[_N]==ow_knz_num[1]

* generate indicators for East and West Germany
gen west = 1 if ow_knz_num == 1
replace west = 0 if ow_knz_num == 2
gen east = 1 - west

* Keep only couples in which both partners are more than marginally employed
* and earn below the ssc ceiling (2008: 63,600 Euro annually) 
sort pair_id labor_income
by pair_id: keep if labor_income[1] > 13.5 // 400 euro per mont = 13.11 per day
by pair_id: keep if labor_income[_N] < 172.50 // exakt: 173.77

* Additionally drop couples with mini-job by employment status
tab ieb_erw_stat_num 
gen mini_job = .
replace mini_job = 1 if ieb_erw_stat_num == 209 | ieb_erw_stat_num == 109
sort pair_id mini_job
by pair_id: replace mini_job = 1 if mini_job[1] == 1 
replace mini_job = 0 if mini_job == .


* Compute wifes income share
sort pair_id sex_id
by pair_id: egen fam_income = total(labor_income)
gen fem_share = labor_income / fam_income if sex_id == 2

* Only couples in which both earn positive income (see Bertrand et al., notes to Figure 1)
replace fem_share = . if fem_share ==0 | fem_share == 1

* Only couples in which both are age 18-65
gen age = (date("30jun2008", "DMY") - geb_dat) / 365.25
sort pair_id age
by pair_id: replace fem_share = . if age[1]<18 | age[2] >= 66

* Check for very similar daily wages (range of 0.1 percent)
count if inrange(fem_share,0.499,.501)
sum labor_income if inrange(fem_share,0.499,.501) & fem_share<., d 
count if  labor_income <=13.11 & inrange(fem_share,0.499,.501)

* histogram
histogram fem_share if fem_share>0.25 & fem_share <0.75, xline(.5)
histogram fem_share if fem_share>0.45 & fem_share <0.55 & west == 1, xline(.5)
histogram fem_share if fem_share>0.45 & fem_share <0.55 & east == 1, xline(.5)

count if west == 1
count if west == 1 & inrange(fem_share,0.499,.501)

count if east == 1
count if east == 1 & inrange(fem_share,0.499,.501)

*exact same income
count if fem_share==0.5

gen NoEqInc = fem_share!=0.5 
gen NoEqInc_East = fem_share!=0.5 & east==1
gen NoEqInc_West = fem_share!=0.5 & west==1


save $data\2_merge.dta, replace