********************************************************************************
/*	 
	 Revisiting Gender Identity and Relative Income within Households –
	A cautionary tale on the potential pitfalls of density estimators.

		Daniel Kuehnle, Michael Oberfichtner, Kerstin Ostermann
						 Last update: March 2021
								
						Dofile for the German analyses
						
						
*******************************************************************************/
***
* Person identifieres in the data change over time (errors are corrected, duplicates identfied etc.)
* As the couple identifier is based on an older version of the data than we use in our analysis
* we need to take such changes into account and restrict the sample to persons for whom the 
* identifier was not corrected in the meantime.

cap log close
log using $log\1_paar_ids, text replace
clear all

use "$orig\a014118_rel_prs_v901_prs_v1201.dta", clear
codebook
bysort prs_id_v901: gen m1 = _N   
tab1 m*
keep if m1 == 1
bysort prs_id_v1201: gen m2 = _N   
tab1 m*
keep if m2 == 1


bysort pair_id: gen m3 = _N
tab1 m*
keep if m3 == 2

tab1 m*

rename prs_id_v1201 prs_id
drop prs_id_v901 m1 m2 m3
codebook
save $data\1_paar_ids.dta, replace
clear all

log close
