
% function  [gamma_hat,A_hat,B_hat,std_A_hat_standard,std_A_hat_robust,...
%     std_B_hat_standard,std_B_hat_robust,sigma_u_bar,var_standard,... 
%     var_robust,u_bar,p_est,q_est] = varma_estimaton_final_ar_orders(y,delta,c_0,m_T,max_p,max_q,n_T,fix_p,fix_q,est_orders)

function  [gamma_hat,A_hat,B_hat,u_bar,p_est,q_est] = varma_estimaton_final_ar_orders(y,delta,c_0,m_T,max_p,max_q,n_T,fix_p,fix_q,est_orders)

% -----------------------------------------------------
%             VARMA FINAL AR FORM ESTIMATION
% -----------------------------------------------------

% INPUTS:
% y      - KxT series
% delta  -
% c_0    -
% m_T    -
% max_p  - maximum AR lag order (1x1)
% max_q  - maximum MA lag order (1x1)
% n_T    - long VAR order
% fix_p  - fixed AR lag order
% fix_q  - fixed MA lag order
% est_orders - 1 if want to estimate lag orders in VARMA process for factor
%              0 if fixed lag orders

[K,T] = size(y);

nb_par = max_q+max_p*K^2;
big_P = max_p;
big_Q = max_q;

matrix_critere = zeros(big_P+1, big_Q+1);

    % Step 1
  [pi_hat,u_hat] = step1(y, n_T);

  if est_orders == 1
  
  % Selection of p and q
  for i=0:big_P
    for j=0:big_Q
      if ( ((i==0) && (j==0)) )
        matrix_critere(1+i,1+j) = log(det((y * y') /T));
        %mat_denis(jjj,1+i,1+j) = log(det((y * y') /T));
      else
        [gamma_tilde,critere,A_tilde,B_tilde] = step2_final_AR(y,n_T,u_hat,i,j,delta,c_0);
        matrix_critere(1+i,1+j) = critere(1);
        %mat_denis(jjj,1+i,1+j) = critere(2);
      end
    end
  end
  
  [tutu,q_opt] = min(min(matrix_critere));
  [tutu,p_opt] = min(min(matrix_critere'));
  
  % Estimates of p and q are
    p_est = p_opt-1;
    q_est = q_opt-1;

  elseif est_orders == 0
      
      p_est = fix_p;
      q_est = fix_q;
      
  end;
    
  % Step 2
  [gamma_tilde,critere,A_tilde,B_tilde] = step2_final_AR(y, n_T, u_hat, p_est, q_est, delta, c_0);

  % Step 3
%   [gamma_hat,A_hat,B_hat,std_A_hat_standard,std_A_hat_robust,std_B_hat_standard,std_B_hat_robust,sigma_u_bar, ...
%    var_standard, var_robust,u_bar] = step3_final_AR(y,A_tilde,B_tilde,p_est,q_est,m_T);
    
    [gamma_hat,A_hat,B_hat,u_bar] = step3_final_AR_simulation(y,A_tilde,B_tilde,p_est,q_est,m_T);

