
% function  [gamma_hat,A_hat,B_hat,std_A_hat_standard,std_A_hat_robust,...
%     std_B_hat_standard,std_B_hat_robust,sigma_u_bar,var_standard,... 
%     var_robust,u_bar,p_est,q_est] = varma_estimaton_diag_ar_orders(y,delta,c_0,m_T,max_p,max_q,n_T,fix_p,fix_q,est_orders)

function  [gamma_hat,A_hat,B_hat,u_bar,p_est,q_est] = varma_estimaton_diag_ar_orders(y,delta,c_0,m_T,max_p,max_q,n_T,fix_p,fix_q,est_orders)


% -----------------------------------------------------
%             VARMA DIAGONAL AR FORM ESTIMATION
% -----------------------------------------------------

% INPUTS:
% y      - KxT series
% delta  -
% c_0    -
% m_T    -
% max_p  - maximum AR lag order (Kx1)
% max_q  - maximum MA lag order (1x1)
% n_T    - long VAR order
% fix_p  - fixed AR lag order
% fix_q  - fixed MA lag order
% est_orders - 1 if want to estimate lag orders in VARMA process for factor
%              0 if fixed lag orders 

[K,T] = size(y);

nb_par = sum(max_p)+max_q*K^2;
big_P = max_p;
big_Q = max_q;

  % Step 1
  [pi_hat,u_hat] = step1(y, n_T);

  if est_orders == 1
  
  % Selection of p and q
  p_opt = zeros(K, 1);
  q_opt = zeros(K, 1);
  
  for k=1:K
    matrix_critere = zeros(big_P(k)+1, big_Q+1);
    
    for i=0:big_P(k)
      for j=0:big_Q
        if ( ((i==0) && (j==0)) )
          matrix_critere(1+i,1+j) = log((y(k,:) * y(k,:)') /T);
          %mat_denis(jjj, k, i+1, j+1) = log((y(k,:) * y(k,:)') /T);
        else
          [gamma_tilde,critere] = step2_diagonal_AR_k(y,n_T,u_hat,i,j,k,delta,c_0);
          matrix_critere(i+1,j+1) = critere(1);
          %mat_denis(jjj,k, i+1, j+1) = critere(2);
        end
      end
    end
    [tutu,q_opt(k)] = min(min(matrix_critere));
    [tutu,p_opt(k)] = min(min(matrix_critere'));
  end
  
  % Estimates of p and q are
    p_est = p_opt-ones(K,1);
    q_est = max(q_opt)-1;
  
%     for i=1:K
%     reserve_pq(jjj,i) = p_opt(i)-1;
%   end
%   reserve_pq(jjj,K+1) = max(q_opt)-1;
  
  elseif est_orders==0
      
      p_est = fix_p;
      q_est = fix_q;
  end;

  % Step 2
  [gamma_tilde,critere,A_tilde,B_tilde] = step2_diagonal_AR(y, n_T, u_hat, p_est, q_est, delta, c_0);
  %reserve_step2(jjj,:) = repack_estimates_diagonal_AR(A_tilde, B_tilde);

  % Step 3
  [gamma_hat,A_hat,B_hat,u_bar] = step3_diagonal_AR_simulation(y,A_tilde,B_tilde,p_est,q_est,m_T);

