function [MSPE,MAPE,PR2,THEIL,Tbiais,Tvar,Tcov,Sign,Y_hat,eps,Yhat_density] = tpassfilter3(Y,X1,X2,X3,h,R,p,rollwind,tcode,Density)
% Fait le 3passfilter de Kelly et Pruitt (2011)



% INPUT
% Y: Variable � pr�dire (Tx1)  
% X: Variable d'information (TxN)  
% p: nombre de retasrd pour la cr�ation des proixis (retard de y)
% h: horizon de la pr�vision
% R: Taille de la fen�tre d'estimation
% rollwind: Type de fen�tre
%           1: glissante
%           2: croissante
% tcode: Type de pr�vision/transformation
%           1: y_t
%           2: (y_t-y_{t-h})/h
%           3: (y_t-y_{t-h})/h - (y_t-h - y_t-h-1)
%           4: ln(y_t)
%           5: (ln(y_t)-ln(y_{t-h}))/h
%           6: (ln(y_t)-ln(y_{t-h}))/h - (ln(y_t-h) - ln(y_t-h-1))




% OUTPUT
% MSPE: Moyenne des erreurs de pr�vision au carr�
% MAPE: Moyenne des erreurs de pr�vision absolue
% PR2: Pseudo R^2
% THEIL: Coefficient de Theil
% Tbiais: Biais proportion de Theil
% Tvar: Variance proportion de Theil
% Tcov: Covariance proportion de Theil
% Sign: Test de signes de Perasan et Timmermann (1992)

% Yhat: T-R pr�vision de la variable d'int�r�t
% eps: erreur de pr�vision

N1 = size(X1,2);
N2 = size(X2,2);
N3 = size(X3,2);


if N3 > 0
    ncase = 3;
elseif N2 > 0
    ncase = 2;
else
    ncase = 1;
end


% Transformation selon tcode
if tcode == 1
    Yg = Y; % Y_1 � Y_t-h+1
    Yd = Y; % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 2  
    Yg = [NaN(h,1);(Y(h+1:end,1)-Y(1:end-h))/h];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;diff(Y)]; % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 3
    Yg = (Y(h+1:end)-Y(1:end-h))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(Y(1+1:end-h) - Y(1:end-h-1))];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;NaN;diff(Y,2)]; % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 4
    Yg = log(Y); % Y_1 � Y_t-h+1
    Yd = log(Y); % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 5  
    Yg = [NaN(h,1);(log(Y(h+1:end,1))-log(Y(1:end-h)))/h];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;diff(log(Y))]; % Y_1 � Y_t-h+1
    drop = 2;
else
    Yg = (log(Y(h+1:end))-log(Y(1:end-h)))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(log(Y(1+1:end-h)) - log(Y(1:end-h-1)))];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;NaN;diff(log(Y),2)]; % Y_1 � Y_t-h+1
    drop = 2;
end


T = size(Y,1);
Out_s = T-R;
Kd = length(Density);

% Keep y real values for the prediction error
real_y = Yg(R+1:end);

% Output object
Y_hat = zeros(Out_s,1);
Yhat_density = NaN(Out_s,length(Density));


% Beginning loop
dataRange = 1:R-h+1;  % -h puisqu'on n'a pas les derni�res h obs h p�riode en avance, avec h = 1, 1:R pour pr�voir l'obs suivant directement la fenetre d'estimation
for t = 1:Out_s
   
   if rollwind == 1 
        if t < drop+1
            drop1 = drop-(t-1); %puisque le le nombre d'obs manquantes d�pend de l'it�ration pour rolling
        else
            drop1 = 0;
        end
    else
        drop1 = drop;  % puisque le nombre d'obs � dropper ne d�pend pas de l'it�ration dans le cas d'expending
    end
    
    YYg = Yg(dataRange,1); % Y_1 � Y_t-h+1
    YYd = Yd(dataRange,1); % Y_1 � Y_t-h+1
    
    
    XX1 = X1(dataRange,:);
    XX1 = XX1(1+drop1:end,:);
    XX1  = zscore(XX1(:,~any(isnan(XX1),1)));
    XX1 = unique(XX1','rows');
    XX1 = XX1';
    
    [TT,NN1] = size(XX1);
    % set Y lag   
     [Y1,Ylag] = lagML2(YYd(1+drop1:end,1),p); 
      Ylag = [Y1(p:end,1), Ylag(p:end,1:end-1)];
    
    
    % Case 1
    
            %3pass
            % 1�re �tape
            alpha1 = zeros(p+1,NN1);
            for i = 1:NN1
                alpha1(:,i) = [ones(size(Ylag,1),1) Ylag]\XX1(p:end,i);
            end

            % 2�me �tape
            delta1 = zeros(p+1,TT);
            for tt = 1:TT
                delta1(:,tt) = [ones(NN1,1) alpha1(2:end,:)']\XX1(tt,:)';
            end
            
            % Pour 3�me �tape
            DELTA1 =  delta1(2:end,1:end-h)'; 
            DELTA2 = [];
            DELTA3 = [];
            
            % Pour la pr�vision
            ff1 = delta1(2:end,end)';
            ff2 = [];
            ff3 = [];
           
           
    if ncase == 2
    % Case 2    
            XX2 = X2(dataRange,:);
            XX2 = XX2(1+drop1:end,:);
            XX2  = zscore(XX2(:,~any(isnan(XX2),1)));
            XX2 = unique(XX2','rows');
            XX2 = XX2';
            [TT,NN2] = size(XX2);
    
            %3pass
            % 1�re �tape
            alpha2 = zeros(p+1,NN2);
            for i = 1:NN2
                alpha2(:,i) = [ones(size(Ylag,1),1) Ylag]\XX2(p:end,i);
            end


            % 2�me �tape
            delta2 = zeros(p+1,TT);
            for tt = 1:TT
                delta2(:,tt) = [ones(NN2,1) alpha2(2:end,:)']\XX2(tt,:)';
            end
            
            % Pour 3�me �tape
            DELTA2 =  delta2(2:end,1:end-h)';
            
            % Pour pr�visison
            ff2 = delta2(2:end,end)';
            
    elseif ncase == 3
    % Case 3
            XX3 = X3(dataRange,:);
            XX3 = XX3(1+drop1:end,:);
            XX3  = zscore(XX3(:,~any(isnan(XX3),1)));
            XX3 = unique(XX3','rows');
            XX3 = XX3';
            [TT,NN3] = size(XX3);
            
            %3pass
            % 1�re �tape
            alpha3 = zeros(p+1,NN3);
            for i = 1:NN3
                alpha3(:,i) = [ones(size(Ylag,1),1) Ylag]\XX3(p:end,i);
            end

            % 2�me �tape
            delta3 = zeros(p+1,TT);
            for tt = 1:TT
                delta3(:,tt) = [ones(NN3,1) alpha3(2:end,:)']\XX3(tt,:)';
            end
            
            % Pour 3�me �tape
            DELTA3 =  delta3(2:end,1:end-h)'; 
            
            % Pour pr�vision
            ff3 = delta3(2:end,end)';
  
    end
    
    % 3�me �tape
    beta = [ones(size(DELTA1,1),1) DELTA1 DELTA2 DELTA3]\YYg(h+1+drop1:end,1);    
    
    % Sigma2
    par = length(beta);
    ttt = length(YYg(h+1+drop1:end,1));
    yin = [ones(size(DELTA1,1),1) DELTA1 DELTA2 DELTA3]*beta;
    res = YYg(h+1+drop1:end,1)-yin;
    sigma2 = res'*res/(ttt-par);
    sigma = sqrt(sigma2);
    
    
    % Pr�vision de Y_t+1 
    fcast = [1 ff1 ff2 ff3]*beta;
    Y_hat(t,1) = fcast;
    
%    for dd = 1:Kd
 %       Yhat_density(tt,dd) = Y_hat(tt,1)+Density(dd)*sigma;
  %  end

    
    
  if rollwind == 1
      dataRange = dataRange +1;
  elseif rollwind == 0
      dataRange = 1:R-h+1+t;
  end                                        
end
  
eps  = real_y-Y_hat; 

% Calcul des m�triques

% M�triques de base
MSPE = mean(eps.^2);
MAPE = mean(abs(eps));

% Coefficients de Theil
THEIL  = sqrt(MSPE)/(sqrt(mean(Y_hat.^2))+sqrt(mean(real_y.^2)));
Tbiais = ((mean(Y_hat)-mean(real_y))^2)/MSPE;
Tvar   = ((std(Y_hat)-std(real_y))^2)/MSPE;
Tcov   = (2*(1-corr(Y_hat,real_y))*std(Y_hat)*std(real_y))/MSPE;


%Test de signes de Perasan et Timmermann (1992) (seulement pour variable en
%diff�rence)
if tcode == 1 | tcode == 4
    Sign = NaN;
else
    
n = size(real_y,1);

[real_pos,junk] = find(real_y>0);
[pred_pos,junk] = find(Y_hat>0);
[positive,junk] = find(real_y>0 & Y_hat>0);

rho_y = mean(real_pos);
rho_x = mean(pred_pos);
rhohat = mean(positive);
rhohat_star = rho_y*rho_x+(1-rho_y)*(1-rho_x);

Vrho = rhohat_star*(1-rhohat_star)/n;
Vrho_star = (2*rho_y-1)^2*rho_x*(1-rho_x)/n + (2*rho_x-1)^2*rho_y*(1-rho_y)/n + 4*rho_y*rho_x*(1-rho_y)*(1-rho_x)/(n^2);

Sign = (rhohat-rhohat_star)/sqrt(Vrho-Vrho_star);

end

% Pseudo R^2

[MSPEmean,junk,junk,junk] = meanforecast(Y,R,h,rollwind,tcode);
PR2 = 1 - MSPE/MSPEmean;



end