function [gamma_hat,A_hat,B_hat,u_bar] = step3_final_AR_simulation(y,A_tilde,B_tilde,p,q,m_T)

[K,T] = size(y);
nb_par = p+q*K^2;

u_tilde = zeros(K,T);
big_Z = cell(T,1); for t=1:T; big_Z(t) = { zeros(K,nb_par) }; end;
big_V = cell(T,1);  for t=1:T; big_V(t) = { zeros(K,nb_par) }; end;
big_X = zeros(K,T);
big_W = zeros(K,T);
part1 = zeros(nb_par,nb_par);
part2 = zeros(nb_par,1);
u_bar = zeros(K,T);
v_t_moins1_sigma_u_bar = zeros(nb_par,T);
I_hat = zeros(nb_par,nb_par);
A_hat = cell(max(1,p),1);
B_hat = cell(max(1,q),1);


% Construct the filtered residuals from the second step estimates
for t=max(p,q)+1:T
  u_tilde(:,t) = y(:,t);
  
  for i=1:p
    u_tilde(:,t) = u_tilde(:,t) - A_tilde{i}*y(:,t-i);
  end
  
  for j=1:q
    u_tilde(:,t) = u_tilde(:,t) + B_tilde{j}*u_tilde(:,t-j);
  end
end
sigma_u_tilde = (u_tilde * u_tilde') ./ T;
inv_sigma_u_tilde = inv(sigma_u_tilde);

l = max(p,q);

tutu_B_tilde = zeros(K,K);
for t=l+1:T
  big_Z{t}(:,1:p) = y(:,t-p:t-1);
  
  if (q > 0)
    temp_u_tilde = reshape(u_tilde(:,t-q:t-1),1,K*q);
    big_Z{t}(:,p+1:nb_par) = -kron_eye(K,temp_u_tilde);
  end

  tutu_V = big_Z{t};
  big_X(:,t) = y(:,t);
  big_W(:,t) = u_tilde(:,t);
  for j=1:q
    tutu_V = tutu_V + B_tilde{j}*big_V{t-j};
    big_X(:,t) = big_X(:,t) + B_tilde{j}*big_X(:,t-j);
    big_W(:,t) = big_W(:,t) + B_tilde{j}*big_W(:,t-j);
  end
  big_V(t) = { tutu_V };
  
  part1 = part1 + tutu_V'*inv_sigma_u_tilde*tutu_V;
  part2 = part2 + tutu_V'*inv_sigma_u_tilde*(u_tilde(:,t)+big_X(:,t)-big_W(:,t));
end

gamma_hat = part1 \ part2;

% Construct the matrices A_hat and B_hat

for i=1:p
  A_hat(i) = { eye(K) .* gamma_hat(p+1-i) };
end

for order=1:q
  B_hat(order) = { zeros(K,K) };
end
compteur = 1;

for row=1:K
  for order=q:-1:1
    for col=1:K
      B_hat{order}(row,col) = gamma_hat(p+compteur);
      compteur = compteur+1;
    end
  end
end

% Compute the filtered residuals

for t=max(p,q)+1:T
  u_bar(:,t) = y(:,t);
  
  for i=1:p;
    u_bar(:,t) = u_bar(:,t) - A_hat{i}*y(:,t-i);
  end
  
  for j=1:q
    u_bar(:,t) = u_bar(:,t) + B_hat{j}*u_bar(:,t-j);
  end
end





