function [gamma_tilde,critere] = ...
    step2_diagonal_MA_k(y, n_T, u_hat, p, q, k, delta, c_0)

%% Input:
%% -y: time series, dimension K x T
%% n_t: order of the first-step VAR
%% u_hat: residuals from the first-step VAR
%% p: order of the AR part of the VARMA
%% q: order of the MA part of the VARMA
%% delta: parameter in the information criterion
%% c_0: parameter in the information criterion
%%
%% Output:
%% -gamma_tilde: the vector of estimates
%% -critere: value of the information criterion
%% -A_tilde: AR estimates of the VARMA, dimension: p x K x K
%% -B_tilde: MA estimates of the VARMA, dimension: q x K x K

[K,T] = size(y);
nb_par = p*K+q;
l = n_T + max(p,q);

big_X = zeros(T-l,nb_par);

for j=1:K
  for i=1:p
    big_X(:,(j-1)*p+i) = y(j,l+1-i:T-i);
  end
end

for i=1:q
  big_X(:,p*K+i) = -u_hat(k,l+1-i:T-i)';
end

big_Y = y(k,l+1:end)';

gamma_tilde = (big_X'*big_X) \ (big_X'*big_Y);

% residuals of the regression
residuals = big_Y - big_X*gamma_tilde;

% Evaluation of the information criterion
sigma_critere = (residuals'*residuals) ./ (T-l);

critere = zeros(2,1);
critere(1) = log(det(sigma_critere)) + c_0 * ( nb_par*log(T)^(1+delta) ) / T;
critere(2) = log(det(sigma_critere));