function [gamma_tilde,critere,A_tilde,B_tilde] = ...
    step2_diagonal_AR(y, n_T, u_hat, p, q, delta, c_0)

%% Input:
%% -y: time series, dimension K x T
%% n_t: order of the first-step VAR
%% u_hat: residuals from the first-step VAR
%% p: order of the AR part of the VARMA
%% q: order of the MA part of the VARMA
%% delta: parameter in the information criterion
%% c_0: parameter in the information criterion
%%
%% Output:
%% -gamma_tilde: the vector of estimates
%% -critere: value of the information criterion
%% -A_tilde: AR estimates of the VARMA, dimension: p x K x K
%% -B_tilde: MA estimates of the VARMA, dimension: q x K x K

[K,T] = size(y);
nb_par = sum(p)+q*K^2;
max_p = max(p);

big_Z = cell(T,1); for t=1:T; big_Z(t) = {zeros(K, nb_par)}; end;
part1 = zeros(nb_par,nb_par);
part2 = zeros(nb_par,1);
A_tilde = cell(max(1,max_p),1);
B_tilde = cell(max(1,q),1);
residuals = zeros(K,T);

sigma_u_hat = (u_hat*u_hat') / T;
inv_sigma_u_hat = inv(sigma_u_hat);

l = n_T + max(max_p,q);

for t=l+1:T
  for j=1:K
    big_Z{t}(j,sum(p(1:j-1))+1:sum(p(1:j))) = y(j,t-p(j):t-1);
  end

  if (q > 0)
    temp_u_hat = reshape(u_hat(:,t-q:t-1),1,K*q);
    big_Z{t}(:,sum(p)+1:end) = -kron_eye(K,temp_u_hat);
  end
      
  part1 = part1+ big_Z{t}' * inv_sigma_u_hat * big_Z{t};
  part2 = part2+ big_Z{t}' * inv_sigma_u_hat * y(:,t);
end
  
gamma_tilde = part1 \ part2;

% construct the matrices A_tilde and B_tilde from gamma_tilde_int
for order=1:max_p
  A_tilde(order) = { zeros(K,K) };
end

for i=1:K
  for order=p(i):-1:1
    A_tilde{order}(i,i) = gamma_tilde(sum(p(1:i))+1-order);
  end
end

for order=1:q
  B_tilde(order) = { zeros(K,K) };
end
compteur = 1;

for row=1:K
  for order=q:-1:1
    for col=1:K
      B_tilde{order}(row,col) = gamma_tilde(sum(p)+compteur);
      compteur = compteur+1;
    end
  end
end


% residuals of the regression
for t=l+1:T
  residuals(:,t) = y(:,t) - big_Z{t} * gamma_tilde;
end

% Evaluation of the information criterion
sigma_critere = (residuals * residuals') ./ T;

critere = zeros(2,1);
critere(1) = log(det(sigma_critere)) + c_0 * ( nb_par*log(T)^(1+delta) ) / T;
critere(2) = log(det(sigma_critere));