function [pi_hat,u_hat] = step1(y, n_T)

%%  Input:
%%  -y: time series, dimension K x T
%%  -n_T: the order of the VAR
%% 
%%  Output:
%%  -pi_hat: VAR estimates, dimension K*n_T x K
%%  -u_hat: the residuals with same dimensions than y. The initial residuals are zero

[K,T] = size(y);

var_expli = zeros(T-n_T,K*n_T);
u_hat = zeros(K, T);

var_dep = y(:,n_T+1:T)';

for i=1:n_T
  var_expli(:,(i-1)*K+1:i*K) = y(:,n_T+1-i:T-i)';
end

pi_hat = (var_expli'*var_expli) \ (var_expli'*var_dep);
u_hat(:,n_T+1:T) = (var_dep - var_expli*pi_hat)';
