function [keep,beta] = softreshold(Yh,Yt,X,p,k)
% Choisi quelles sries  inclure dans l'ACP avec le softresholding de Bai
% et Ng (2008) Journal of econometrics

% Yh: Taux cumul
% Yt: L'autre
% X: N variables  considrer pour l'ACP  (X_1  X_t-h+1) +1 pour itration
% p: nombre de lag de Y (Bai et Ng le fixent  4)
% X et Y suppos avoir le mme nombre de lignes
% k: nombre de variables  choisir pour calculer facteurs  (il y a aussi
% une faon statistique de le choisir, plus tard)

N = size(X,2);

[W,Wlag] = lagML2(Yt,p); 
W = [ones(size(W,1),1) W(:,1), Wlag(:,1:end-1)];


[Xi,junk] = lagML2(X,1);  
YWX = [Yh,W,Xi];
YWX = YWX(~any(isnan(YWX),2),:);

% obtenir de ce que les lag de Y et la constante ne prdit de Xi
beta2 = YWX(:,2:size(W,2)+1)\YWX(:,size(W,2)+2:end);   
resX = YWX(:,size(W,2)+2:end) - YWX(:,2:size(W,2)+1)*beta2;

 % obtenir ce que les lag de Y et la constante ne prdit pas de Y
beta1 = YWX(:,2:size(W,2)+1)\YWX(:,1);   
resY = YWX(:,1) - YWX(:,2:size(W,2)+1)*beta1; % ce que les lags de Y ne prdisent pas, ni la constante


[beta fitinfo] = lasso(resX,resY); 



number = NaN(1,size(beta,2));

% Trouver quelle colonne contient k valeurs diffrentes de 0
for uu = 1:size(beta,2);

    num = find(beta(:,uu)~=0);
    num = size(num,1);
    number(1,uu) = num;
end

dif = abs(k-number);
[junk, minimum_dif] = find(dif==min(dif));
minimum_dif = minimum_dif(1);
keep = find(beta(:,minimum_dif)~=0);

end



