function [MSPE,MAPE,Y_hat,eps] = meanforecast(Y,R,h,rollwind,tcode)

% INPUT
% Y: Variable  prdire en premire colonne + autres variables
% h: horizon de la prvision
% R: Taille de la fentre d'estimation
% rollwind: Type de fentre
%           1: glissante
%           2: croissante
% tcode: Type de prvision/transformation
%           1: y_t
%           2: (y_t-y_{t-h})/h
%           3: (y_t-y_{t-h})/h - (y_t-h - y_t-h-1)
%           4: ln(y_t)
%           5: (ln(y_t)-ln(y_{t-h}))/h
%           6: (ln(y_t)-ln(y_{t-h}))/h - (ln(y_t-h) - ln(y_t-h-1))

% OUTPUT
% MSPE: Moyenne des erreurs de prvision au carr
% MAPE: Moyenne des erreurs de prvision absolue
% Yhat: T-R prvision de la variable d'intrt
% eps: erreur de prvision


% Transformation selon tcode
if tcode == 1
    Yg = Y; % Y_1  Y_t-h+1
elseif tcode == 2  
    Yg = [NaN(h,1);(Y(h+1:end,1)-Y(1:end-h))/h];   % (Y_h+1-Y_1)  (Y_t-h+1-Y_t-h+1-h)
elseif tcode == 3
    Yg = (Y(h+1:end)-Y(1:end-h))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(Y(1+1:end-h) - Y(1:end-h-1))];   % (Y_h+1-Y_1)  (Y_t-h+1-Y_t-h+1-h)
elseif tcode == 4
    Yg = log(Y); % Y_1  Y_t-h+1
elseif tcode == 5  
    Yg = [NaN(h,1);(log(Y(h+1:end,1))-log(Y(1:end-h)))/h];   % (Y_h+1-Y_1)  (Y_t-h+1-Y_t-h+1-h)
else
    Yg = (log(Y(h+1:end))-log(Y(1:end-h)))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(log(Y(1+1:end-h)) - log(Y(1:end-h-1)))];   % (Y_h+1-Y_1)  (Y_t-h+1-Y_t-h+1-h)
end


T = size(Y,1);
Out_s = T-R;


% Keep y real values for the prediction error
real_y = Yg(R+1:end);

% Output object
Y_hat = zeros(Out_s,1);



% Beginning loop
dataRange = 1:R-h+1;  % -h puisqu'on n'a pas les dernires h obs h priode en avance, avec h = 1, 1:R pour prvoir l'obs suivant directement la fenetre d'estimation
for tt = 1:Out_s
    
     
    YYg = Yg(dataRange,1); % Y_1  Y_t-h+1
    YYg = YYg(~any(isnan(YYg),2),:);
         
    iota = ones(size(YYg,1),1);
    beta = iota\YYg;
    
    % Prvision
    Y_hat(tt,1) = 1*beta;
      
      
  if rollwind == 1
      dataRange = dataRange +1;
  elseif rollwind == 0
      dataRange = 1:R-h+1+tt;
  end

end
  
eps  = real_y-Y_hat;  
MSPE = mean(eps.^2);
MAPE = mean(abs(eps));


end

